/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.inject;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.apache.logging.log4j.plugins.Node;
import org.apache.logging.log4j.plugins.PluginElement;
import org.apache.logging.log4j.plugins.inject.AbstractConfigurationInjector;
import org.apache.logging.log4j.plugins.util.PluginType;
import org.apache.logging.log4j.plugins.util.TypeUtil;

public class PluginElementInjector
extends AbstractConfigurationInjector<PluginElement, Object> {
    @Override
    public void inject(Object factory) {
        Optional<Class<?>> componentType = PluginElementInjector.getComponentType(this.conversionType);
        if (componentType.isPresent()) {
            Class<?> compType = componentType.get();
            ArrayList values = new ArrayList();
            ArrayList<Node> used = new ArrayList<Node>();
            this.debugLog.append("={");
            boolean first = true;
            for (Node child : this.node.getChildren()) {
                PluginType<?> type = child.getType();
                if (!this.name.equalsIgnoreCase(type.getElementName()) && !compType.isAssignableFrom(type.getPluginClass())) continue;
                if (!first) {
                    this.debugLog.append(", ");
                }
                first = false;
                used.add(child);
                Object childObject = child.getObject();
                if (childObject == null) {
                    LOGGER.warn("Skipping null object returned for element {} in node {}", (Object)child.getName(), (Object)this.node.getName());
                    continue;
                }
                if (childObject.getClass().isArray()) {
                    Object[] children = (Object[])childObject;
                    this.debugLog.append(Arrays.toString(children)).append('}');
                    this.node.getChildren().removeAll(used);
                    this.configurationBinder.bindObject(factory, children);
                    return;
                }
                this.debugLog.append(child.toString());
                values.add(childObject);
            }
            this.debugLog.append('}');
            if (!values.isEmpty() && !TypeUtil.isAssignable(compType, values.get(0).getClass())) {
                LOGGER.error("Cannot assign element {} a list of {} as it is incompatible with {}", (Object)this.name, values.get(0).getClass(), compType);
                return;
            }
            this.node.getChildren().removeAll(used);
            Object[] vals = (Object[])Array.newInstance(compType, values.size());
            for (int i = 0; i < vals.length; ++i) {
                vals[i] = values.get(i);
            }
            this.configurationBinder.bindObject(factory, vals);
        } else {
            Optional<Node> matchingChild = this.node.getChildren().stream().filter(this::isRequestedNode).findAny();
            if (matchingChild.isPresent()) {
                Node child = matchingChild.get();
                this.debugLog.append(child.getName()).append('(').append(child.toString()).append(')');
                this.node.getChildren().remove(child);
                this.configurationBinder.bindObject(factory, child.getObject());
            } else {
                this.debugLog.append(this.name).append("=null");
                this.configurationBinder.bindObject(factory, null);
            }
        }
    }

    private boolean isRequestedNode(Node child) {
        PluginType<?> type = child.getType();
        return this.name.equalsIgnoreCase(type.getElementName()) || TypeUtil.isAssignable(this.conversionType, type.getPluginClass());
    }

    private static Optional<Class<?>> getComponentType(Type type) {
        Class clazz;
        if (type instanceof Class && (clazz = (Class)type).isArray()) {
            return Optional.of(clazz.getComponentType());
        }
        return Optional.empty();
    }
}

