/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.mongodb2;

import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.nosql.NoSqlProvider;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAliases;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.convert.TypeConverters;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.ValidHost;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.ValidPort;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.apache.logging.log4j.core.util.NameUtil;
import org.apache.logging.log4j.mongodb2.MongoDbConnection;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="MongoDb2", category="Core", printObject=true)
@PluginAliases(value={"MongoDb"})
public final class MongoDbProvider
implements NoSqlProvider<MongoDbConnection> {
    private static final WriteConcern DEFAULT_WRITE_CONCERN = WriteConcern.ACKNOWLEDGED;
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final int DEFAULT_PORT = 27017;
    private static final int DEFAULT_COLLECTION_SIZE = 0x20000000;
    private final String collectionName;
    private final DB database;
    private final String description;
    private final WriteConcern writeConcern;
    private final boolean isCapped;
    private final Integer collectionSize;

    @Deprecated
    public static MongoDbProvider createNoSqlProvider(String collectionName, String writeConcernConstant, String writeConcernConstantClassName, String databaseName, String server, String port, String userName, String password, String factoryClassName, String factoryMethodName) {
        LOGGER.info("createNoSqlProvider");
        return ((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)MongoDbProvider.newBuilder())).setCollectionName(collectionName))).setWriteConcernConstant(writeConcernConstantClassName))).setWriteConcernConstant(writeConcernConstant))).setDatabaseName(databaseName))).setServer(server))).setPort(port))).setUserName(userName))).setPassword(password))).setFactoryClassName(factoryClassName))).setFactoryMethodName(factoryMethodName))).build();
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    private MongoDbProvider(DB database, WriteConcern writeConcern, String collectionName, boolean isCapped, Integer collectionSize, String description) {
        this.database = database;
        this.writeConcern = writeConcern;
        this.collectionName = collectionName;
        this.isCapped = isCapped;
        this.collectionSize = collectionSize;
        this.description = "mongoDb{ " + description + " }";
    }

    public MongoDbConnection getConnection() {
        return new MongoDbConnection(this.database, this.writeConcern, this.collectionName, this.isCapped, this.collectionSize);
    }

    public String toString() {
        return this.description;
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractFilterable.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<MongoDbProvider> {
        @PluginBuilderAttribute
        @ValidHost
        private String server = "localhost";
        @PluginBuilderAttribute
        @ValidPort
        private String port = "27017";
        @PluginBuilderAttribute
        @Required(message="No database name provided")
        private String databaseName;
        @PluginBuilderAttribute
        @Required(message="No collection name provided")
        private String collectionName;
        @PluginBuilderAttribute
        private String userName;
        @PluginBuilderAttribute(sensitive=true)
        private String password;
        @PluginBuilderAttribute(value="capped")
        private boolean isCapped = false;
        @PluginBuilderAttribute
        private int collectionSize = 0x20000000;
        @PluginBuilderAttribute
        private String factoryClassName;
        @PluginBuilderAttribute
        private String factoryMethodName;
        @PluginBuilderAttribute
        private String writeConcernConstantClassName;
        @PluginBuilderAttribute
        private String writeConcernConstant;

        private static WriteConcern toWriteConcern(String writeConcernConstant, String writeConcernConstantClassName) {
            WriteConcern writeConcern;
            if (Strings.isNotEmpty((CharSequence)writeConcernConstant)) {
                if (Strings.isNotEmpty((CharSequence)writeConcernConstantClassName)) {
                    try {
                        Class writeConcernConstantClass = LoaderUtil.loadClass((String)writeConcernConstantClassName);
                        Field field = writeConcernConstantClass.getField(writeConcernConstant);
                        writeConcern = (WriteConcern)field.get(null);
                    }
                    catch (Exception e) {
                        LOGGER.error("Write concern constant [{}.{}] not found, using default.", (Object)writeConcernConstantClassName, (Object)writeConcernConstant);
                        writeConcern = DEFAULT_WRITE_CONCERN;
                    }
                } else {
                    writeConcern = WriteConcern.valueOf((String)writeConcernConstant);
                    if (writeConcern == null) {
                        LOGGER.warn("Write concern constant [{}] not found, using default.", (Object)writeConcernConstant);
                        writeConcern = DEFAULT_WRITE_CONCERN;
                    }
                }
            } else {
                writeConcern = DEFAULT_WRITE_CONCERN;
            }
            return writeConcern;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public MongoDbProvider build() {
            String description;
            DB database;
            if (Strings.isNotEmpty((CharSequence)this.factoryClassName) && Strings.isNotEmpty((CharSequence)this.factoryMethodName)) {
                try {
                    Class factoryClass = LoaderUtil.loadClass((String)this.factoryClassName);
                    Method method = factoryClass.getMethod(this.factoryMethodName, new Class[0]);
                    Object object = method.invoke(null, new Object[0]);
                    if (object instanceof DB) {
                        database = (DB)object;
                    } else if (object instanceof MongoClient) {
                        if (!Strings.isNotEmpty((CharSequence)this.databaseName)) {
                            LOGGER.error("The factory method [{}.{}()] returned a MongoClient so the database name is required.", (Object)this.factoryClassName, (Object)this.factoryMethodName);
                            return null;
                        }
                        database = ((MongoClient)object).getDB(this.databaseName);
                    } else {
                        if (object == null) {
                            LOGGER.error("The factory method [{}.{}()] returned null.", (Object)this.factoryClassName, (Object)this.factoryMethodName);
                            return null;
                        }
                        LOGGER.error("The factory method [{}.{}()] returned an unsupported type [{}].", (Object)this.factoryClassName, (Object)this.factoryMethodName, (Object)object.getClass().getName());
                        return null;
                    }
                    description = "database=" + database.getName();
                    List addresses = database.getMongo().getAllAddress();
                    if (addresses.size() == 1) {
                        description = description + ", server=" + ((ServerAddress)addresses.get(0)).getHost() + ", port=" + ((ServerAddress)addresses.get(0)).getPort();
                    }
                    description = description + ", servers=[";
                    for (ServerAddress address : addresses) {
                        description = description + " { " + address.getHost() + ", " + address.getPort() + " } ";
                    }
                    description = description + "]";
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("The factory class [{}] could not be loaded.", (Object)this.factoryClassName, (Object)e);
                    return null;
                }
                catch (NoSuchMethodException e) {
                    LOGGER.error("The factory class [{}] does not have a no-arg method named [{}].", (Object)this.factoryClassName, (Object)this.factoryMethodName, (Object)e);
                    return null;
                }
                catch (Exception e) {
                    LOGGER.error("The factory method [{}.{}()] could not be invoked.", (Object)this.factoryClassName, (Object)this.factoryMethodName, (Object)e);
                    return null;
                }
            } else {
                if (!Strings.isNotEmpty((CharSequence)this.databaseName)) {
                    LOGGER.error("No factory method was provided so the database name is required.");
                    return null;
                }
                ArrayList<MongoCredential> credentials = new ArrayList<MongoCredential>();
                description = "database=" + this.databaseName;
                if (Strings.isNotEmpty((CharSequence)this.userName) && Strings.isNotEmpty((CharSequence)this.password)) {
                    description = description + ", username=" + this.userName + ", passwordHash=" + NameUtil.md5((String)(this.password + MongoDbProvider.class.getName()));
                    credentials.add(MongoCredential.createCredential((String)this.userName, (String)this.databaseName, (char[])this.password.toCharArray()));
                }
                try {
                    int portInt = (Integer)TypeConverters.convert((String)this.port, Integer.TYPE, (Object)27017);
                    description = description + ", server=" + this.server + ", port=" + portInt;
                    database = new MongoClient(new ServerAddress(this.server, portInt), credentials).getDB(this.databaseName);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to obtain a database instance from the MongoClient at server [{}] and port [{}].", (Object)this.server, (Object)this.port);
                    return null;
                }
            }
            try {
                database.getCollectionNames();
            }
            catch (Exception e) {
                LOGGER.error("The database is not up, or you are not authenticated, try supplying a username and password to the MongoDB provider.", (Throwable)e);
                return null;
            }
            WriteConcern writeConcern = Builder.toWriteConcern(this.writeConcernConstant, this.writeConcernConstantClassName);
            return new MongoDbProvider(database, writeConcern, this.collectionName, this.isCapped, this.collectionSize, description);
        }

        public B setCapped(boolean isCapped) {
            this.isCapped = isCapped;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setCollectionName(String collectionName) {
            this.collectionName = collectionName;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setCollectionSize(int collectionSize) {
            this.collectionSize = collectionSize;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setFactoryClassName(String factoryClassName) {
            this.factoryClassName = factoryClassName;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setFactoryMethodName(String factoryMethodName) {
            this.factoryMethodName = factoryMethodName;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setPassword(String password) {
            this.password = password;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setPort(String port) {
            this.port = port;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setServer(String server) {
            this.server = server;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setUserName(String userName) {
            this.userName = userName;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setWriteConcernConstant(String writeConcernConstant) {
            this.writeConcernConstant = writeConcernConstant;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setWriteConcernConstantClassName(String writeConcernConstantClassName) {
            this.writeConcernConstantClassName = writeConcernConstantClassName;
            return (B)((Object)((Builder)this.asBuilder()));
        }
    }
}

