/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.core.time.internal.format.FastDateFormat;
import org.apache.logging.log4j.layout.template.json.JsonTemplateLayoutDefaults;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolver;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverConfig;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;

final class TimestampResolver
implements EventResolver {
    private final EventResolver internalResolver;
    private static final EventResolver EPOCH_NANOS_RESOLVER = new EpochResolver(){

        @Override
        void resolve(Instant logEventInstant, JsonWriter jsonWriter) {
            long nanos = TimestampResolver.epochNanos(logEventInstant);
            jsonWriter.writeNumber(nanos);
        }
    };
    private static final EventResolver EPOCH_MILLIS_RESOLVER = new EpochResolver(){

        @Override
        void resolve(Instant logEventInstant, JsonWriter jsonWriter) {
            StringBuilder jsonWriterStringBuilder = jsonWriter.getStringBuilder();
            long nanos = TimestampResolver.epochNanos(logEventInstant);
            jsonWriterStringBuilder.append(nanos);
            jsonWriterStringBuilder.insert(jsonWriterStringBuilder.length() - 6, '.');
        }
    };
    private static final EventResolver EPOCH_MILLIS_ROUNDED_RESOLVER = new EpochResolver(){

        @Override
        void resolve(Instant logEventInstant, JsonWriter jsonWriter) {
            jsonWriter.writeNumber(logEventInstant.getEpochMillisecond());
        }
    };
    private static final EventResolver EPOCH_MILLIS_NANOS_RESOLVER = new EpochResolver(){

        @Override
        void resolve(Instant logEventInstant, JsonWriter jsonWriter) {
            long nanos = TimestampResolver.epochNanos(logEventInstant);
            long fraction = nanos % 1000000L;
            jsonWriter.writeNumber(fraction);
        }
    };
    private static final EventResolver EPOCH_SECS_RESOLVER = new EpochResolver(){

        @Override
        void resolve(Instant logEventInstant, JsonWriter jsonWriter) {
            StringBuilder jsonWriterStringBuilder = jsonWriter.getStringBuilder();
            long nanos = TimestampResolver.epochNanos(logEventInstant);
            jsonWriterStringBuilder.append(nanos);
            jsonWriterStringBuilder.insert(jsonWriterStringBuilder.length() - 9, '.');
        }
    };
    private static final EventResolver EPOCH_SECS_ROUNDED_RESOLVER = new EpochResolver(){

        @Override
        void resolve(Instant logEventInstant, JsonWriter jsonWriter) {
            jsonWriter.writeNumber(logEventInstant.getEpochSecond());
        }
    };
    private static final EventResolver EPOCH_SECS_NANOS_RESOLVER = new EpochResolver(){

        @Override
        void resolve(Instant logEventInstant, JsonWriter jsonWriter) {
            jsonWriter.writeNumber(logEventInstant.getNanoOfSecond());
        }
    };

    TimestampResolver(TemplateResolverConfig config) {
        this.internalResolver = TimestampResolver.createResolver(config);
    }

    private static EventResolver createResolver(TemplateResolverConfig config) {
        boolean patternProvided = config.exists("pattern");
        boolean epochProvided = config.exists("epoch");
        if (patternProvided && epochProvided) {
            throw new IllegalArgumentException("conflicting configuration options are provided: " + config);
        }
        return epochProvided ? TimestampResolver.createEpochResolver(config) : TimestampResolver.createFormatResolver(config);
    }

    private static EventResolver createFormatResolver(TemplateResolverConfig config) {
        FormatResolverContext formatResolverContext = FormatResolverContext.fromConfig(config);
        return new FormatResolver(formatResolverContext);
    }

    private static EventResolver createEpochResolver(TemplateResolverConfig config) {
        String unit = config.getString(new String[]{"epoch", "unit"});
        Boolean rounded = config.getBoolean(new String[]{"epoch", "rounded"});
        if ("nanos".equals(unit) && !Boolean.FALSE.equals(rounded)) {
            return EPOCH_NANOS_RESOLVER;
        }
        if ("millis".equals(unit)) {
            return !Boolean.TRUE.equals(rounded) ? EPOCH_MILLIS_RESOLVER : EPOCH_MILLIS_ROUNDED_RESOLVER;
        }
        if ("millis.nanos".equals(unit) && rounded == null) {
            return EPOCH_MILLIS_NANOS_RESOLVER;
        }
        if ("secs".equals(unit)) {
            return !Boolean.TRUE.equals(rounded) ? EPOCH_SECS_RESOLVER : EPOCH_SECS_ROUNDED_RESOLVER;
        }
        if ("secs.nanos".equals(unit) && rounded == null) {
            return EPOCH_SECS_NANOS_RESOLVER;
        }
        throw new IllegalArgumentException("invalid epoch configuration: " + config);
    }

    private static long epochNanos(Instant instant) {
        return 1000000000L * instant.getEpochSecond() + (long)instant.getNanoOfSecond();
    }

    static String getName() {
        return "timestamp";
    }

    @Override
    public void resolve(LogEvent logEvent, JsonWriter jsonWriter) {
        this.internalResolver.resolve(logEvent, jsonWriter);
    }

    private static abstract class EpochResolver
    implements EventResolver {
        private final EpochResolutionRecord resolutionRecord = new EpochResolutionRecord();

        private EpochResolver() {
        }

        @Override
        public synchronized void resolve(LogEvent logEvent, JsonWriter jsonWriter) {
            Instant logEventInstant = logEvent.getInstant();
            if (logEventInstant.equals(this.resolutionRecord.instant)) {
                jsonWriter.writeRawString(this.resolutionRecord.resolution, 0, this.resolutionRecord.resolutionLength);
            } else {
                this.resolutionRecord.instant = logEventInstant;
                StringBuilder stringBuilder = jsonWriter.getStringBuilder();
                int startIndex = stringBuilder.length();
                this.resolve(logEventInstant, jsonWriter);
                this.resolutionRecord.resolutionLength = stringBuilder.length() - startIndex;
                stringBuilder.getChars(startIndex, stringBuilder.length(), this.resolutionRecord.resolution, 0);
            }
        }

        @Override
        abstract void resolve(Instant var1, JsonWriter var2);
    }

    private static final class EpochResolutionRecord {
        private static final int MAX_LONG_LENGTH = String.valueOf(Long.MAX_VALUE).length();
        private Instant instant;
        private char[] resolution = new char[MAX_LONG_LENGTH + 1 + MAX_LONG_LENGTH];
        private int resolutionLength;

        private EpochResolutionRecord() {
        }
    }

    private static final class FormatResolver
    implements EventResolver {
        private final FormatResolverContext formatResolverContext;

        private FormatResolver(FormatResolverContext formatResolverContext) {
            this.formatResolverContext = formatResolverContext;
        }

        @Override
        public synchronized void resolve(LogEvent logEvent, JsonWriter jsonWriter) {
            long timestampMillis = logEvent.getTimeMillis();
            if (this.formatResolverContext.calendar.getTimeInMillis() != timestampMillis) {
                this.formatResolverContext.formattedTimestampBuilder.setLength(0);
                this.formatResolverContext.calendar.setTimeInMillis(timestampMillis);
                this.formatResolverContext.timestampFormat.format(this.formatResolverContext.calendar, (Appendable)this.formatResolverContext.formattedTimestampBuilder);
                StringBuilder jsonWriterStringBuilder = jsonWriter.getStringBuilder();
                int startIndex = jsonWriterStringBuilder.length();
                jsonWriter.writeString(this.formatResolverContext.formattedTimestampBuilder);
                this.formatResolverContext.formattedTimestampBuilder.setLength(0);
                this.formatResolverContext.formattedTimestampBuilder.append(jsonWriterStringBuilder, startIndex, jsonWriterStringBuilder.length());
            } else {
                jsonWriter.writeRawString(this.formatResolverContext.formattedTimestampBuilder);
            }
        }
    }

    private static final class FormatResolverContext {
        private final FastDateFormat timestampFormat;
        private final Calendar calendar;
        private final StringBuilder formattedTimestampBuilder;

        private FormatResolverContext(TimeZone timeZone, Locale locale, FastDateFormat timestampFormat) {
            this.timestampFormat = timestampFormat;
            this.formattedTimestampBuilder = new StringBuilder();
            this.calendar = Calendar.getInstance(timeZone, locale);
            timestampFormat.format(this.calendar, (Appendable)this.formattedTimestampBuilder);
        }

        private static FormatResolverContext fromConfig(TemplateResolverConfig config) {
            String format = FormatResolverContext.readFormat(config);
            TimeZone timeZone = FormatResolverContext.readTimeZone(config);
            Locale locale = FormatResolverContext.readLocale(config);
            FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)format, (TimeZone)timeZone, (Locale)locale);
            return new FormatResolverContext(timeZone, locale, fastDateFormat);
        }

        private static String readFormat(TemplateResolverConfig config) {
            String format = config.getString(new String[]{"pattern", "format"});
            if (format == null) {
                return JsonTemplateLayoutDefaults.getTimestampFormatPattern();
            }
            try {
                FastDateFormat.getInstance((String)format);
            }
            catch (IllegalArgumentException error) {
                throw new IllegalArgumentException("invalid timestamp format: " + config, error);
            }
            return format;
        }

        private static TimeZone readTimeZone(TemplateResolverConfig config) {
            String timeZoneId = config.getString(new String[]{"pattern", "timeZone"});
            if (timeZoneId == null) {
                return JsonTemplateLayoutDefaults.getTimeZone();
            }
            boolean found = false;
            for (String availableTimeZone : TimeZone.getAvailableIDs()) {
                if (!availableTimeZone.equalsIgnoreCase(timeZoneId)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalArgumentException("invalid timestamp time zone: " + config);
            }
            return TimeZone.getTimeZone(timeZoneId);
        }

        private static Locale readLocale(TemplateResolverConfig config) {
            String locale = config.getString(new String[]{"pattern", "locale"});
            if (locale == null) {
                return JsonTemplateLayoutDefaults.getLocale();
            }
            String[] localeFields = locale.split("_", 3);
            switch (localeFields.length) {
                case 1: {
                    return new Locale(localeFields[0]);
                }
                case 2: {
                    return new Locale(localeFields[0], localeFields[1]);
                }
                case 3: {
                    return new Locale(localeFields[0], localeFields[1], localeFields[2]);
                }
            }
            throw new IllegalArgumentException("invalid timestamp locale: " + config);
        }
    }
}

