/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.ContextDataFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.MutableThreadContextStack;
import org.apache.logging.log4j.spi.ThreadContextStack;
import org.apache.logging.log4j.util.StringMap;

final class LogEventFixture {
    private static final int TIME_OVERLAPPING_CONSECUTIVE_EVENT_COUNT = 10;

    private LogEventFixture() {
    }

    static List<LogEvent> createLiteLogEvents(int logEventCount) {
        ArrayList<LogEvent> logEvents = new ArrayList<LogEvent>(logEventCount);
        long startTimeMillis = System.currentTimeMillis();
        for (int logEventIndex = 0; logEventIndex < logEventCount; ++logEventIndex) {
            String logEventId = String.valueOf(logEventIndex);
            long logEventTimeMillis = LogEventFixture.createLogEventTimeMillis(startTimeMillis, logEventIndex);
            LogEvent logEvent = LogEventFixture.createLiteLogEvent(logEventId, logEventTimeMillis);
            logEvents.add(logEvent);
        }
        return logEvents;
    }

    private static LogEvent createLiteLogEvent(String id, long timeMillis) {
        SimpleMessage message = new SimpleMessage("lite LogEvent message " + id);
        Level level = Level.DEBUG;
        String loggerFqcn = "f.q.c.n" + id;
        String loggerName = "a.B" + id;
        long nanoTime = timeMillis * 2L;
        return Log4jLogEvent.newBuilder().setLoggerName(loggerName).setLoggerFqcn(loggerFqcn).setLevel(level).setMessage((Message)message).setTimeMillis(timeMillis).setNanoTime(nanoTime).build();
    }

    static List<LogEvent> createFullLogEvents(int logEventCount) {
        ArrayList<LogEvent> logEvents = new ArrayList<LogEvent>(logEventCount);
        long startTimeMillis = System.currentTimeMillis();
        for (int logEventIndex = 0; logEventIndex < logEventCount; ++logEventIndex) {
            String logEventId = String.valueOf(logEventIndex);
            long logEventTimeMillis = LogEventFixture.createLogEventTimeMillis(startTimeMillis, logEventIndex);
            LogEvent logEvent = LogEventFixture.createFullLogEvent(logEventId, logEventTimeMillis);
            logEvents.add(logEvent);
        }
        return logEvents;
    }

    private static long createLogEventTimeMillis(long startTimeMillis, int logEventIndex) {
        return startTimeMillis + (long)(logEventIndex / 10);
    }

    private static LogEvent createFullLogEvent(String id, long timeMillis) {
        Exception sourceHelper = new Exception();
        sourceHelper.fillInStackTrace();
        NullPointerException cause = new NullPointerException("testNPEx-" + id);
        sourceHelper.fillInStackTrace();
        StackTraceElement source = sourceHelper.getStackTrace()[0];
        IOException ioException = new IOException("testIOEx-" + id, cause);
        ioException.addSuppressed(new IndexOutOfBoundsException("I am suppressed exception 1" + id));
        ioException.addSuppressed(new IndexOutOfBoundsException("I am suppressed exception 2" + id));
        SimpleMessage message = new SimpleMessage("full LogEvent message " + id);
        StringMap contextData = LogEventFixture.createContextData(id);
        ThreadContextStack contextStack = LogEventFixture.createContextStack(id);
        int threadId = id.hashCode();
        String threadName = "MyThreadName" + id;
        int threadPriority = threadId % 10;
        Level level = Level.DEBUG;
        String loggerFqcn = "f.q.c.n" + id;
        String loggerName = "a.B" + id;
        long nanoTime = timeMillis * 2L;
        return Log4jLogEvent.newBuilder().setLoggerName(loggerName).setLoggerFqcn(loggerFqcn).setLevel(level).setMessage((Message)message).setThrown((Throwable)ioException).setContextData(contextData).setContextStack((ThreadContext.ContextStack)contextStack).setThreadId((long)threadId).setThreadName(threadName).setThreadPriority(threadPriority).setSource(source).setTimeMillis(timeMillis).setNanoTime(nanoTime).build();
    }

    private static StringMap createContextData(String id) {
        StringMap contextData = ContextDataFactory.createContextData();
        contextData.putValue("MDC.String." + id, (Object)"String");
        contextData.putValue("MDC.BigDecimal." + id, (Object)BigDecimal.valueOf(Math.PI));
        contextData.putValue("MDC.Integer." + id, (Object)10);
        contextData.putValue("MDC.Long." + id, (Object)Long.MAX_VALUE);
        return contextData;
    }

    private static ThreadContextStack createContextStack(String id) {
        MutableThreadContextStack contextStack = new MutableThreadContextStack();
        contextStack.clear();
        contextStack.push("stack_msg1" + id);
        contextStack.add((Object)("stack_msg2" + id));
        return contextStack;
    }
}

