/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.kit.env.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.kit.env.internal.PropertyMapping;
import org.apache.logging.log4j.kit.json.JsonReader;
import org.apache.logging.log4j.util.LoaderUtil;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class DefaultPropertyMappingParser {
    public static PropertyMapping parse(URL url) throws IllegalArgumentException, IOException {
        try (InputStream stream = url.openStream();){
            Object json = JsonReader.read(new String(stream.readAllBytes(), StandardCharsets.UTF_8));
            HashMap<String, List<String>> mapping = new HashMap<String, List<String>>();
            if (json instanceof Map) {
                DefaultPropertyMappingParser.visitMap(null, (Map)json, mapping);
                PropertyMapping propertyMapping = new PropertyMapping(mapping.entrySet().stream());
                return propertyMapping;
            }
            throw new IllegalArgumentException("Property mapping file needs to contain a JSON object.");
        }
    }

    public static PropertyMapping parse(String resource) throws IllegalArgumentException, IOException {
        ClassLoader loader = LoaderUtil.getClassLoader();
        return Collections.list(loader.getResources(resource)).stream().map(url -> {
            try {
                return DefaultPropertyMappingParser.parse(url);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to load legacy property mappings from URL '" + String.valueOf(url) + "'.", e);
            }
        }).reduce(PropertyMapping::merge).orElse(PropertyMapping.EMPTY);
    }

    private static void visitMap(@Nullable String prefix, Map<String, ?> node, Map<String, List<String>> mapping) {
        node.forEach((k, value) -> {
            String key;
            String string = key = prefix != null ? prefix + "." + k : k;
            if (value instanceof Map) {
                DefaultPropertyMappingParser.visitMap(key, (Map)value, mapping);
            }
            if (value instanceof List) {
                DefaultPropertyMappingParser.visitArray(key, (List)value, mapping);
            }
        });
    }

    private static void visitArray(String key, List<?> source, Map<String, List<String>> mapping) {
        source.forEach(value -> {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException(String.format("Expecting `%s` to contain only strings.", source));
            }
        });
        mapping.merge(key, source, (c1, c2) -> {
            ArrayList result = new ArrayList(c1.size() + c2.size());
            result.addAll(c1);
            result.addAll(c2);
            return result;
        });
    }
}

