/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.kit.recycler;

import org.apache.logging.log4j.kit.env.Log4jProperty;
import org.apache.logging.log4j.status.StatusLogger;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@Log4jProperty(name="recycler")
public record RecyclerProperties(@Nullable String factory, @Nullable Integer capacity) {
    private static final int DEFAULT_CAPACITY = Math.max(2 * Runtime.getRuntime().availableProcessors() + 1, 8);

    public RecyclerProperties(@Nullable String factory, @Nullable Integer capacity) {
        capacity = RecyclerProperties.validateCapacity(capacity);
    }

    private static Integer validateCapacity(@Nullable Integer capacity) {
        if (capacity != null) {
            if (capacity >= 1) {
                return capacity;
            }
            StatusLogger.getLogger().warn("Invalid recycler capacity {}, using default capacity {}.", (Object)capacity, (Object)DEFAULT_CAPACITY);
        }
        return DEFAULT_CAPACITY;
    }
}

