/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.spi.AbstractLoggerWrapper;

public final class EventLogger {
    public static final Marker EVENT_MARKER = MarkerManager.getMarker("EVENT");
    private static final String FQCN = EventLogger.class.getName();
    private static AbstractLoggerWrapper logger;

    private EventLogger() {
    }

    public static void logEvent(StructuredDataMessage msg) {
        logger.log(EVENT_MARKER, FQCN, Level.OFF, msg, null);
    }

    public static void logEvent(StructuredDataMessage msg, Level level) {
        logger.log(EVENT_MARKER, FQCN, level, msg, null);
    }

    static {
        Logger l = LogManager.getLogger("EventLogger");
        if (!(l instanceof AbstractLogger)) {
            throw new LoggingException("Logger returned must be based on AbstractLogger");
        }
        logger = new AbstractLoggerWrapper((AbstractLogger)l, "EventLogger", null);
    }
}

