/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spi;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ObjectMessage;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.message.SimpleMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLogger
implements Logger {
    public static final Marker FLOW_MARKER = MarkerManager.getMarker("FLOW");
    public static final Marker ENTRY_MARKER = MarkerManager.getMarker("ENTRY", FLOW_MARKER);
    public static final Marker EXIT_MARKER = MarkerManager.getMarker("EXIT", FLOW_MARKER);
    public static final Marker EXCEPTION_MARKER = MarkerManager.getMarker("EXCEPTION");
    public static final Marker THROWING_MARKER = MarkerManager.getMarker("THROWING", EXCEPTION_MARKER);
    public static final Marker CATCHING_MARKER = MarkerManager.getMarker("CATCHING", EXCEPTION_MARKER);
    private static final String FQCN = AbstractLogger.class.getName();

    @Override
    public void entry() {
        if (this.isEnabled(Level.TRACE, ENTRY_MARKER, (Object)null, null)) {
            this.log(ENTRY_MARKER, FQCN, Level.TRACE, new SimpleMessage(" entry"), null);
        }
    }

    @Override
    public void entry(Object ... params) {
        if (this.isEnabled(Level.TRACE, ENTRY_MARKER, (Object)null, null)) {
            this.log(ENTRY_MARKER, FQCN, Level.TRACE, this.entryMsg(params.length, params), null);
        }
    }

    @Override
    public void exit() {
        if (this.isEnabled(Level.TRACE, EXIT_MARKER, (Object)null, null)) {
            this.log(EXIT_MARKER, FQCN, Level.TRACE, this.exitMsg(null), null);
        }
    }

    @Override
    public <R> R exit(R result) {
        if (this.isEnabled(Level.TRACE, EXIT_MARKER, (Object)null, null)) {
            this.log(EXIT_MARKER, FQCN, Level.TRACE, this.exitMsg(result), null);
        }
        return result;
    }

    @Override
    public <T extends Throwable> T throwing(T t) {
        if (this.isEnabled(Level.ERROR, THROWING_MARKER, (Object)null, null)) {
            this.log(THROWING_MARKER, FQCN, Level.ERROR, new SimpleMessage("throwing"), t);
        }
        return t;
    }

    @Override
    public <T extends Throwable> T throwing(Level level, T t) {
        if (this.isEnabled(level, THROWING_MARKER, (Object)null, null)) {
            this.log(THROWING_MARKER, FQCN, level, new SimpleMessage("throwing"), t);
        }
        return t;
    }

    @Override
    public void catching(Throwable t) {
        if (this.isEnabled(Level.DEBUG, THROWING_MARKER, (Object)null, null)) {
            this.log(THROWING_MARKER, FQCN, Level.DEBUG, new SimpleMessage("catching"), t);
        }
    }

    @Override
    public void catching(Level level, Throwable t) {
        if (this.isEnabled(level, THROWING_MARKER, (Object)null, null)) {
            this.log(THROWING_MARKER, FQCN, level, new SimpleMessage("catching"), t);
        }
    }

    @Override
    public void trace(String message) {
        if (this.isEnabled(Level.TRACE, null, message)) {
            this.log(null, FQCN, Level.TRACE, new SimpleMessage(message), null);
        }
    }

    @Override
    public void trace(Marker marker, String message) {
        if (this.isEnabled(Level.TRACE, marker, message)) {
            this.log(marker, FQCN, Level.TRACE, new SimpleMessage(message), null);
        }
    }

    @Override
    public void trace(String message, Throwable t) {
        if (this.isEnabled(Level.TRACE, (Marker)null, message, t)) {
            this.log(null, FQCN, Level.TRACE, new SimpleMessage(message), t);
        }
    }

    @Override
    public void trace(Marker marker, String message, Throwable t) {
        if (this.isEnabled(Level.TRACE, marker, message, t)) {
            this.log(marker, FQCN, Level.TRACE, new SimpleMessage(message), t);
        }
    }

    @Override
    public void trace(Object message) {
        if (this.isEnabled(Level.TRACE, null, message, null)) {
            this.log(null, FQCN, Level.TRACE, new ObjectMessage(message), null);
        }
    }

    @Override
    public void trace(Marker marker, Object message) {
        if (this.isEnabled(Level.TRACE, marker, message, null)) {
            this.log(marker, FQCN, Level.TRACE, new ObjectMessage(message), null);
        }
    }

    @Override
    public void trace(Object message, Throwable t) {
        if (this.isEnabled(Level.TRACE, null, message, t)) {
            this.log(null, FQCN, Level.TRACE, new ObjectMessage(message), t);
        }
    }

    @Override
    public void trace(Marker marker, Object message, Throwable t) {
        if (this.isEnabled(Level.TRACE, marker, message, t)) {
            this.log(marker, FQCN, Level.TRACE, new ObjectMessage(message), t);
        }
    }

    @Override
    public void trace(String message, Object ... params) {
        if (this.isEnabled(Level.TRACE, null, message, params)) {
            ParameterizedMessage msg = new ParameterizedMessage(message, params);
            this.log(null, FQCN, Level.TRACE, msg, msg.getThrowable());
        }
    }

    @Override
    public void trace(Marker marker, String message, Object ... params) {
        if (this.isEnabled(Level.TRACE, marker, message, params)) {
            ParameterizedMessage msg = new ParameterizedMessage(message, params);
            this.log(marker, FQCN, Level.TRACE, msg, msg.getThrowable());
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isEnabled(Level.TRACE, null, (Object)null, null);
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return this.isEnabled(Level.TRACE, marker, (Object)null, null);
    }

    @Override
    public void trace(Message msg) {
        if (this.isEnabled(Level.TRACE, null, msg, null)) {
            this.log(null, FQCN, Level.TRACE, msg, null);
        }
    }

    @Override
    public void trace(Message msg, Throwable t) {
        if (this.isEnabled(Level.TRACE, null, msg, t)) {
            this.log(null, FQCN, Level.TRACE, msg, t);
        }
    }

    @Override
    public void trace(Marker marker, Message msg) {
        if (this.isEnabled(Level.TRACE, marker, msg, null)) {
            this.log(marker, FQCN, Level.TRACE, msg, null);
        }
    }

    @Override
    public void trace(Marker marker, Message msg, Throwable t) {
        if (this.isEnabled(Level.TRACE, marker, msg, t)) {
            this.log(marker, FQCN, Level.TRACE, msg, t);
        }
    }

    @Override
    public void debug(String message) {
        if (this.isEnabled(Level.DEBUG, null, message)) {
            this.log(null, FQCN, Level.DEBUG, new SimpleMessage(message), null);
        }
    }

    @Override
    public void debug(Marker marker, String message) {
        if (this.isEnabled(Level.DEBUG, marker, message)) {
            this.log(marker, FQCN, Level.DEBUG, new SimpleMessage(message), null);
        }
    }

    @Override
    public void debug(String message, Throwable t) {
        if (this.isEnabled(Level.DEBUG, (Marker)null, message, t)) {
            this.log(null, FQCN, Level.DEBUG, new SimpleMessage(message), t);
        }
    }

    @Override
    public void debug(Marker marker, String message, Throwable t) {
        if (this.isEnabled(Level.DEBUG, marker, message, t)) {
            this.log(marker, FQCN, Level.DEBUG, new SimpleMessage(message), t);
        }
    }

    @Override
    public void debug(Object message) {
        if (this.isEnabled(Level.DEBUG, null, message, null)) {
            this.log(null, FQCN, Level.DEBUG, new ObjectMessage(message), null);
        }
    }

    @Override
    public void debug(Marker marker, Object message) {
        if (this.isEnabled(Level.DEBUG, marker, message, null)) {
            this.log(marker, FQCN, Level.DEBUG, new ObjectMessage(message), null);
        }
    }

    @Override
    public void debug(Object message, Throwable t) {
        if (this.isEnabled(Level.DEBUG, null, message, t)) {
            this.log(null, FQCN, Level.DEBUG, new ObjectMessage(message), t);
        }
    }

    @Override
    public void debug(Marker marker, Object message, Throwable t) {
        if (this.isEnabled(Level.DEBUG, marker, message, t)) {
            this.log(marker, FQCN, Level.DEBUG, new ObjectMessage(message), t);
        }
    }

    @Override
    public void debug(String message, Object ... params) {
        if (this.isEnabled(Level.DEBUG, null, message, params)) {
            ParameterizedMessage msg = new ParameterizedMessage(message, params);
            this.log(null, FQCN, Level.DEBUG, msg, msg.getThrowable());
        }
    }

    @Override
    public void debug(Marker marker, String message, Object ... params) {
        if (this.isEnabled(Level.DEBUG, marker, message, params)) {
            ParameterizedMessage msg = new ParameterizedMessage(message, params);
            this.log(marker, FQCN, Level.DEBUG, msg, msg.getThrowable());
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isEnabled(Level.DEBUG, null, null);
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return this.isEnabled(Level.DEBUG, marker, (Object)null, null);
    }

    @Override
    public void debug(Message msg) {
        if (this.isEnabled(Level.TRACE, null, msg, null)) {
            this.log(null, FQCN, Level.TRACE, msg, null);
        }
    }

    @Override
    public void debug(Message msg, Throwable t) {
        if (this.isEnabled(Level.TRACE, null, msg, t)) {
            this.log(null, FQCN, Level.TRACE, msg, t);
        }
    }

    @Override
    public void debug(Marker marker, Message msg) {
        if (this.isEnabled(Level.DEBUG, marker, msg, null)) {
            this.log(marker, FQCN, Level.DEBUG, msg, null);
        }
    }

    @Override
    public void debug(Marker marker, Message msg, Throwable t) {
        if (this.isEnabled(Level.DEBUG, marker, msg, t)) {
            this.log(marker, FQCN, Level.DEBUG, msg, t);
        }
    }

    @Override
    public void info(String message) {
        if (this.isEnabled(Level.INFO, null, message)) {
            this.log(null, FQCN, Level.INFO, new SimpleMessage(message), null);
        }
    }

    @Override
    public void info(Marker marker, String message) {
        if (this.isEnabled(Level.INFO, marker, message)) {
            this.log(marker, FQCN, Level.INFO, new SimpleMessage(message), null);
        }
    }

    @Override
    public void info(String message, Throwable t) {
        if (this.isEnabled(Level.INFO, (Marker)null, message, t)) {
            this.log(null, FQCN, Level.INFO, new SimpleMessage(message), t);
        }
    }

    @Override
    public void info(Marker marker, String message, Throwable t) {
        if (this.isEnabled(Level.INFO, marker, message, t)) {
            this.log(marker, FQCN, Level.INFO, new SimpleMessage(message), t);
        }
    }

    @Override
    public void info(Object message) {
        if (this.isEnabled(Level.INFO, null, message, null)) {
            this.log(null, FQCN, Level.INFO, new ObjectMessage(message), null);
        }
    }

    @Override
    public void info(Marker marker, Object message) {
        if (this.isEnabled(Level.INFO, marker, message, null)) {
            this.log(marker, FQCN, Level.INFO, new ObjectMessage(message), null);
        }
    }

    @Override
    public void info(Object message, Throwable t) {
        if (this.isEnabled(Level.INFO, null, message, t)) {
            this.log(null, FQCN, Level.INFO, new ObjectMessage(message), t);
        }
    }

    @Override
    public void info(Marker marker, Object message, Throwable t) {
        if (this.isEnabled(Level.INFO, marker, message, t)) {
            this.log(marker, FQCN, Level.INFO, new ObjectMessage(message), t);
        }
    }

    @Override
    public void info(String message, Object ... params) {
        if (this.isEnabled(Level.INFO, null, message, params)) {
            ParameterizedMessage msg = new ParameterizedMessage(message, params);
            this.log(null, FQCN, Level.INFO, msg, msg.getThrowable());
        }
    }

    @Override
    public void info(Marker marker, String message, Object ... params) {
        if (this.isEnabled(Level.INFO, marker, message, params)) {
            ParameterizedMessage msg = new ParameterizedMessage(message, params);
            this.log(marker, FQCN, Level.INFO, msg, msg.getThrowable());
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isEnabled(Level.INFO, null, (Object)null, null);
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return this.isEnabled(Level.INFO, marker, (Object)null, null);
    }

    @Override
    public void info(Message msg) {
        if (this.isEnabled(Level.INFO, null, msg, null)) {
            this.log(null, FQCN, Level.INFO, msg, null);
        }
    }

    @Override
    public void info(Message msg, Throwable t) {
        if (this.isEnabled(Level.INFO, null, msg, t)) {
            this.log(null, FQCN, Level.INFO, msg, t);
        }
    }

    @Override
    public void info(Marker marker, Message msg) {
        if (this.isEnabled(Level.INFO, null, msg, null)) {
            this.log(marker, FQCN, Level.INFO, msg, null);
        }
    }

    @Override
    public void info(Marker marker, Message msg, Throwable t) {
        if (this.isEnabled(Level.INFO, marker, msg, t)) {
            this.log(marker, FQCN, Level.INFO, msg, t);
        }
    }

    @Override
    public void warn(String message) {
        if (this.isEnabled(Level.WARN, null, message)) {
            this.log(null, FQCN, Level.WARN, new SimpleMessage(message), null);
        }
    }

    @Override
    public void warn(Marker marker, String message) {
        if (this.isEnabled(Level.WARN, marker, message)) {
            this.log(marker, FQCN, Level.WARN, new SimpleMessage(message), null);
        }
    }

    @Override
    public void warn(String message, Throwable t) {
        if (this.isEnabled(Level.WARN, (Marker)null, message, t)) {
            this.log(null, FQCN, Level.DEBUG, new SimpleMessage(message), t);
        }
    }

    @Override
    public void warn(Marker marker, String message, Throwable t) {
        if (this.isEnabled(Level.WARN, marker, message, t)) {
            this.log(marker, FQCN, Level.DEBUG, new SimpleMessage(message), t);
        }
    }

    @Override
    public void warn(Marker marker, Object message) {
        if (this.isEnabled(Level.WARN, marker, message, null)) {
            this.log(marker, FQCN, Level.WARN, new ObjectMessage(message), null);
        }
    }

    @Override
    public void warn(Object message) {
        if (this.isEnabled(Level.WARN, null, message, null)) {
            this.log(null, FQCN, Level.WARN, new ObjectMessage(message), null);
        }
    }

    @Override
    public void warn(Object message, Throwable t) {
        if (this.isEnabled(Level.WARN, null, message, t)) {
            this.log(null, FQCN, Level.DEBUG, new ObjectMessage(message), t);
        }
    }

    @Override
    public void warn(Marker marker, Object message, Throwable t) {
        if (this.isEnabled(Level.WARN, marker, message, t)) {
            this.log(marker, FQCN, Level.DEBUG, new ObjectMessage(message), t);
        }
    }

    @Override
    public void warn(String message, Object ... params) {
        if (this.isEnabled(Level.WARN, null, message, params)) {
            ParameterizedMessage msg = new ParameterizedMessage(message, params);
            this.log(null, FQCN, Level.WARN, msg, msg.getThrowable());
        }
    }

    @Override
    public void warn(Marker marker, String message, Object ... params) {
        if (this.isEnabled(Level.WARN, marker, message, params)) {
            ParameterizedMessage msg = new ParameterizedMessage(message, params);
            this.log(marker, FQCN, Level.WARN, msg, msg.getThrowable());
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isEnabled(Level.WARN, null, (Object)null, null);
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return this.isEnabled(Level.WARN, marker, (Object)null, null);
    }

    @Override
    public void warn(Message msg) {
        if (this.isEnabled(Level.WARN, null, msg, null)) {
            this.log(null, FQCN, Level.WARN, msg, null);
        }
    }

    @Override
    public void warn(Message msg, Throwable t) {
        if (this.isEnabled(Level.WARN, null, msg, t)) {
            this.log(null, FQCN, Level.WARN, msg, t);
        }
    }

    @Override
    public void warn(Marker marker, Message msg) {
        if (this.isEnabled(Level.WARN, null, msg, null)) {
            this.log(marker, FQCN, Level.WARN, msg, null);
        }
    }

    @Override
    public void warn(Marker marker, Message msg, Throwable t) {
        if (this.isEnabled(Level.WARN, marker, msg, t)) {
            this.log(marker, FQCN, Level.WARN, msg, t);
        }
    }

    @Override
    public void error(String message) {
        if (this.isEnabled(Level.ERROR, null, message)) {
            this.log(null, FQCN, Level.ERROR, new SimpleMessage(message), null);
        }
    }

    @Override
    public void error(Marker marker, String message) {
        if (this.isEnabled(Level.ERROR, marker, message)) {
            this.log(marker, FQCN, Level.ERROR, new SimpleMessage(message), null);
        }
    }

    @Override
    public void error(String message, Throwable t) {
        if (this.isEnabled(Level.ERROR, (Marker)null, message, t)) {
            this.log(null, FQCN, Level.ERROR, new SimpleMessage(message), t);
        }
    }

    @Override
    public void error(Marker marker, String message, Throwable t) {
        if (this.isEnabled(Level.ERROR, marker, message, t)) {
            this.log(marker, FQCN, Level.ERROR, new SimpleMessage(message), t);
        }
    }

    @Override
    public void error(Object message) {
        if (this.isEnabled(Level.ERROR, null, message, null)) {
            this.log(null, FQCN, Level.ERROR, new ObjectMessage(message), null);
        }
    }

    @Override
    public void error(Marker marker, Object message) {
        if (this.isEnabled(Level.ERROR, marker, message, null)) {
            this.log(marker, FQCN, Level.ERROR, new ObjectMessage(message), null);
        }
    }

    @Override
    public void error(Object message, Throwable t) {
        if (this.isEnabled(Level.ERROR, null, message, t)) {
            this.log(null, FQCN, Level.ERROR, new ObjectMessage(message), t);
        }
    }

    @Override
    public void error(Marker marker, Object message, Throwable t) {
        if (this.isEnabled(Level.ERROR, marker, message, t)) {
            this.log(marker, FQCN, Level.ERROR, new ObjectMessage(message), t);
        }
    }

    @Override
    public void error(String message, Object ... params) {
        if (this.isEnabled(Level.ERROR, null, message, params)) {
            ParameterizedMessage msg = new ParameterizedMessage(message, params);
            this.log(null, FQCN, Level.ERROR, msg, msg.getThrowable());
        }
    }

    @Override
    public void error(Marker marker, String message, Object ... params) {
        if (this.isEnabled(Level.ERROR, marker, message, params)) {
            ParameterizedMessage msg = new ParameterizedMessage(message, params);
            this.log(marker, FQCN, Level.ERROR, msg, msg.getThrowable());
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isEnabled(Level.ERROR, null, (Object)null, null);
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return this.isEnabled(Level.ERROR, marker, (Object)null, null);
    }

    @Override
    public void error(Message msg) {
        if (this.isEnabled(Level.ERROR, null, msg, null)) {
            this.log(null, FQCN, Level.ERROR, msg, null);
        }
    }

    @Override
    public void error(Message msg, Throwable t) {
        if (this.isEnabled(Level.ERROR, null, msg, t)) {
            this.log(null, FQCN, Level.ERROR, msg, t);
        }
    }

    @Override
    public void error(Marker marker, Message msg) {
        if (this.isEnabled(Level.ERROR, null, msg, null)) {
            this.log(null, FQCN, Level.ERROR, msg, null);
        }
    }

    @Override
    public void error(Marker marker, Message msg, Throwable t) {
        if (this.isEnabled(Level.ERROR, marker, msg, t)) {
            this.log(marker, FQCN, Level.ERROR, msg, t);
        }
    }

    @Override
    public void fatal(String message) {
        if (this.isEnabled(Level.FATAL, null, message)) {
            this.log(null, FQCN, Level.FATAL, new SimpleMessage(message), null);
        }
    }

    @Override
    public void fatal(Marker marker, String message) {
        if (this.isEnabled(Level.FATAL, marker, message)) {
            this.log(marker, FQCN, Level.FATAL, new SimpleMessage(message), null);
        }
    }

    @Override
    public void fatal(String message, Throwable t) {
        if (this.isEnabled(Level.FATAL, (Marker)null, message, t)) {
            this.log(null, FQCN, Level.FATAL, new SimpleMessage(message), t);
        }
    }

    @Override
    public void fatal(Marker marker, String message, Throwable t) {
        if (this.isEnabled(Level.FATAL, marker, message, t)) {
            this.log(marker, FQCN, Level.FATAL, new SimpleMessage(message), t);
        }
    }

    @Override
    public void fatal(Object message) {
        if (this.isEnabled(Level.FATAL, null, message, null)) {
            this.log(null, FQCN, Level.FATAL, new ObjectMessage(message), null);
        }
    }

    @Override
    public void fatal(Marker marker, Object message) {
        if (this.isEnabled(Level.FATAL, marker, message, null)) {
            this.log(marker, FQCN, Level.FATAL, new ObjectMessage(message), null);
        }
    }

    @Override
    public void fatal(Object message, Throwable t) {
        if (this.isEnabled(Level.FATAL, null, message, t)) {
            this.log(null, FQCN, Level.FATAL, new ObjectMessage(message), t);
        }
    }

    @Override
    public void fatal(Marker marker, Object message, Throwable t) {
        if (this.isEnabled(Level.FATAL, marker, message, t)) {
            this.log(marker, FQCN, Level.FATAL, new ObjectMessage(message), t);
        }
    }

    @Override
    public void fatal(String message, Object ... params) {
        if (this.isEnabled(Level.FATAL, null, message, params)) {
            ParameterizedMessage msg = new ParameterizedMessage(message, params);
            this.log(null, FQCN, Level.FATAL, msg, msg.getThrowable());
        }
    }

    @Override
    public void fatal(Marker marker, String message, Object ... params) {
        if (this.isEnabled(Level.FATAL, marker, message, params)) {
            ParameterizedMessage msg = new ParameterizedMessage(message, params);
            this.log(marker, FQCN, Level.FATAL, msg, msg.getThrowable());
        }
    }

    @Override
    public boolean isFatalEnabled() {
        return this.isEnabled(Level.ERROR, null, (Object)null, null);
    }

    @Override
    public boolean isFatalEnabled(Marker marker) {
        return this.isEnabled(Level.FATAL, marker, (Object)null, null);
    }

    @Override
    public void fatal(Message msg) {
        if (this.isEnabled(Level.FATAL, null, msg, null)) {
            this.log(null, FQCN, Level.FATAL, msg, null);
        }
    }

    @Override
    public void fatal(Message msg, Throwable t) {
        if (this.isEnabled(Level.FATAL, null, msg, t)) {
            this.log(null, FQCN, Level.FATAL, msg, t);
        }
    }

    @Override
    public void fatal(Marker marker, Message msg) {
        if (this.isEnabled(Level.FATAL, null, msg, null)) {
            this.log(null, FQCN, Level.FATAL, msg, null);
        }
    }

    @Override
    public void fatal(Marker marker, Message msg, Throwable t) {
        if (this.isEnabled(Level.FATAL, marker, msg, t)) {
            this.log(marker, FQCN, Level.FATAL, msg, t);
        }
    }

    protected abstract void log(Marker var1, String var2, Level var3, Message var4, Throwable var5);

    protected abstract boolean isEnabled(Level var1, Marker var2, String var3);

    protected abstract boolean isEnabled(Level var1, Marker var2, String var3, Throwable var4);

    protected abstract boolean isEnabled(Level var1, Marker var2, String var3, Object var4);

    protected abstract boolean isEnabled(Level var1, Marker var2, String var3, Object var4, Object var5);

    protected abstract boolean isEnabled(Level var1, Marker var2, String var3, Object var4, Object var5, Object var6);

    protected abstract boolean isEnabled(Level var1, Marker var2, String var3, Object var4, Object var5, Object var6, Object ... var7);

    protected abstract boolean isEnabled(Level var1, Marker var2, Object var3, Throwable var4);

    protected abstract boolean isEnabled(Level var1, Marker var2, Message var3, Throwable var4);

    private Message entryMsg(int count, Object ... params) {
        if (count == 0) {
            return new SimpleMessage(" entry");
        }
        StringBuilder sb = new StringBuilder(" entry parms(");
        int i = 0;
        for (Object parm : params) {
            if (parm != null) {
                sb.append(parm.toString());
            } else {
                sb.append("null");
            }
            if (++i >= params.length) continue;
            sb.append(", ");
        }
        sb.append(")");
        return new SimpleMessage(sb.toString());
    }

    private Message exitMsg(Object result) {
        if (result == null) {
            return new SimpleMessage(" exit");
        }
        return new SimpleMessage(" exit with (" + result + ")");
    }
}

