/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.gateway.springcloud.websocket;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.conf.CommonVars$;
import org.apache.linkis.common.conf.Configuration$;
import org.apache.linkis.common.conf.TimeType;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.gateway.http.BaseGatewayContext;
import org.apache.linkis.gateway.http.GatewayHttpRequest;
import org.apache.linkis.gateway.http.GatewayHttpResponse;
import org.apache.linkis.gateway.springcloud.http.SpringCloudGatewayHttpRequest;
import org.apache.linkis.gateway.springcloud.websocket.GatewayWebSocketSessionConnection;
import org.apache.linkis.gateway.springcloud.websocket.SpringCloudGatewayWebsocketUtils$;
import org.apache.linkis.gateway.springcloud.websocket.WebsocketGatewayHttpResponse;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.springframework.cloud.gateway.filter.WebsocketRoutingFilter;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.server.reactive.AbstractServerHttpRequest;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.WebSocketSession;
import org.springframework.web.reactive.socket.adapter.AbstractWebSocketSession;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.TraversableLike;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

public final class SpringCloudGatewayWebsocketUtils$
implements Logging {
    public static SpringCloudGatewayWebsocketUtils$ MODULE$;
    private final long SPRING_CLOUD_GATEWAY_WEBSOCKET_HEARTBEAT;
    private final Method changeSchemeMethod;
    private final Method getDelegateMethod;
    private final Method getHeadersFiltersMethod;
    private final ConcurrentHashMap<String, GatewayWebSocketSessionConnection> org$apache$linkis$gateway$springcloud$websocket$SpringCloudGatewayWebsocketUtils$$cachedWebSocketSessions;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new SpringCloudGatewayWebsocketUtils$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        SpringCloudGatewayWebsocketUtils$ springCloudGatewayWebsocketUtils$ = this;
        synchronized (springCloudGatewayWebsocketUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public long SPRING_CLOUD_GATEWAY_WEBSOCKET_HEARTBEAT() {
        return this.SPRING_CLOUD_GATEWAY_WEBSOCKET_HEARTBEAT;
    }

    private Method changeSchemeMethod() {
        return this.changeSchemeMethod;
    }

    public Method getDelegateMethod() {
        return this.getDelegateMethod;
    }

    private Method getHeadersFiltersMethod() {
        return this.getHeadersFiltersMethod;
    }

    public ConcurrentHashMap<String, GatewayWebSocketSessionConnection> org$apache$linkis$gateway$springcloud$websocket$SpringCloudGatewayWebsocketUtils$$cachedWebSocketSessions() {
        return this.org$apache$linkis$gateway$springcloud$websocket$SpringCloudGatewayWebsocketUtils$$cachedWebSocketSessions;
    }

    public void removeAllGatewayWebSocketSessionConnection(String user) {
        ((MapLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.org$apache$linkis$gateway$springcloud$websocket$SpringCloudGatewayWebsocketUtils$$cachedWebSocketSessions()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SpringCloudGatewayWebsocketUtils$.$anonfun$removeAllGatewayWebSocketSessionConnection$1(user, x$2)))).values().foreach((Function1 & Serializable & scala.Serializable)session -> {
            session.release();
            return BoxedUnit.UNIT;
        });
    }

    public void removeGatewayWebSocketSessionConnection(InetSocketAddress inetSocketAddress) {
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.org$apache$linkis$gateway$springcloud$websocket$SpringCloudGatewayWebsocketUtils$$cachedWebSocketSessions()).asScala()).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SpringCloudGatewayWebsocketUtils$.$anonfun$removeGatewayWebSocketSessionConnection$1(inetSocketAddress, x$3))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SpringCloudGatewayWebsocketUtils$.$anonfun$removeGatewayWebSocketSessionConnection$2(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private String getWebSocketSessionKey(WebSocketSession webSocketSession) {
        WebSocketSession webSocketSession2;
        while ((webSocketSession2 = webSocketSession) instanceof GatewayWebSocketSessionConnection) {
            GatewayWebSocketSessionConnection gatewayWebSocketSessionConnection = (GatewayWebSocketSessionConnection)webSocketSession2;
            webSocketSession = gatewayWebSocketSessionConnection.webSocketSession();
        }
        return webSocketSession.getId();
    }

    public WebSocketSession getProxyWebSocketSession(WebSocketSession webSocketSession, ServiceInstance serviceInstance) {
        String key = this.getWebSocketSessionKey(webSocketSession);
        if (this.org$apache$linkis$gateway$springcloud$websocket$SpringCloudGatewayWebsocketUtils$$cachedWebSocketSessions().containsKey(key)) {
            WebSocketSession webSocketSession2;
            ConcurrentHashMap<String, GatewayWebSocketSessionConnection> concurrentHashMap = this.org$apache$linkis$gateway$springcloud$websocket$SpringCloudGatewayWebsocketUtils$$cachedWebSocketSessions();
            synchronized (concurrentHashMap) {
                GatewayWebSocketSessionConnection webSocketSession3 = this.org$apache$linkis$gateway$springcloud$websocket$SpringCloudGatewayWebsocketUtils$$cachedWebSocketSessions().get(key);
                webSocketSession2 = webSocketSession3 != null ? (WebSocketSession)webSocketSession3.getProxyWebSocketSession(serviceInstance).orNull(Predef$.MODULE$.$conforms()) : null;
            }
            return webSocketSession2;
        }
        return null;
    }

    public GatewayWebSocketSessionConnection getGatewayWebSocketSessionConnection(String user, WebSocketSession webSocketSession) {
        BoxedUnit boxedUnit;
        String key = this.getWebSocketSessionKey(webSocketSession);
        if (!this.org$apache$linkis$gateway$springcloud$websocket$SpringCloudGatewayWebsocketUtils$$cachedWebSocketSessions().containsKey(key)) {
            ConcurrentHashMap<String, GatewayWebSocketSessionConnection> concurrentHashMap = this.org$apache$linkis$gateway$springcloud$websocket$SpringCloudGatewayWebsocketUtils$$cachedWebSocketSessions();
            synchronized (concurrentHashMap) {
                Object object;
                if (!this.org$apache$linkis$gateway$springcloud$websocket$SpringCloudGatewayWebsocketUtils$$cachedWebSocketSessions().containsKey(key)) {
                    this.logger().info(new StringBuilder(58).append("receive a new webSocket connection ").append(key).append(" from DWC-UI for user ").append(user).append(".").toString());
                    object = this.org$apache$linkis$gateway$springcloud$websocket$SpringCloudGatewayWebsocketUtils$$cachedWebSocketSessions().put(key, new GatewayWebSocketSessionConnection(webSocketSession, user));
                } else {
                    object = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = object;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl12 : MonitorExitStatement: MONITOREXIT : var4_4
                boxedUnit = boxedUnit2;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.org$apache$linkis$gateway$springcloud$websocket$SpringCloudGatewayWebsocketUtils$$cachedWebSocketSessions().get(key);
    }

    public void setProxyWebSocketSession(String user, ServiceInstance serviceInstance, WebSocketSession webSocketSession, WebSocketSession proxySession) {
        this.getGatewayWebSocketSessionConnection(user, webSocketSession).add(serviceInstance, proxySession);
    }

    public List<HttpHeadersFilter> getHeadersFilters(WebsocketRoutingFilter websocketRoutingFilter) {
        return (List)this.getHeadersFiltersMethod().invoke((Object)websocketRoutingFilter, new Object[0]);
    }

    public void changeSchemeIfIsWebSocketUpgrade(WebsocketRoutingFilter websocketRoutingFilter, ServerWebExchange exchange) {
        this.changeSchemeMethod().invoke((Object)websocketRoutingFilter, exchange);
    }

    public BaseGatewayContext getGatewayContext(ServerWebExchange exchange) {
        BaseGatewayContext gatewayContext = new BaseGatewayContext();
        gatewayContext.setWebSocketRequest();
        SpringCloudGatewayHttpRequest request = new SpringCloudGatewayHttpRequest((AbstractServerHttpRequest)exchange.getRequest());
        gatewayContext.setRequest((GatewayHttpRequest)request);
        gatewayContext.setWebSocketRequest();
        gatewayContext.setResponse((GatewayHttpResponse)new WebsocketGatewayHttpResponse());
        return gatewayContext;
    }

    public WebSocketMessage getWebSocketMessage(DataBufferFactory bufferFactory, String message) {
        DataBuffer dataBuffer = bufferFactory.wrap(message.getBytes((String)Configuration$.MODULE$.BDP_ENCODING().getValue()));
        return new WebSocketMessage(WebSocketMessage.Type.TEXT, dataBuffer).retain();
    }

    public Mono<Void> sendMsg(DataBufferFactory bufferFactory, WebSocketSession webSocketSession, String message) {
        WebSocketMessage webSocketMessage = this.getWebSocketMessage(bufferFactory, message);
        return webSocketSession.send((Publisher)Flux.just((Object[])new WebSocketMessage[]{webSocketMessage}));
    }

    public Mono<Void> sendMsg(ServerWebExchange exchange, WebSocketSession webSocketSession, String message) {
        return this.sendMsg(exchange.getResponse().bufferFactory(), webSocketSession, message);
    }

    public Mono<Void> sendMsg(ServerWebExchange exchange, WebSocketSession webSocketSession, WebSocketMessage webSocketMessage) {
        return webSocketSession.send((Publisher)Flux.just((Object[])new WebSocketMessage[]{webSocketMessage.retain()}));
    }

    public static final /* synthetic */ boolean $anonfun$removeAllGatewayWebSocketSessionConnection$1(String user$1, Tuple2 x$2) {
        String string = ((GatewayWebSocketSessionConnection)((Object)x$2._2())).user();
        String string2 = user$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$removeGatewayWebSocketSessionConnection$1(InetSocketAddress inetSocketAddress$1, Tuple2 x$3) {
        InetSocketAddress inetSocketAddress = ((GatewayWebSocketSessionConnection)((Object)x$3._2())).getAddress();
        InetSocketAddress inetSocketAddress2 = inetSocketAddress$1;
        return !(inetSocketAddress != null ? !((Object)inetSocketAddress).equals(inetSocketAddress2) : inetSocketAddress2 != null);
    }

    public static final /* synthetic */ void $anonfun$removeGatewayWebSocketSessionConnection$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            GatewayWebSocketSessionConnection session = (GatewayWebSocketSessionConnection)((Object)tuple2._2());
            session.release();
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private SpringCloudGatewayWebsocketUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.SPRING_CLOUD_GATEWAY_WEBSOCKET_HEARTBEAT = ((TimeType)CommonVars$.MODULE$.apply("wds.linkis.gateway.websocket.heartbeat", (Object)new TimeType("5s")).getValue()).toLong();
        this.changeSchemeMethod = WebsocketRoutingFilter.class.getDeclaredMethod("changeSchemeIfIsWebSocketUpgrade", ServerWebExchange.class);
        this.getDelegateMethod = AbstractWebSocketSession.class.getDeclaredMethod("getDelegate", new Class[0]);
        this.getHeadersFiltersMethod = WebsocketRoutingFilter.class.getDeclaredMethod("getHeadersFilters", new Class[0]);
        this.org$apache$linkis$gateway$springcloud$websocket$SpringCloudGatewayWebsocketUtils$$cachedWebSocketSessions = new ConcurrentHashMap();
        this.changeSchemeMethod().setAccessible(true);
        this.getDelegateMethod().setAccessible(true);
        this.getHeadersFiltersMethod().setAccessible(true);
        Utils$.MODULE$.defaultScheduler().scheduleAtFixedRate(new Runnable(){

            public void run() {
                Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(SpringCloudGatewayWebsocketUtils$.MODULE$.org$apache$linkis$gateway$springcloud$websocket$SpringCloudGatewayWebsocketUtils$$cachedWebSocketSessions()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$run$2(x0$1)))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 != null) {
                            String key = (String)tuple2._1();
                            GatewayWebSocketSessionConnection session = (GatewayWebSocketSessionConnection)((Object)((Object)((Object)tuple2._2())));
                            SpringCloudGatewayWebsocketUtils$.MODULE$.logger().info(new StringBuilder(58).append("remove a dead webSocket connection ").append(key).append(" from DWC-UI for user ").append(session.user()).append(".").toString());
                            session.release();
                            return SpringCloudGatewayWebsocketUtils$.MODULE$.org$apache$linkis$gateway$springcloud$websocket$SpringCloudGatewayWebsocketUtils$$cachedWebSocketSessions().remove(key);
                        }
                        throw new MatchError((Object)tuple2);
                    });
                    ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(SpringCloudGatewayWebsocketUtils$.MODULE$.org$apache$linkis$gateway$springcloud$websocket$SpringCloudGatewayWebsocketUtils$$cachedWebSocketSessions()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                        anon.1.$anonfun$run$4(x$1);
                        return BoxedUnit.UNIT;
                    });
                });
            }

            public static final /* synthetic */ boolean $anonfun$run$2(Tuple2 x0$1) {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    GatewayWebSocketSessionConnection session = (GatewayWebSocketSessionConnection)((Object)tuple2._2());
                    session.removeDeadProxySessions();
                    return session.canRelease();
                }
                throw new MatchError((Object)tuple2);
            }

            public static final /* synthetic */ void $anonfun$run$4(Tuple2 x$1) {
                ((GatewayWebSocketSessionConnection)((Object)x$1._2())).heartbeat();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(), $anonfun$run$2$adapted(scala.Tuple2 ), $anonfun$run$3(scala.Tuple2 ), $anonfun$run$4$adapted(scala.Tuple2 )}, serializedLambda);
            }
        }, this.SPRING_CLOUD_GATEWAY_WEBSOCKET_HEARTBEAT(), this.SPRING_CLOUD_GATEWAY_WEBSOCKET_HEARTBEAT(), TimeUnit.MILLISECONDS);
    }
}

