/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.gateway.springcloud.websocket;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.gateway.http.BaseGatewayContext;
import org.apache.linkis.gateway.http.GatewayContext;
import org.apache.linkis.gateway.parser.GatewayParser;
import org.apache.linkis.gateway.route.GatewayRouter;
import org.apache.linkis.gateway.security.GatewaySSOUtils;
import org.apache.linkis.gateway.springcloud.http.SpringCloudGatewayHttpRequest;
import org.apache.linkis.gateway.springcloud.http.SpringCloudHttpUtils;
import org.apache.linkis.gateway.springcloud.websocket.GatewayWebSocketSessionConnection;
import org.apache.linkis.gateway.springcloud.websocket.SpringCloudGatewayWebsocketUtils;
import org.apache.linkis.gateway.springcloud.websocket.WebsocketGatewayHttpResponse;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.socket.controller.ServerEvent;
import org.apache.linkis.server.socket.controller.SocketServerEvent;
import org.reactivestreams.Publisher;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.filter.WebsocketRoutingFilter;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.WebSocketSession;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import org.springframework.web.reactive.socket.server.WebSocketService;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;

public class SpringCloudGatewayWebsocketFilter
implements GlobalFilter,
Ordered {
    private WebsocketRoutingFilter websocketRoutingFilter;
    private WebSocketClient webSocketClient;
    private WebSocketService webSocketService;
    private LoadBalancerClient loadBalancer;
    private GatewayParser parser;
    private GatewayRouter router;

    public SpringCloudGatewayWebsocketFilter(WebsocketRoutingFilter websocketRoutingFilter, WebSocketClient webSocketClient, WebSocketService webSocketService, LoadBalancerClient loadBalancer, GatewayParser parser, GatewayRouter router) {
        this.websocketRoutingFilter = websocketRoutingFilter;
        this.webSocketClient = webSocketClient;
        this.webSocketService = webSocketService;
        this.loadBalancer = loadBalancer;
        this.parser = parser;
        this.router = router;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        SpringCloudGatewayWebsocketUtils.changeSchemeIfIsWebSocketUpgrade(this.websocketRoutingFilter, exchange);
        URI requestUrl = (URI)exchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        String scheme = requestUrl.getScheme();
        if (!ServerWebExchangeUtils.isAlreadyRouted((ServerWebExchange)exchange) && ("ws".equals(scheme) || "wss".equals(scheme))) {
            ServerWebExchangeUtils.setAlreadyRouted((ServerWebExchange)exchange);
            HttpHeaders headers = exchange.getRequest().getHeaders();
            List protocols = headers.get((Object)"Sec-WebSocket-Protocol");
            if (protocols != null) {
                protocols = protocols.stream().flatMap(header -> Arrays.stream(StringUtils.commaDelimitedListToStringArray((String)header))).map(String::trim).collect(Collectors.toList());
            }
            List collectedProtocols = protocols;
            BaseGatewayContext gatewayContext = SpringCloudGatewayWebsocketUtils.getGatewayContext(exchange);
            return this.webSocketService.handleRequest(exchange, new WebSocketHandler((GatewayContext)gatewayContext, exchange, requestUrl, collectedProtocols){
                final /* synthetic */ GatewayContext val$gatewayContext;
                final /* synthetic */ ServerWebExchange val$exchange;
                final /* synthetic */ URI val$requestUrl;
                final /* synthetic */ List val$collectedProtocols;
                {
                    this.val$gatewayContext = gatewayContext;
                    this.val$exchange = serverWebExchange;
                    this.val$requestUrl = uRI;
                    this.val$collectedProtocols = list;
                }

                public Mono<Void> handle(WebSocketSession webClientSocketSession) {
                    final GatewayWebSocketSessionConnection gatewayWebSocketSession = SpringCloudGatewayWebsocketUtils.getGatewayWebSocketSessionConnection(GatewaySSOUtils.getLoginUsername((GatewayContext)this.val$gatewayContext), webClientSocketSession);
                    final FluxSinkListener<WebSocketMessage> fluxSinkListener = new FluxSinkListener<WebSocketMessage>(){
                        private FluxSink<WebSocketMessage> fluxSink = null;

                        @Override
                        public void setFluxSink(FluxSink<WebSocketMessage> fluxSink) {
                            this.fluxSink = fluxSink;
                        }

                        @Override
                        public void next(WebSocketMessage webSocketMessage) {
                            if (this.fluxSink != null) {
                                this.fluxSink.next((Object)webSocketMessage);
                            }
                            GatewaySSOUtils.updateLastAccessTime((GatewayContext)val$gatewayContext);
                        }

                        @Override
                        public void complete() {
                            if (this.fluxSink != null) {
                                this.fluxSink.complete();
                            }
                        }
                    };
                    Flux receives = Flux.create(sink -> fluxSinkListener.setFluxSink((FluxSink<WebSocketMessage>)sink));
                    gatewayWebSocketSession.receive().doOnNext(WebSocketMessage::retain).map(t -> {
                        int port;
                        String host;
                        String user;
                        try {
                            user = GatewaySSOUtils.getLoginUsername((GatewayContext)this.val$gatewayContext);
                        }
                        catch (Throwable e) {
                            if (gatewayWebSocketSession.isAlive()) {
                                String message = Message.response((Message)Message.noLogin((String)e.getMessage()).$less$less(this.val$gatewayContext.getRequest().getRequestURI()));
                                fluxSinkListener.next(SpringCloudGatewayWebsocketUtils.getWebSocketMessage((DataBufferFactory)gatewayWebSocketSession.bufferFactory(), message));
                            }
                            return gatewayWebSocketSession.close();
                        }
                        if (t.getType() == WebSocketMessage.Type.PING || t.getType() == WebSocketMessage.Type.PONG) {
                            WebSocketMessage pingMsg = new WebSocketMessage(WebSocketMessage.Type.PING, t.getPayload());
                            gatewayWebSocketSession.heartbeat(pingMsg);
                            return SpringCloudGatewayWebsocketUtils.sendMsg(this.val$exchange, (WebSocketSession)gatewayWebSocketSession, pingMsg);
                        }
                        final String json = t.getPayloadAsText();
                        t.release();
                        ServerEvent serverEvent = SocketServerEvent.getServerEvent((String)json);
                        ((SpringCloudGatewayHttpRequest)this.val$gatewayContext.getRequest()).setRequestBody(SocketServerEvent.getMessageData((ServerEvent)serverEvent));
                        ((SpringCloudGatewayHttpRequest)this.val$gatewayContext.getRequest()).setRequestURI(serverEvent.getMethod());
                        SpringCloudGatewayWebsocketFilter.this.parser.parse(this.val$gatewayContext);
                        if (this.val$gatewayContext.getResponse().isCommitted()) {
                            return SpringCloudGatewayWebsocketUtils.sendMsg(this.val$exchange, (WebSocketSession)gatewayWebSocketSession, ((WebsocketGatewayHttpResponse)this.val$gatewayContext.getResponse()).getWebSocketMsg());
                        }
                        final ServiceInstance serviceInstance = SpringCloudGatewayWebsocketFilter.this.router.route(this.val$gatewayContext);
                        if (this.val$gatewayContext.getResponse().isCommitted()) {
                            return SpringCloudGatewayWebsocketUtils.sendMsg(this.val$exchange, (WebSocketSession)gatewayWebSocketSession, ((WebsocketGatewayHttpResponse)this.val$gatewayContext.getResponse()).getWebSocketMsg());
                        }
                        WebSocketSession webSocketProxySession = SpringCloudGatewayWebsocketUtils.getProxyWebSocketSession((WebSocketSession)gatewayWebSocketSession, serviceInstance);
                        if (webSocketProxySession != null) {
                            return SpringCloudGatewayWebsocketUtils.sendMsg(this.val$exchange, webSocketProxySession, json);
                        }
                        URI uri = this.val$exchange.getRequest().getURI();
                        Boolean encoded = ServerWebExchangeUtils.containsEncodedParts((URI)uri);
                        if (StringUtils.isEmpty((Object)serviceInstance.getInstance())) {
                            org.springframework.cloud.client.ServiceInstance service = SpringCloudGatewayWebsocketFilter.this.loadBalancer.choose(serviceInstance.getApplicationName());
                            host = service.getHost();
                            port = service.getPort();
                        } else {
                            String[] instanceInfo = serviceInstance.getInstance().split(":");
                            host = instanceInfo[0];
                            port = Integer.parseInt(instanceInfo[1]);
                        }
                        URI requestURI = UriComponentsBuilder.fromUri((URI)this.val$requestUrl).host(host).port(port).build(encoded.booleanValue()).toUri();
                        HttpHeaders filtered = HttpHeadersFilter.filterRequest(SpringCloudGatewayWebsocketUtils.getHeadersFilters(SpringCloudGatewayWebsocketFilter.this.websocketRoutingFilter), (ServerWebExchange)this.val$exchange);
                        SpringCloudHttpUtils.addIgnoreTimeoutSignal(filtered);
                        return SpringCloudGatewayWebsocketFilter.this.webSocketClient.execute(requestURI, filtered, new WebSocketHandler(){

                            public Mono<Void> handle(WebSocketSession proxySession) {
                                SpringCloudGatewayWebsocketUtils.setProxyWebSocketSession(user, serviceInstance, (WebSocketSession)gatewayWebSocketSession, proxySession);
                                Mono<Void> proxySessionSend = SpringCloudGatewayWebsocketUtils.sendMsg(val$exchange, proxySession, json);
                                proxySessionSend.subscribe();
                                return SpringCloudGatewayWebsocketUtils.getProxyWebSocketSession((WebSocketSession)gatewayWebSocketSession, serviceInstance).receive().doOnNext(WebSocketMessage::retain).doOnNext(fluxSinkListener::next).then();
                            }

                            public List<String> getSubProtocols() {
                                return val$collectedProtocols;
                            }
                        });
                    }).doOnComplete(fluxSinkListener::complete).doOnNext(Mono::subscribe).subscribe();
                    return gatewayWebSocketSession.send((Publisher)receives);
                }

                public List<String> getSubProtocols() {
                    return this.val$collectedProtocols;
                }
            });
        }
        return chain.filter(exchange);
    }

    public int getOrder() {
        return this.websocketRoutingFilter.getOrder() - 1;
    }

    static interface FluxSinkListener<T> {
        public void setFluxSink(FluxSink<T> var1);

        public void next(T var1);

        public void complete();
    }
}

