/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.gateway.springcloud.http;

import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import org.apache.linkis.server.security.SecurityFilter;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.web.reactive.socket.WebSocketMessage;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.http.websocket.WebsocketOutbound;

public class SpringCloudHttpUtils {
    public static Mono<Void> sendWebSocket(WebsocketOutbound out, DataBuffer dataBuffer) {
        WebSocketMessage webSocketMessage = new WebSocketMessage(WebSocketMessage.Type.TEXT, dataBuffer).retain();
        TextWebSocketFrame textWebSocketFrame = new TextWebSocketFrame(NettyDataBufferFactory.toByteBuf((DataBuffer)webSocketMessage.getPayload()));
        Flux frames = Flux.just((Object)textWebSocketFrame);
        return out.sendObject((Publisher)frames).then();
    }

    public static void addIgnoreTimeoutSignal(HttpHeaders httpHeaders) {
        Cookie cookie = SecurityFilter.ignoreTimeoutSignal();
        HashMap<String, Cookie[]> cookies = new HashMap<String, Cookie[]>();
        cookies.put(cookie.getName(), new Cookie[]{cookie});
        SpringCloudHttpUtils.addCookies(httpHeaders, cookies);
    }

    public static void addCookies(HttpHeaders httpHeaders, Map<String, Cookie[]> cookies) {
        if (cookies == null || cookies.isEmpty()) {
            return;
        }
        StringBuilder cookieStr = new StringBuilder();
        for (String cookieName : cookies.keySet()) {
            Cookie[] cookie = cookies.get(cookieName);
            if (cookie == null || cookie.length == 0) continue;
            HttpCookie httpCookie = new HttpCookie(cookie[0].getName(), cookie[0].getValue());
            cookieStr.append(httpCookie.toString()).append(";");
        }
        if (cookieStr.length() > 1) {
            cookieStr.setLength(cookieStr.length() - 1);
            if (!httpHeaders.containsKey((Object)"Cookie")) {
                httpHeaders.set("Cookie", cookieStr.toString());
            } else {
                httpHeaders.set("Cookie", httpHeaders.getFirst("Cookie") + ";" + cookieStr.toString());
            }
        }
    }
}

