/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.scheduler.executer;

import java.io.Serializable;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.protocol.engine.EngineState;
import org.apache.linkis.scheduler.errorcode.LinkisSchedulerErrorCodeSummary;
import org.apache.linkis.scheduler.exception.SchedulerErrorException;
import org.apache.linkis.scheduler.executer.Executor;
import org.apache.linkis.scheduler.executer.ExecutorInfo;
import org.apache.linkis.scheduler.executer.ExecutorState$;
import org.apache.linkis.scheduler.listener.ExecutorListener;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ef!\u0002\u0010 \u0003\u0003Q\u0003\u0002C \u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u000b\u0019\u0003A\u0011A$\t\u000f)\u0003\u0001\u0019!C\u0005\u0017\"9\u0001\r\u0001a\u0001\n\u0013\t\u0007BB4\u0001A\u0003&A\nC\u0004i\u0001\u0001\u0007I\u0011B5\t\u000f)\u0004\u0001\u0019!C\u0005W\"1Q\u000e\u0001Q!\n\u0001CqA\u001c\u0001A\u0002\u0013%q\u000eC\u0004z\u0001\u0001\u0007I\u0011\u0002>\t\rq\u0004\u0001\u0015)\u0003q\u0011\u0015i\b\u0001\"\u0001\u007f\u0011\u001d\t\t\u0001\u0001D\t\u0003\u0007Aq!!\u0002\u0001\t#\t9\u0001C\u0004\u0002\u0010\u0001!\t\"a\u0002\t\u000f\u0005E\u0001\u0001\"\u0005\u0002\u0014!9\u0011q\u0007\u0001\u0005\u0012\u0005e\u0002bBA#\u0001\u0011E\u0011q\t\u0005\b\u0003/\u0002A\u0011CA-\u0011\u001d\t)\u0007\u0001C\t\u0003OBq!!\u001a\u0001\t#\t\u0019\bC\u0004\u0002\u0004\u0002!\t\"!\"\t\u000f\u0005E\u0005\u0001\"\u0005\u0002\u0014\"9\u0011q\u0014\u0001\u0005\u0012\u0005\u0005\u0006BBAS\u0001\u0011\u0005\u0013\u000e\u0003\u0004\u0002N\u0001!\te\u0013\u0005\b\u0003O\u0003A\u0011IAU\u0011\u0019\t\t\f\u0001C\u0001S\"9\u00111\u0017\u0001\u0005\u0002\u0005U&\u0001E!cgR\u0014\u0018m\u0019;Fq\u0016\u001cW\u000f^8s\u0015\t\u0001\u0013%\u0001\u0005fq\u0016\u001cW\u000f^3s\u0015\t\u00113%A\u0005tG\",G-\u001e7fe*\u0011A%J\u0001\u0007Y&t7.[:\u000b\u0005\u0019:\u0013AB1qC\u000eDWMC\u0001)\u0003\ry'oZ\u0002\u0001'\u0011\u00011fM\u001c\u0011\u00051\nT\"A\u0017\u000b\u00059z\u0013\u0001\u00027b]\u001eT\u0011\u0001M\u0001\u0005U\u00064\u0018-\u0003\u00023[\t1qJ\u00196fGR\u0004\"\u0001N\u001b\u000e\u0003}I!AN\u0010\u0003\u0011\u0015CXmY;u_J\u0004\"\u0001O\u001f\u000e\u0003eR!AO\u001e\u0002\u000bU$\u0018\u000e\\:\u000b\u0005q\u001a\u0013AB2p[6|g.\u0003\u0002?s\t9Aj\\4hS:<\u0017AA5e!\t\tE)D\u0001C\u0015\u0005\u0019\u0015!B:dC2\f\u0017BA#C\u0005\u0011auN\\4\u0002\rqJg.\u001b;?)\tA\u0015\n\u0005\u00025\u0001!)qH\u0001a\u0001\u0001\u00061ql\u001d;bi\u0016,\u0012\u0001\u0014\t\u0003\u001bvs!AT.\u000f\u0005=SfB\u0001)Z\u001d\t\t\u0006L\u0004\u0002S/:\u00111KV\u0007\u0002)*\u0011Q+K\u0001\u0007yI|w\u000e\u001e \n\u0003!J!AJ\u0014\n\u0005\u0011*\u0013B\u0001\u0012$\u0013\t\u0001\u0013%\u0003\u0002]?\u0005iQ\t_3dkR|'o\u0015;bi\u0016L!AX0\u0003\u001b\u0015CXmY;u_J\u001cF/\u0019;f\u0015\tav$\u0001\u0006`gR\fG/Z0%KF$\"AY3\u0011\u0005\u0005\u001b\u0017B\u00013C\u0005\u0011)f.\u001b;\t\u000f\u0019$\u0011\u0011!a\u0001\u0019\u0006\u0019\u0001\u0010J\u0019\u0002\u000f}\u001bH/\u0019;fA\u0005\u0001B.Y:u\u0003\u000e$\u0018N^5usRKW.Z\u000b\u0002\u0001\u0006!B.Y:u\u0003\u000e$\u0018N^5usRKW.Z0%KF$\"A\u00197\t\u000f\u0019<\u0011\u0011!a\u0001\u0001\u0006\tB.Y:u\u0003\u000e$\u0018N^5usRKW.\u001a\u0011\u0002!\u0015DXmY;u_Jd\u0015n\u001d;f]\u0016\u0014X#\u00019\u0011\u0007\u0005\u000b8/\u0003\u0002s\u0005\n1q\n\u001d;j_:\u0004\"\u0001^<\u000e\u0003UT!A^\u0011\u0002\u00111L7\u000f^3oKJL!\u0001_;\u0003!\u0015CXmY;u_Jd\u0015n\u001d;f]\u0016\u0014\u0018\u0001F3yK\u000e,Ho\u001c:MSN$XM\\3s?\u0012*\u0017\u000f\u0006\u0002cw\"9aMCA\u0001\u0002\u0004\u0001\u0018!E3yK\u000e,Ho\u001c:MSN$XM\\3sA\u0005\u00192/\u001a;Fq\u0016\u001cW\u000f^8s\u0019&\u001cH/\u001a8feR\u0011!m \u0005\u0006]2\u0001\ra]\u0001\tG\u0006dGNY1dWR\t!-\u0001\u0004jg&#G.Z\u000b\u0003\u0003\u0013\u00012!QA\u0006\u0013\r\tiA\u0011\u0002\b\u0005>|G.Z1o\u0003\u0019I7OQ;ts\u0006Aq\u000f[3o\u0005V\u001c\u00180\u0006\u0003\u0002\u0016\u0005-B\u0003BA\f\u0003;\u00012!QA\r\u0013\r\tYB\u0011\u0002\u0004\u0003:L\b\u0002CA\u0010!\u0011\u0005\r!!\t\u0002\u0003\u0019\u0004R!QA\u0012\u0003OI1!!\nC\u0005!a$-\u001f8b[\u0016t\u0004\u0003BA\u0015\u0003Wa\u0001\u0001B\u0004\u0002.A\u0011\r!a\f\u0003\u0003\u0005\u000bB!!\r\u0002\u0018A\u0019\u0011)a\r\n\u0007\u0005U\"IA\u0004O_RD\u0017N\\4\u0002\u0011]DWM\\%eY\u0016,B!a\u000f\u0002DQ!\u0011qCA\u001f\u0011!\ty\"\u0005CA\u0002\u0005}\u0002#B!\u0002$\u0005\u0005\u0003\u0003BA\u0015\u0003\u0007\"q!!\f\u0012\u0005\u0004\ty#A\u0005xQ\u0016t7\u000b^1uKV!\u0011\u0011JA+)\u0019\t9\"a\u0013\u0002P!1\u0011Q\n\nA\u00021\u000bQa\u001d;bi\u0016D\u0001\"a\b\u0013\t\u0003\u0007\u0011\u0011\u000b\t\u0006\u0003\u0006\r\u00121\u000b\t\u0005\u0003S\t)\u0006B\u0004\u0002.I\u0011\r!a\f\u0002\u0015\u0015t7/\u001e:f\u0005V\u001c\u00180\u0006\u0003\u0002\\\u0005}C\u0003BA/\u0003C\u0002B!!\u000b\u0002`\u00119\u0011QF\nC\u0002\u0005=\u0002\u0002CA\u0010'\u0011\u0005\r!a\u0019\u0011\u000b\u0005\u000b\u0019#!\u0018\u0002\u0015\u0015t7/\u001e:f\u0013\u0012dW-\u0006\u0003\u0002j\u00055D\u0003BA6\u0003_\u0002B!!\u000b\u0002n\u00119\u0011Q\u0006\u000bC\u0002\u0005=\u0002\u0002CA\u0010)\u0011\u0005\r!!\u001d\u0011\u000b\u0005\u000b\u0019#a\u001b\u0016\t\u0005U\u0014\u0011\u0010\u000b\u0007\u0003o\nY(a \u0011\t\u0005%\u0012\u0011\u0010\u0003\b\u0003[)\"\u0019AA\u0018\u0011!\ty\"\u0006CA\u0002\u0005u\u0004#B!\u0002$\u0005]\u0004bBAA+\u0001\u0007\u0011\u0011B\u0001\u0010iJ\fgn]5uS>t7\u000b^1uK\u0006yQM\\:ve\u0016\fe/Y5mC\ndW-\u0006\u0003\u0002\b\u0006-E\u0003BAE\u0003\u001b\u0003B!!\u000b\u0002\f\u00129\u0011Q\u0006\fC\u0002\u0005=\u0002\u0002CA\u0010-\u0011\u0005\r!a$\u0011\u000b\u0005\u000b\u0019#!#\u0002\u001b]DWM\\!wC&d\u0017M\u00197f+\u0011\t)*!'\u0015\t\u0005]\u00151\u0014\t\u0005\u0003S\tI\nB\u0004\u0002.]\u0011\r!a\f\t\u0011\u0005}q\u0003\"a\u0001\u0003;\u0003R!QA\u0012\u0003/\u000b!\u0002\u001e:b]NLG/[8o)\r\u0011\u00171\u0015\u0005\u0007\u0003\u001bB\u0002\u0019\u0001'\u0002\u000b\u001d,G/\u00133\u0002\u001f\u001d,G/\u0012=fGV$xN]%oM>,\"!a+\u0011\u0007Q\ni+C\u0002\u00020~\u0011A\"\u0012=fGV$xN]%oM>\f1cZ3u\u0019\u0006\u001cH/Q2uSZLG/\u001f+j[\u0016\f1c]3u\u0019\u0006\u001cH/Q2uSZLG/\u001f+j[\u0016$2AYA\\\u0011\u0015AW\u00041\u0001A\u0001")
public abstract class AbstractExecutor
implements Executor,
Logging {
    private final long id;
    private EngineState _state;
    private long lastActivityTime;
    private Option<ExecutorListener> executorListener;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        AbstractExecutor abstractExecutor = this;
        synchronized (abstractExecutor) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private EngineState _state() {
        return this._state;
    }

    private void _state_$eq(EngineState x$1) {
        this._state = x$1;
    }

    private long lastActivityTime() {
        return this.lastActivityTime;
    }

    private void lastActivityTime_$eq(long x$1) {
        this.lastActivityTime = x$1;
    }

    private Option<ExecutorListener> executorListener() {
        return this.executorListener;
    }

    private void executorListener_$eq(Option<ExecutorListener> x$1) {
        this.executorListener = x$1;
    }

    public void setExecutorListener(ExecutorListener executorListener) {
        this.executorListener_$eq((Option<ExecutorListener>)new Some((Object)executorListener));
    }

    public abstract void callback();

    public boolean isIdle() {
        EngineState engineState = this._state();
        EngineState engineState2 = ExecutorState$.MODULE$.Idle();
        return !(engineState != null ? !engineState.equals(engineState2) : engineState2 != null);
    }

    public boolean isBusy() {
        EngineState engineState = this._state();
        EngineState engineState2 = ExecutorState$.MODULE$.Busy();
        return !(engineState != null ? !engineState.equals(engineState2) : engineState2 != null);
    }

    public <A> Object whenBusy(Function0<A> f) {
        return this.whenState(ExecutorState$.MODULE$.Busy(), f);
    }

    public <A> Object whenIdle(Function0<A> f) {
        return this.whenState(ExecutorState$.MODULE$.Idle(), f);
    }

    public <A> Object whenState(EngineState state, Function0<A> f) {
        EngineState engineState = this._state();
        EngineState engineState2 = state;
        if (!(engineState != null ? !engineState.equals(engineState2) : engineState2 != null)) {
            return f.apply();
        }
        return BoxedUnit.UNIT;
    }

    public <A> A ensureBusy(Function0<A> f) {
        block6: {
            this.lastActivityTime_$eq(System.currentTimeMillis());
            EngineState engineState = this._state();
            EngineState engineState2 = ExecutorState$.MODULE$.Busy();
            if (!(engineState != null ? !engineState.equals(engineState2) : engineState2 != null)) {
                AbstractExecutor abstractExecutor = this;
                synchronized (abstractExecutor) {
                    Object object;
                    block5: {
                        EngineState engineState3 = this._state();
                        EngineState engineState4 = ExecutorState$.MODULE$.Busy();
                        if (!(engineState3 != null ? !engineState3.equals(engineState4) : engineState4 != null)) {
                            object = f.apply();
                            break block5;
                        }
                        break block6;
                    }
                    return (A)object;
                }
            }
        }
        throw new SchedulerErrorException(LinkisSchedulerErrorCodeSummary.NODE_STATE_ERROR.getErrorCode(), new StringOps(Predef$.MODULE$.augmentString("%s is in state %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toString(), this._state()})));
    }

    public <A> A ensureIdle(Function0<A> f) {
        return this.ensureIdle(f, true);
    }

    public <A> A ensureIdle(Function0<A> f, boolean transitionState) {
        block7: {
            EngineState engineState = this._state();
            EngineState engineState2 = ExecutorState$.MODULE$.Idle();
            if (!(engineState != null ? !engineState.equals(engineState2) : engineState2 != null)) {
                AbstractExecutor abstractExecutor = this;
                synchronized (abstractExecutor) {
                    Object object;
                    block6: {
                        EngineState engineState3 = this._state();
                        EngineState engineState4 = ExecutorState$.MODULE$.Idle();
                        if (!(engineState3 != null ? !engineState3.equals(engineState4) : engineState4 != null)) {
                            if (transitionState) {
                                this.transition(ExecutorState$.MODULE$.Busy());
                            }
                            object = Utils$.MODULE$.tryFinally(f, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                                if (transitionState) {
                                    this.transition(ExecutorState$.MODULE$.Idle());
                                }
                                this.callback();
                            });
                            break block6;
                        }
                        break block7;
                    }
                    return (A)object;
                }
            }
        }
        throw new SchedulerErrorException(LinkisSchedulerErrorCodeSummary.NODE_STATE_ERROR.getErrorCode(), new StringOps(Predef$.MODULE$.augmentString("%s is in state %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toString(), this._state()})));
    }

    public <A> A ensureAvailable(Function0<A> f) {
        block6: {
            if (ExecutorState$.MODULE$.isAvailable(this._state())) {
                AbstractExecutor abstractExecutor = this;
                synchronized (abstractExecutor) {
                    Object object;
                    block5: {
                        if (ExecutorState$.MODULE$.isAvailable(this._state())) {
                            object = Utils$.MODULE$.tryFinally(f, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.callback());
                            break block5;
                        }
                        break block6;
                    }
                    return (A)object;
                }
            }
        }
        throw new SchedulerErrorException(LinkisSchedulerErrorCodeSummary.NODE_STATE_ERROR.getErrorCode(), new StringOps(Predef$.MODULE$.augmentString("%s is in state %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toString(), this._state()})));
    }

    public <A> A whenAvailable(Function0<A> f) {
        if (ExecutorState$.MODULE$.isAvailable(this._state())) {
            return (A)Utils$.MODULE$.tryFinally(f, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.callback());
        }
        throw new SchedulerErrorException(LinkisSchedulerErrorCodeSummary.NODE_STATE_ERROR.getErrorCode(), new StringOps(Predef$.MODULE$.augmentString("%s is in state %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toString(), this._state()})));
    }

    public synchronized void transition(EngineState state) {
        boolean bl;
        this.lastActivityTime_$eq(System.currentTimeMillis());
        EngineState engineState = this._state();
        EngineState engineState2 = ExecutorState$.MODULE$.Error();
        EngineState engineState3 = engineState;
        if (!(engineState2 != null ? !engineState2.equals(engineState3) : engineState3 != null)) {
            bl = true;
        } else {
            EngineState engineState4 = ExecutorState$.MODULE$.Dead();
            EngineState engineState5 = engineState;
            if (!(engineState4 != null ? !engineState4.equals(engineState5) : engineState5 != null)) {
                bl = true;
            } else {
                EngineState engineState6 = ExecutorState$.MODULE$.Success();
                EngineState engineState7 = engineState;
                bl = !(engineState6 != null ? !engineState6.equals(engineState7) : engineState7 != null);
            }
        }
        if (bl) {
            this.logger().warn(new StringBuilder(41).append(this.toString()).append(" attempt to change state ").append(this._state()).append(" => ").append(state).append(", ignore it.").toString());
            return;
        }
        EngineState engineState8 = ExecutorState$.MODULE$.ShuttingDown();
        EngineState engineState9 = engineState;
        if (!(engineState8 != null ? !engineState8.equals(engineState9) : engineState9 != null)) {
            boolean bl2;
            EngineState engineState10 = state;
            EngineState engineState11 = ExecutorState$.MODULE$.Error();
            EngineState engineState12 = engineState10;
            if (!(engineState11 != null ? !engineState11.equals(engineState12) : engineState12 != null)) {
                bl2 = true;
            } else {
                EngineState engineState13 = ExecutorState$.MODULE$.Dead();
                EngineState engineState14 = engineState10;
                if (!(engineState13 != null ? !engineState13.equals(engineState14) : engineState14 != null)) {
                    bl2 = true;
                } else {
                    EngineState engineState15 = ExecutorState$.MODULE$.Success();
                    EngineState engineState16 = engineState10;
                    bl2 = !(engineState15 != null ? !engineState15.equals(engineState16) : engineState16 != null);
                }
            }
            if (bl2) {
                EngineState oldState = this._state();
                this._state_$eq(state);
                this.executorListener().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    x$1.onExecutorStateChanged(this, oldState, state);
                    return BoxedUnit.UNIT;
                });
            } else {
                this.logger().warn(new StringBuilder(57).append(this.toString()).append(" attempt to change a ShuttingDown session to ").append(state).append(", ignore it.").toString());
            }
            return;
        }
        this.logger().info(new StringBuilder(19).append(this.toString()).append(" change state ").append(this._state()).append(" => ").append(state).append(".").toString());
        EngineState oldState = this._state();
        this._state_$eq(state);
        this.executorListener().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.onExecutorStateChanged(this, oldState, state);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public EngineState state() {
        return this._state();
    }

    @Override
    public ExecutorInfo getExecutorInfo() {
        return new ExecutorInfo(this.id, this._state());
    }

    public long getLastActivityTime() {
        return this.lastActivityTime();
    }

    public void setLastActivityTime(long lastActivityTime) {
        this.lastActivityTime_$eq(lastActivityTime);
    }

    public AbstractExecutor(long id) {
        this.id = id;
        Logging.$init$((Logging)this);
        this._state = ExecutorState$.MODULE$.Starting();
        this.lastActivityTime = System.currentTimeMillis();
        this.executorListener = None$.MODULE$;
    }
}

