/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.rpc.interceptor.common;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.linkis.common.exception.WarnException;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.protocol.CacheableProtocol;
import org.apache.linkis.protocol.Protocol;
import org.apache.linkis.rpc.conf.RPCConfiguration$;
import org.apache.linkis.rpc.interceptor.RPCInterceptor;
import org.apache.linkis.rpc.interceptor.RPCInterceptorChain;
import org.apache.linkis.rpc.interceptor.RPCInterceptorExchange;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Component
@ScalaSignature(bytes="\u0006\u0001)4A\u0001C\u0005\u0001-!)\u0001\u0006\u0001C\u0001S!9A\u0006\u0001b\u0001\n\u0013i\u0003B\u0002\u001f\u0001A\u0003%a\u0006C\u0004>\u0001\t\u0007I\u0011\t \t\r\t\u0003\u0001\u0015!\u0003@\u0011\u0015\u0019\u0005\u0001\"\u0011E\u0011\u0015y\u0005\u0001\"\u0001Q\u0005]\u0019\u0015m\u00195fC\ndWM\u0015)D\u0013:$XM]2faR|'O\u0003\u0002\u000b\u0017\u000511m\\7n_:T!\u0001D\u0007\u0002\u0017%tG/\u001a:dKB$xN\u001d\u0006\u0003\u001d=\t1A\u001d9d\u0015\t\u0001\u0012#\u0001\u0004mS:\\\u0017n\u001d\u0006\u0003%M\ta!\u00199bG\",'\"\u0001\u000b\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u00019R$\t\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005yyR\"A\u0006\n\u0005\u0001Z!A\u0004*Q\u0007&sG/\u001a:dKB$xN\u001d\t\u0003E\u0019j\u0011a\t\u0006\u0003I\u0015\nQ!\u001e;jYNT!AC\b\n\u0005\u001d\u001a#a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003)\u0002\"a\u000b\u0001\u000e\u0003%\t!bZ;bm\u0006\u001c\u0015m\u00195f+\u0005q\u0003\u0003B\u00188sej\u0011\u0001\r\u0006\u0003cI\nQaY1dQ\u0016T!AC\u001a\u000b\u0005Q*\u0014AB4p_\u001edWMC\u00017\u0003\r\u0019w.\\\u0005\u0003qA\u0012QaQ1dQ\u0016\u0004\"\u0001\u0007\u001e\n\u0005mJ\"aA!os\u0006Yq-^1wC\u000e\u000b7\r[3!\u0003\u0015y'\u000fZ3s+\u0005y\u0004C\u0001\rA\u0013\t\t\u0015DA\u0002J]R\faa\u001c:eKJ\u0004\u0013!C5oi\u0016\u00148-\u001a9u)\rITI\u0013\u0005\u0006\r\u001a\u0001\raR\u0001\u0014S:$XM]2faR|'/\u0012=dQ\u0006tw-\u001a\t\u0003=!K!!S\u0006\u0003-I\u00036)\u00138uKJ\u001cW\r\u001d;pe\u0016C8\r[1oO\u0016DQa\u0013\u0004A\u00021\u000bQa\u00195bS:\u0004\"AH'\n\u00059[!a\u0005*Q\u0007&sG/\u001a:dKB$xN]\"iC&t\u0017a\u0003:f[>4XmQ1dQ\u0016$\"!\u0015+\u0011\u0005a\u0011\u0016BA*\u001a\u0005\u001d\u0011un\u001c7fC:DQ!V\u0004A\u0002Y\u000b\u0001bY1dQ\u0016\\U-\u001f\t\u0003/zs!\u0001\u0017/\u0011\u0005eKR\"\u0001.\u000b\u0005m+\u0012A\u0002\u001fs_>$h(\u0003\u0002^3\u00051\u0001K]3eK\u001aL!a\u00181\u0003\rM#(/\u001b8h\u0015\ti\u0016\u0004\u000b\u0002\u0001EB\u00111\r[\u0007\u0002I*\u0011QMZ\u0001\u000bgR,'/Z8usB,'BA4\u0014\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\\u0017BA5e\u0005%\u0019u.\u001c9p]\u0016tG\u000f")
public class CacheableRPCInterceptor
implements RPCInterceptor,
Logging {
    private final Cache<Object, Object> guavaCache;
    private final int order;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        CacheableRPCInterceptor cacheableRPCInterceptor = this;
        synchronized (cacheableRPCInterceptor) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private Cache<Object, Object> guavaCache() {
        return this.guavaCache;
    }

    @Override
    public int order() {
        return this.order;
    }

    @Override
    public Object intercept(RPCInterceptorExchange interceptorExchange, RPCInterceptorChain chain) {
        Protocol protocol = interceptorExchange.getProtocol();
        if (protocol instanceof CacheableProtocol) {
            CacheableProtocol cacheableProtocol = (CacheableProtocol)protocol;
            return this.guavaCache().get((Object)cacheableProtocol.toString(), (Callable)new Callable<Object>(null, chain, interceptorExchange){
                private final RPCInterceptorChain chain$1;
                private final RPCInterceptorExchange interceptorExchange$1;

                public Object call() {
                    Object returnMsg = this.chain$1.handle(this.interceptorExchange$1);
                    Object object = returnMsg;
                    if (object instanceof WarnException) {
                        WarnException warnException = (WarnException)object;
                        throw warnException;
                    }
                    return returnMsg;
                }
                {
                    this.chain$1 = chain$1;
                    this.interceptorExchange$1 = interceptorExchange$1;
                }
            });
        }
        return chain.handle(interceptorExchange);
    }

    public boolean removeCache(String cacheKey) {
        return BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (StringUtils.isEmpty((Object)cacheKey)) break block0;
                this.guavaCache().invalidate((Object)cacheKey);
            }
            return true;
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CacheableRPCInterceptor.$anonfun$removeCache$2(this, cacheKey, x0$1))));
    }

    public static final /* synthetic */ boolean $anonfun$removeCache$2(CacheableRPCInterceptor $this, String cacheKey$1, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            $this.logger().warn(new StringBuilder(37).append("Failed to clean RPC cache, cache key:").append(cacheKey$1).toString(), (Throwable)exception);
            return false;
        }
        throw new MatchError((Object)throwable);
    }

    public CacheableRPCInterceptor() {
        Logging.$init$((Logging)this);
        this.guavaCache = CacheBuilder.newBuilder().concurrencyLevel(5).expireAfterAccess(BoxesRunTime.unboxToLong((Object)RPCConfiguration$.MODULE$.BDP_RPC_CACHE_CONF_EXPIRE_TIME().getValue()), TimeUnit.MILLISECONDS).initialCapacity(20).maximumSize(1000L).recordStats().removalListener((RemovalListener)new RemovalListener<Object, Object>(this){
            private final /* synthetic */ CacheableRPCInterceptor $outer;

            public void onRemoval(RemovalNotification<Object, Object> removalNotification) {
                this.$outer.logger().debug(new StringBuilder(39).append("CacheSender removed key => ").append(removalNotification.getKey()).append(", value => ").append(removalNotification.getValue()).append(".").toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).build();
        this.order = 10;
    }
}

