/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.server.utils;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.proxy.ProxyUserEntity;
import org.apache.linkis.server.security.ProxyUserSSOUtils;
import org.apache.linkis.server.security.SecurityFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public class ModuleUserUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleUserUtils.class);
    private static String TOKEN_KEY = "Token-Code";
    private static String TOKEN_USER_KEY = "Token-User";

    public static ProxyUserEntity getProxyUserEntity(HttpServletRequest httpServletRequest) {
        String loginUser = SecurityFilter.getLoginUsername(httpServletRequest);
        Option<String> proxyUserUsername = ProxyUserSSOUtils.getProxyUserUsername(httpServletRequest);
        ProxyUserEntity proxyUserEntity = new ProxyUserEntity();
        proxyUserEntity.setUsername(loginUser);
        if (proxyUserUsername.isDefined()) {
            proxyUserEntity.setProxyUser((String)proxyUserUsername.get());
        }
        return proxyUserEntity;
    }

    public static ProxyUserEntity getProxyUserEntity(HttpServletRequest httpServletRequest, String msg) {
        ProxyUserEntity proxyUserEntity = ModuleUserUtils.getProxyUserEntity(httpServletRequest);
        LOGGER.info("user {} proxy to {} operation {}", new Object[]{proxyUserEntity.getUsername(), proxyUserEntity.getProxyUser(), msg});
        return proxyUserEntity;
    }

    public static String getOperationUser(HttpServletRequest httpServletRequest) {
        ProxyUserEntity proxyUserEntity = ModuleUserUtils.getProxyUserEntity(httpServletRequest);
        if (proxyUserEntity.isProxyMode()) {
            return proxyUserEntity.getProxyUser();
        }
        return proxyUserEntity.getUsername();
    }

    public static String getOperationUser(HttpServletRequest httpServletRequest, String msg) {
        ProxyUserEntity proxyUserEntity = ModuleUserUtils.getProxyUserEntity(httpServletRequest, msg);
        if (proxyUserEntity.isProxyMode()) {
            return proxyUserEntity.getProxyUser();
        }
        return proxyUserEntity.getUsername();
    }

    public static String getToken(HttpServletRequest httpServletRequest) {
        String token = httpServletRequest.getHeader(TOKEN_KEY);
        if (StringUtils.isBlank((CharSequence)token)) {
            LOGGER.info("Cannot get token from this http request!");
        }
        return token;
    }

    public static String getTokenUser(HttpServletRequest httpServletRequest) {
        String tokenUser = httpServletRequest.getHeader(TOKEN_USER_KEY);
        if (StringUtils.isBlank((CharSequence)tokenUser)) {
            LOGGER.info("Cannot get token user from this http request!");
        }
        return tokenUser;
    }

    public static void printAuditLog(String auditLogMsg) {
        LOGGER.info(auditLogMsg);
    }
}

