/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.server.ticket;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.server.ticket.RedisClient$;
import org.slf4j.Logger;
import redis.clients.jedis.Jedis;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r4Aa\u0003\u0007\u0001/!)1\b\u0001C\u0001y!9q\b\u0001b\u0001\n\u0013\u0001\u0005BB!\u0001A\u0003%!\u0005C\u0003C\u0001\u0011\u00051\tC\u0003H\u0001\u0011\u0005\u0001\nC\u0003J\u0001\u0011\u0005#\nC\u0003P\u0001\u0011\u0005\u0003\u000bC\u0003Y\u0001\u0011\u0005\u0013\fC\u0003\\\u0001\u0011\u0005C\fC\u0003a\u0001\u0011\u0005\u0013MA\tVg\u0016\u0014H+[2lKR\u001cVM\u001d<jG\u0016T!!\u0004\b\u0002\rQL7m[3u\u0015\ty\u0001#\u0001\u0004tKJ4XM\u001d\u0006\u0003#I\ta\u0001\\5oW&\u001c(BA\n\u0015\u0003\u0019\t\u0007/Y2iK*\tQ#A\u0002pe\u001e\u001c\u0001aE\u0002\u00011M\u0002B!\u0007\u0011#_5\t!D\u0003\u0002\u001c9\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005uq\u0012\u0001B;uS2T\u0011aH\u0001\u0005U\u00064\u0018-\u0003\u0002\"5\t\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\u0005\rbcB\u0001\u0013+!\t)\u0003&D\u0001'\u0015\t9c#\u0001\u0004=e>|GO\u0010\u0006\u0002S\u0005)1oY1mC&\u00111\u0006K\u0001\u0007!J,G-\u001a4\n\u00055r#AB*ue&twM\u0003\u0002,QA\u0011\u0001'M\u0007\u0002Q%\u0011!\u0007\u000b\u0002\u0005\u0019>tw\r\u0005\u00025s5\tQG\u0003\u00027o\u0005)Q\u000f^5mg*\u0011\u0001\bE\u0001\u0007G>lWn\u001c8\n\u0005i*$a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0002\"A\u0010\u0001\u000e\u00031\t!#^:feRK7m[3u%\u0016$\u0017n]&fsV\t!%A\nvg\u0016\u0014H+[2lKR\u0014V\rZ5t\u0017\u0016L\b%A\u0004bgN\u001b\u0017\r\\1\u0016\u0003\u0011\u0003BaI##_%\u0011aI\f\u0002\u0004\u001b\u0006\u0004\u0018AB4fi\u0006cG.F\u0001\u0019\u0003\r\u0001X\u000f\u001e\u000b\u0004_-k\u0005\"\u0002'\u0007\u0001\u0004\u0011\u0013aA6fs\")aJ\u0002a\u0001_\u0005)a/\u00197vK\u0006Y1m\u001c8uC&t7oS3z)\t\tF\u000b\u0005\u00021%&\u00111\u000b\u000b\u0002\b\u0005>|G.Z1o\u0011\u0015au\u00011\u0001V!\t\u0001d+\u0003\u0002XQ\t\u0019\u0011I\\=\u0002\u0007\u001d,G\u000f\u0006\u000205\")A\n\u0003a\u0001+\u0006aq-\u001a;Pe\u0012+g-Y;miR\u0019q&\u00180\t\u000b1K\u0001\u0019A+\t\u000b}K\u0001\u0019A\u0018\u0002\u0019\u0011,g-Y;miZ\u000bG.^3\u0002\rI,Wn\u001c<f)\ty#\rC\u0003M\u0015\u0001\u0007Q\u000b")
public class UserTicketService
extends ConcurrentHashMap<String, Object>
implements Logging {
    private final String userTicketRedisKey;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        UserTicketService userTicketService = this;
        synchronized (userTicketService) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private String userTicketRedisKey() {
        return this.userTicketRedisKey;
    }

    public scala.collection.immutable.Map<String, Object> asScala() {
        return (scala.collection.immutable.Map)this.getAll();
    }

    public ConcurrentHashMap<String, Object> getAll() {
        ConcurrentHashMap<String, Object> result = new ConcurrentHashMap<String, Object>();
        Jedis resource = RedisClient$.MODULE$.getResource();
        Map ticketMap = resource.hgetAll(this.userTicketRedisKey());
        RedisClient$.MODULE$.closeResource(resource);
        ((Set)ticketMap.keySet()).foreach((Function1 & java.io.Serializable & Serializable)k -> BoxesRunTime.boxToLong((long)UserTicketService.$anonfun$getAll$1(result, ticketMap, k)));
        return result;
    }

    @Override
    public long put(String key, long value) {
        Jedis resource = RedisClient$.MODULE$.getResource();
        resource.hset(this.userTicketRedisKey(), key, Long.toString(value));
        RedisClient$.MODULE$.closeResource(resource);
        return value;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key.toString()) != 0L;
    }

    @Override
    public long get(Object key) {
        this.logger().info(new StringBuilder(15).append("get login user ").append(key).toString());
        Jedis resource = RedisClient$.MODULE$.getResource();
        String lastAccess = resource.hget(this.userTicketRedisKey(), key.toString());
        RedisClient$.MODULE$.closeResource(resource);
        if (lastAccess == null) {
            return 0L;
        }
        return new StringOps(Predef$.MODULE$.augmentString(lastAccess)).toLong();
    }

    @Override
    public long getOrDefault(Object key, long defaultValue) {
        long lastAccess = this.get(key.toString());
        if (lastAccess > 0L) {
            return lastAccess;
        }
        return defaultValue;
    }

    @Override
    public long remove(Object key) {
        Jedis resource = RedisClient$.MODULE$.getResource();
        Long value = resource.hdel(this.userTicketRedisKey(), new String[]{key.toString()});
        RedisClient$.MODULE$.closeResource(resource);
        return Predef$.MODULE$.Long2long(value);
    }

    public static final /* synthetic */ long $anonfun$getAll$1(ConcurrentHashMap result$1, Map ticketMap$1, String k) {
        return BoxesRunTime.unboxToLong((Object)result$1.put(k, BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString((String)ticketMap$1.get(k))).toLong())));
    }

    public UserTicketService() {
        Logging.$init$((Logging)this);
        this.userTicketRedisKey = "user_ticket_redis_key";
    }
}

