/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.hadoop.common.conf.HadoopConf;
import org.apache.linkis.hadoop.common.utils.HDFSUtils;
import org.apache.linkis.metadata.hive.config.DataSource;
import org.apache.linkis.metadata.hive.dao.HiveMetaDao;
import org.apache.linkis.metadata.hive.dto.MetadataQueryParam;
import org.apache.linkis.metadata.service.DataSourceService;
import org.apache.linkis.metadata.service.HiveMetaWithPermissionService;
import org.apache.linkis.metadata.util.DWSConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataSourceServiceImpl
implements DataSourceService {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceServiceImpl.class);
    private static FileSystem rootHdfs = null;
    @Autowired
    HiveMetaDao hiveMetaDao;
    @Autowired
    HiveMetaWithPermissionService hiveMetaWithPermissionService;
    ObjectMapper jsonMapper = new ObjectMapper();
    private static String dbKeyword = (String)DWSConfig.DB_FILTER_KEYWORDS.getValue();

    @Override
    @DataSource(name="firstDataSource")
    public JsonNode getDbs(String userName) throws Exception {
        List<String> dbs = this.hiveMetaWithPermissionService.getDbsOptionalUserName(userName);
        ArrayNode dbsNode = this.jsonMapper.createArrayNode();
        for (String db : dbs) {
            ObjectNode dbNode = this.jsonMapper.createObjectNode();
            dbNode.put("dbName", db);
            dbsNode.add((JsonNode)dbNode);
        }
        return dbsNode;
    }

    @Override
    @DataSource(name="firstDataSource")
    public JsonNode getDbsWithTables(String userName) {
        ArrayNode dbNodes = this.jsonMapper.createArrayNode();
        List<String> dbs = this.hiveMetaWithPermissionService.getDbsOptionalUserName(userName);
        MetadataQueryParam queryParam = MetadataQueryParam.of(userName);
        for (String db : dbs) {
            if (StringUtils.isBlank((CharSequence)db) || db.contains(dbKeyword)) {
                logger.info("db  will be filter: " + db);
                continue;
            }
            queryParam.setDbName(db);
            ObjectNode dbNode = this.jsonMapper.createObjectNode();
            dbNode.put("databaseName", db);
            dbNode.put("tables", this.queryTables(queryParam));
            dbNodes.add((JsonNode)dbNode);
        }
        return dbNodes;
    }

    @Override
    @DataSource(name="firstDataSource")
    public JsonNode queryTables(MetadataQueryParam queryParam) {
        List<Map<String, Object>> listTables;
        try {
            listTables = this.hiveMetaWithPermissionService.getTablesByDbNameAndOptionalUserName(queryParam);
        }
        catch (Throwable e) {
            logger.error("Failed to list Tables:", e);
            throw new RuntimeException(e);
        }
        ArrayNode tables = this.jsonMapper.createArrayNode();
        for (Map<String, Object> table : listTables) {
            ObjectNode tableNode = this.jsonMapper.createObjectNode();
            tableNode.put("tableName", (String)table.get("NAME"));
            tableNode.put("isView", table.get("TYPE").equals("VIRTUAL_VIEW"));
            tableNode.put("databaseName", queryParam.getDbName());
            tableNode.put("createdBy", (String)table.get("OWNER"));
            tableNode.put("createdAt", (Integer)table.get("CREATE_TIME"));
            tableNode.put("lastAccessAt", (Integer)table.get("LAST_ACCESS_TIME"));
            tables.add((JsonNode)tableNode);
        }
        return tables;
    }

    @Override
    @DataSource(name="firstDataSource")
    public JsonNode queryTableMeta(MetadataQueryParam queryParam) {
        logger.info("getTable:" + queryParam.getTableName());
        List<Map<String, Object>> columns = this.hiveMetaDao.getColumns(queryParam);
        List<Map<String, Object>> partitionKeys = this.hiveMetaDao.getPartitionKeys(queryParam);
        return this.getJsonNodesFromColumnMap(columns, partitionKeys);
    }

    private ArrayNode getJsonNodesFromColumnMap(List<Map<String, Object>> columns, List<Map<String, Object>> partitionKeys) {
        ObjectNode fieldNode;
        ArrayNode columnsNode = this.jsonMapper.createArrayNode();
        for (Map<String, Object> column : columns) {
            fieldNode = this.jsonMapper.createObjectNode();
            fieldNode.put("columnName", (String)column.get("COLUMN_NAME"));
            fieldNode.put("columnType", (String)column.get("TYPE_NAME"));
            fieldNode.put("columnComment", (String)column.get("COMMENT"));
            fieldNode.put("partitioned", false);
            columnsNode.add((JsonNode)fieldNode);
        }
        for (Map<String, Object> partitionKey : partitionKeys) {
            fieldNode = this.jsonMapper.createObjectNode();
            fieldNode.put("columnName", (String)partitionKey.get("PKEY_NAME"));
            fieldNode.put("columnType", (String)partitionKey.get("PKEY_TYPE"));
            fieldNode.put("columnComment", (String)partitionKey.get("PKEY_COMMENT"));
            fieldNode.put("partitioned", true);
            columnsNode.add((JsonNode)fieldNode);
        }
        return columnsNode;
    }

    @Override
    @DataSource(name="firstDataSource")
    public JsonNode queryTableMetaBySDID(MetadataQueryParam queryParam) {
        logger.info("getTableMetabysdid : sdid = {}", (Object)queryParam.getSdId());
        List<Map<String, Object>> columns = this.hiveMetaDao.getColumnsByStorageDescriptionID(queryParam);
        List<Map<String, Object>> partitionKeys = this.hiveMetaDao.getPartitionKeys(queryParam);
        return this.getJsonNodesFromColumnMap(columns, partitionKeys);
    }

    @DataSource(name="firstDataSource")
    public String getTableLocation(MetadataQueryParam queryParam) {
        String tableLocation = this.hiveMetaDao.getLocationByDbAndTable(queryParam);
        logger.info("tableLocation:" + tableLocation);
        return tableLocation;
    }

    @Override
    public JsonNode getTableSize(MetadataQueryParam queryParam) {
        logger.info("getTable:" + queryParam.getTableName());
        String tableSize = "";
        try {
            FileStatus tableFile = this.getFileStatus(this.getTableLocation(queryParam));
            tableSize = tableFile.isDirectory() ? ByteTimeUtils.bytesToString((long)this.getRootHdfs().getContentSummary(tableFile.getPath()).getLength()) : ByteTimeUtils.bytesToString((long)tableFile.getLen());
        }
        catch (IOException e) {
            logger.error("getTableSize error:", (Throwable)e);
        }
        ObjectNode sizeJson = this.jsonMapper.createObjectNode();
        sizeJson.put("size", tableSize);
        sizeJson.put("tableName", queryParam.getDbName() + "." + queryParam.getTableName());
        return sizeJson;
    }

    @Override
    @DataSource(name="firstDataSource")
    public JsonNode getPartitionSize(MetadataQueryParam queryParam) {
        Long partitionSize = this.hiveMetaDao.getPartitionSize(queryParam);
        if (partitionSize == null) {
            partitionSize = 0L;
        }
        ObjectNode sizeJson = this.jsonMapper.createObjectNode();
        sizeJson.put("size", ByteTimeUtils.bytesToString((long)partitionSize));
        sizeJson.put("tableName", queryParam.getDbName() + "." + queryParam.getTableName());
        sizeJson.put("partitionName", queryParam.getPartitionName());
        return sizeJson;
    }

    @Override
    @DataSource(name="firstDataSource")
    public JsonNode getPartitions(MetadataQueryParam queryParam) {
        List<String> partitions = this.hiveMetaDao.getPartitions(queryParam);
        Collections.sort(partitions);
        Collections.reverse(partitions);
        ObjectNode partitionJson = this.jsonMapper.createObjectNode();
        partitionJson.put("tableName", queryParam.getDbName() + "." + queryParam.getTableName());
        if (CollectionUtils.isEmpty(partitions)) {
            partitionJson.put("isPartition", false);
        } else {
            partitionJson.put("isPartition", true);
            partitionJson.put("partitions", (JsonNode)this.jsonMapper.createArrayNode());
            int depth = StringUtils.countMatches((CharSequence)partitions.get(0), (CharSequence)"/");
            HashMap nameToNode = Maps.newHashMap();
            for (String partition : partitions) {
                String[] lables = StringUtils.split((String)partition, (String)"/");
                for (int i = 0; i <= depth; ++i) {
                    if (i == 0) {
                        if (nameToNode.containsKey(lables[i])) continue;
                        ObjectNode childJson = this.jsonMapper.createObjectNode();
                        childJson.put("label", lables[i]);
                        childJson.put("path", lables[i]);
                        childJson.put("children", (JsonNode)this.jsonMapper.createArrayNode());
                        nameToNode.put(lables[i], childJson);
                        ((ArrayNode)partitionJson.get("partitions")).add((JsonNode)childJson);
                        continue;
                    }
                    String parentPath = StringUtils.join((Object[])Arrays.copyOfRange(lables, 0, i), (String)"/");
                    String currentPath = StringUtils.join((Object[])Arrays.copyOfRange(lables, 0, i + 1), (String)"/");
                    if (nameToNode.containsKey(currentPath)) continue;
                    ObjectNode childJson = this.jsonMapper.createObjectNode();
                    childJson.put("label", lables[i]);
                    childJson.put("path", currentPath);
                    childJson.put("children", (JsonNode)this.jsonMapper.createArrayNode());
                    nameToNode.put(currentPath, childJson);
                    ((ArrayNode)((JsonNode)nameToNode.get(parentPath)).get("children")).add((JsonNode)childJson);
                }
            }
        }
        return partitionJson;
    }

    @Override
    @DataSource(name="firstDataSource")
    public boolean partitionExists(MetadataQueryParam queryParam) {
        List<String> partitions = this.hiveMetaDao.getPartitions(queryParam);
        boolean res = Boolean.FALSE;
        if (CollectionUtils.isNotEmpty(partitions) && partitions.contains(queryParam.getPartitionName())) {
            res = Boolean.TRUE;
        }
        return res;
    }

    private FileStatus getFileStatus(String location) throws IOException {
        try {
            return this.getRootHdfs().getFileStatus(new Path(location));
        }
        catch (IOException e) {
            String message = e.getMessage();
            String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
            if (message != null && message.matches(DWSConfig.HDFS_FILE_SYSTEM_REST_ERRS) || rootCauseMessage != null && rootCauseMessage.matches(DWSConfig.HDFS_FILE_SYSTEM_REST_ERRS)) {
                logger.info("Failed to getFileStatus, retry", (Throwable)e);
                this.resetRootHdfs();
                return this.getFileStatus(location);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetRootHdfs() {
        if (HadoopConf.HDFS_ENABLE_CACHE()) {
            HDFSUtils.closeHDFSFIleSystem((FileSystem)HDFSUtils.getHDFSRootUserFileSystem(), (String)((String)HadoopConf.HADOOP_ROOT_USER().getValue()), (boolean)true);
            return;
        }
        if (rootHdfs != null) {
            DataSourceServiceImpl dataSourceServiceImpl = this;
            synchronized (dataSourceServiceImpl) {
                if (rootHdfs != null) {
                    IOUtils.closeQuietly((Closeable)rootHdfs);
                    logger.info("reset RootHdfs");
                    rootHdfs = HDFSUtils.getHDFSRootUserFileSystem();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileSystem getRootHdfs() {
        if (HadoopConf.HDFS_ENABLE_CACHE()) {
            return HDFSUtils.getHDFSRootUserFileSystem();
        }
        if (rootHdfs == null) {
            DataSourceServiceImpl dataSourceServiceImpl = this;
            synchronized (dataSourceServiceImpl) {
                if (rootHdfs == null) {
                    rootHdfs = HDFSUtils.getHDFSRootUserFileSystem();
                }
            }
        }
        return rootHdfs;
    }
}

