/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.receiver;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.metadata.ddl.DDLHelper$;
import org.apache.linkis.metadata.domain.mdq.bo.MdqTableBO;
import org.apache.linkis.metadata.service.MdqService;
import org.apache.linkis.metadata.utils.MdqUtils$;
import org.apache.linkis.protocol.mdq.DDLCompleteResponse;
import org.apache.linkis.protocol.mdq.DDLExecuteResponse;
import org.apache.linkis.protocol.mdq.DDLRequest;
import org.apache.linkis.protocol.mdq.DDLResponse;
import org.apache.linkis.rpc.message.annotation.Receiver;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0001}4A!\u0003\u0006\u0001+!)A\u0005\u0001C\u0001K!I\u0001\u0006\u0001a\u0001\u0002\u0004%I!\u000b\u0005\na\u0001\u0001\r\u00111A\u0005\nEB\u0011b\u000e\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u0016\t\u000f\u0015\u0003!\u0019!C\u0005\r\"11\u000b\u0001Q\u0001\n\u001dCQ\u0001\u0016\u0001\u0005\u0002UCQ!\u001c\u0001\u0005\u00029\u00141\"\u0014#R%\u0016\u001cW-\u001b<fe*\u00111\u0002D\u0001\te\u0016\u001cW-\u001b<fe*\u0011QBD\u0001\t[\u0016$\u0018\rZ1uC*\u0011q\u0002E\u0001\u0007Y&t7.[:\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0003\b\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005u\u0011S\"\u0001\u0010\u000b\u0005}\u0001\u0013!B;uS2\u001c(BA\u0011\u000f\u0003\u0019\u0019w.\\7p]&\u00111E\b\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\ta\u0005\u0005\u0002(\u00015\t!\"\u0001\u0006nIF\u001cVM\u001d<jG\u0016,\u0012A\u000b\t\u0003W9j\u0011\u0001\f\u0006\u0003[1\tqa]3sm&\u001cW-\u0003\u00020Y\tQQ\nZ9TKJ4\u0018nY3\u0002\u001d5$\u0017oU3sm&\u001cWm\u0018\u0013fcR\u0011!'\u000e\t\u0003/MJ!\u0001\u000e\r\u0003\tUs\u0017\u000e\u001e\u0005\bm\r\t\t\u00111\u0001+\u0003\rAH%M\u0001\f[\u0012\f8+\u001a:wS\u000e,\u0007\u0005\u000b\u0002\u0005sA\u0011!hQ\u0007\u0002w)\u0011A(P\u0001\u000bC:tw\u000e^1uS>t'B\u0001 @\u0003\u001d1\u0017m\u0019;pefT!\u0001Q!\u0002\u000b\t,\u0017M\\:\u000b\u0005\t\u0013\u0012aD:qe&twM\u001a:b[\u0016<xN]6\n\u0005\u0011[$!C!vi><\u0018N]3e\u0003\u0019i\u0017\r\u001d9feV\tq\t\u0005\u0002I#6\t\u0011J\u0003\u0002K\u0017\u0006AA-\u0019;bE&tGM\u0003\u0002M\u001b\u00069!.Y2lg>t'B\u0001(P\u0003%1\u0017m\u001d;feblGNC\u0001Q\u0003\r\u0019w.\\\u0005\u0003%&\u0013Ab\u00142kK\u000e$X*\u00199qKJ\fq!\\1qa\u0016\u0014\b%\u0001\beK\u0006dG\t\u0012'SKF,Xm\u001d;\u0015\u0005Ys\u0006CA,]\u001b\u0005A&BA-[\u0003\riG-\u001d\u0006\u00037:\t\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0003;b\u00131\u0002\u0012#M%\u0016\u001c\bo\u001c8tK\")ql\u0002a\u0001A\u0006QA\r\u001a7SKF,Xm\u001d;\u0011\u0005]\u000b\u0017B\u00012Y\u0005)!E\t\u0014*fcV,7\u000f\u001e\u0015\u0003\u000f\u0011\u0004\"!Z6\u000e\u0003\u0019T!\u0001P4\u000b\u0005!L\u0017aB7fgN\fw-\u001a\u0006\u0003U:\t1A\u001d9d\u0013\tagM\u0001\u0005SK\u000e,\u0017N^3s\u0003Y!W-\u00197E\t2+\u00050Z2vi\u0016\u0014Vm\u001d9p]N,GCA8s!\t9\u0006/\u0003\u0002r1\n\u0019B\t\u0012'D_6\u0004H.\u001a;f%\u0016\u001c\bo\u001c8tK\")1\u000f\u0003a\u0001i\u0006\u0011B\r\u001a7Fq\u0016\u001cW\u000f^3SKN\u0004xN\\:f!\t9V/\u0003\u0002w1\n\u0011B\t\u0012'Fq\u0016\u001cW\u000f^3SKN\u0004xN\\:fQ\tAA\r\u000b\u0002\u0001sB\u0011!0`\u0007\u0002w*\u0011A0Q\u0001\u000bgR,'/Z8usB,\u0017B\u0001@|\u0005%\u0019u.\u001c9p]\u0016tG\u000f")
public class MDQReceiver
implements Logging {
    @Autowired
    private MdqService mdqService;
    private final ObjectMapper mapper;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        MDQReceiver mDQReceiver = this;
        synchronized (mDQReceiver) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private MdqService mdqService() {
        return this.mdqService;
    }

    private void mdqService_$eq(MdqService x$1) {
        this.mdqService = x$1;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    @Receiver
    public DDLResponse dealDDLRequest(DDLRequest ddlRequest) {
        this.logger().info("received a request from sparkEngine");
        String ddlCode = DDLHelper$.MODULE$.createDDL(ddlRequest.params());
        return new DDLResponse(ddlCode);
    }

    @Receiver
    public DDLCompleteResponse dealDDLExecuteResponse(DDLExecuteResponse ddlExecuteResponse) {
        if (!ddlExecuteResponse.status()) {
            this.logger().warn(new StringBuilder(15).append(MdqUtils$.MODULE$.ruleString(ddlExecuteResponse.code())).append(" execute failed").toString());
            return new DDLCompleteResponse(false);
        }
        return (DDLCompleteResponse)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> {
            JsonNode jsonNode = this.mapper().readTree(ddlExecuteResponse.code());
            MdqTableBO mdqTableBO = (MdqTableBO)this.mapper().treeToValue((TreeNode)jsonNode, MdqTableBO.class);
            String tableName = mdqTableBO.getTableBaseInfo().getBase().getName();
            String dbName = mdqTableBO.getTableBaseInfo().getBase().getDatabase();
            this.logger().info(new StringBuilder(24).append("begin to persist table ").append(dbName).append(" ").append(tableName).toString());
            this.mdqService().persistTable(mdqTableBO, ddlExecuteResponse.user());
            this.logger().info(new StringBuilder(22).append("end to persist table ").append(dbName).append(" ").append(tableName).toString());
            return new DDLCompleteResponse(true);
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof Exception) {
                Exception exception = (Exception)throwable;
                this.logger().error(new StringBuilder(31).append("fail to persist table for user ").append(ddlExecuteResponse.user()).toString(), (Throwable)exception);
                return new DDLCompleteResponse(false);
            }
            if (throwable != null) {
                Throwable throwable2 = throwable;
                this.logger().error(new StringBuilder(31).append("fail to persist table for user ").append(ddlExecuteResponse.user()).toString(), throwable2);
                return new DDLCompleteResponse(false);
            }
            throw new MatchError((Object)throwable);
        });
    }

    public MDQReceiver() {
        Logging.$init$((Logging)this);
        this.mapper = new ObjectMapper();
    }
}

