/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.label.builder.factory;

import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.linkis.manager.label.builder.DefaultGlobalLabelBuilder;
import org.apache.linkis.manager.label.builder.ExtensibleLabelBuilder;
import org.apache.linkis.manager.label.builder.GenericLabelBuilder;
import org.apache.linkis.manager.label.builder.LabelBuilder;
import org.apache.linkis.manager.label.builder.LabelBuilderAdapter;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactory;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.exception.LabelErrorException;
import org.apache.linkis.manager.label.exception.LabelRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StdLabelBuilderFactory
implements LabelBuilderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(StdLabelBuilderFactory.class);
    private final LinkedList<ExtensibleLabelBuilder> labelBuilders = new LinkedList();
    private boolean isSorted;

    public StdLabelBuilderFactory() {
        this.registerInnerLabelBuilder(new GenericLabelBuilder());
        this.registerInnerLabelBuilder(new DefaultGlobalLabelBuilder());
    }

    @Override
    public void registerLabelBuilder(LabelBuilder labelBuilder) {
        this.registerInnerLabelBuilder(new LabelBuilderAdapter(labelBuilder));
    }

    @Override
    public <T extends Label<?>> T createLabel(String inLabelKey, Object inValueObj, Class<?> outLabelClass, Type ... outValueTypes) {
        return (T)this.processToBuild(inLabelKey, outLabelClass, builder -> builder.build(inLabelKey, inValueObj, outLabelClass, outValueTypes));
    }

    @Override
    public <T extends Label<?>> T createLabel(String inLabelKey) {
        return this.createLabel(inLabelKey, (Object)null, null, new Type[]{null});
    }

    @Override
    public <T extends Label<?>> T createLabel(Class<T> outLabelClass) {
        return this.createLabel(null, (Object)null, (Class<?>)outLabelClass, new Type[]{null});
    }

    @Override
    public <T extends Label<?>> T createLabel(Class<?> outLabelClass, Type ... outValueTypes) {
        return this.createLabel(null, (Object)null, outLabelClass, outValueTypes);
    }

    @Override
    public <T extends Label<?>> T createLabel(String inLabelKey, Object inValueObj) {
        return this.createLabel(inLabelKey, inValueObj, null, new Type[]{null});
    }

    @Override
    public <T extends Label<?>> T createLabel(String inLabelKey, Object inValueObj, Class<T> outLabelClass) {
        return this.createLabel(inLabelKey, inValueObj, outLabelClass, new Type[]{null});
    }

    @Override
    public <T extends Label<?>> T createLabel(String inLabelKey, InputStream inValueStream, Class<?> outLabelClass, Type ... outValueTypes) {
        return (T)this.processToBuild(inLabelKey, outLabelClass, builder -> builder.build(inLabelKey, inValueStream, outLabelClass, outValueTypes));
    }

    @Override
    public <T extends Label<?>> T createLabel(String inLabelKey, InputStream inValueStream, Class<T> outLabelClass) {
        return this.createLabel(inLabelKey, inValueStream, outLabelClass, new Type[]{null});
    }

    @Override
    public <T extends Label<?>> T createLabel(String inLabelKey, InputStream inValueStream) {
        return this.createLabel(inLabelKey, inValueStream, null, new Type[]{null});
    }

    @Override
    public <T extends Label<?>> List<T> getLabels(Map<String, Object> inMap, Class<?> outLabelClass, Type ... outValueTypes) {
        return inMap.entrySet().stream().map(entry -> this.createLabel((String)entry.getKey(), entry.getValue(), outLabelClass, outValueTypes)).collect(Collectors.toList());
    }

    @Override
    public <T extends Label<?>> List<T> getLabels(Map<String, Object> inMap, Class<T> outLabelClass) {
        return this.getLabels(inMap, outLabelClass, new Type[]{null});
    }

    @Override
    public <T extends Label<?>> List<T> getLabels(Map<String, Object> inMap) {
        return this.getLabels(inMap, null, new Type[]{null});
    }

    @Override
    public <T extends Label<?>> T convertLabel(Label<?> sourceLabel, Class<?> targetLabelClass, Type ... targetValueTypes) {
        String labelKey = sourceLabel.getLabelKey();
        Object sourceValue = sourceLabel.getValue();
        return this.createLabel(labelKey, sourceValue, targetLabelClass, targetValueTypes);
    }

    @Override
    public <T extends Label<?>> T convertLabel(Label<?> sourceLabel, Class<T> targetLabelClass) {
        return this.convertLabel(sourceLabel, targetLabelClass, new Type[]{null});
    }

    private synchronized void registerInnerLabelBuilder(ExtensibleLabelBuilder labelBuilder) {
        this.labelBuilders.addFirst(labelBuilder);
        this.isSorted = false;
    }

    private synchronized void sortLabelBuilders() {
        if (!this.isSorted) {
            this.labelBuilders.sort((left, right) -> {
                int compare = left.getOrder() - right.getOrder();
                if (compare == 0) {
                    if (left.getClass().equals(DefaultGlobalLabelBuilder.class)) {
                        return 1;
                    }
                    if (right.getClass().equals(DefaultGlobalLabelBuilder.class)) {
                        return -1;
                    }
                }
                return compare;
            });
            this.isSorted = true;
        }
    }

    private <R> R processToBuild(String labelKey, Class<?> labelClass, LabelBuildFunction<R> buildFunc) {
        if (!this.isSorted) {
            this.sortLabelBuilders();
        }
        R functionOutput = null;
        for (ExtensibleLabelBuilder builder : this.labelBuilders) {
            if (!builder.canBuild(labelKey, labelClass)) continue;
            try {
                functionOutput = buildFunc.apply(builder);
                if (null == functionOutput) continue;
                break;
            }
            catch (LabelErrorException error) {
                LOG.error("Error Exception in using label builder: [" + builder.getClass().getSimpleName() + "]", (Throwable)((Object)error));
                throw new LabelRuntimeException(error.getErrCode(), "Fail to build label, message:[" + error.getLocalizedMessage() + "]");
            }
        }
        return functionOutput;
    }

    @FunctionalInterface
    public static interface LabelBuildFunction<R> {
        public R apply(ExtensibleLabelBuilder var1) throws LabelErrorException;
    }
}

