/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.ujes.jdbc;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.httpclient.authentication.AuthenticationStrategy;
import org.apache.linkis.httpclient.dws.authentication.StaticAuthenticationStrategy;
import org.apache.linkis.httpclient.dws.config.DWSClientConfigBuilder;
import org.apache.linkis.httpclient.dws.config.DWSClientConfigBuilder$;
import org.apache.linkis.ujes.client.UJESClient;
import org.apache.linkis.ujes.client.UJESClient$;
import org.apache.linkis.ujes.jdbc.UJESSQLDriverMain$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;

public final class UJESClientFactory$
implements Logging {
    public static UJESClientFactory$ MODULE$;
    private final HashMap<String, UJESClient> ujesClients;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new UJESClientFactory$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        UJESClientFactory$ uJESClientFactory$ = this;
        synchronized (uJESClientFactory$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private HashMap<String, UJESClient> ujesClients() {
        return this.ujesClients;
    }

    public UJESClient getUJESClient(Properties props) {
        UJESClient uJESClient;
        block6: {
            String host = props.getProperty(UJESSQLDriverMain$.MODULE$.HOST());
            String port = props.getProperty(UJESSQLDriverMain$.MODULE$.PORT());
            String user = props.getProperty(UJESSQLDriverMain$.MODULE$.USER());
            String pwd = props.getProperty(UJESSQLDriverMain$.MODULE$.PASSWORD());
            boolean sslEnabled = props.containsKey(UJESSQLDriverMain$.MODULE$.USE_SSL()) && "true".equalsIgnoreCase(props.getProperty(UJESSQLDriverMain$.MODULE$.USE_SSL()));
            String prefix = sslEnabled ? "https" : "http";
            String serverUrl = StringUtils.isNotBlank((CharSequence)port) ? new StringBuilder(4).append(prefix).append("://").append(host).append(":").append(port).toString() : new StringBuilder(10).append("$prefix://").append(host).toString();
            String uniqueKey = new StringBuilder(2).append(serverUrl).append("_").append(user).append("_").append(pwd).toString();
            String uniqueKeyDes = Hex.encodeHexString((byte[])uniqueKey.getBytes(StandardCharsets.UTF_8));
            if (this.ujesClients().containsKey(uniqueKeyDes)) {
                this.logger().info("Clients with the same JDBC unique key({}) will get it directly", new Object[]{serverUrl});
                return this.ujesClients().get(uniqueKeyDes);
            }
            String string = uniqueKeyDes.intern();
            synchronized (string) {
                UJESClient uJESClient2;
                block5: {
                    if (this.ujesClients().containsKey(uniqueKeyDes)) {
                        this.logger().info("Clients with the same JDBC unique key({}) will get it directly", new Object[]{serverUrl});
                        uJESClient2 = this.ujesClients().get(uniqueKeyDes);
                        break block5;
                    }
                    this.logger().info("The same Client does not exist for the JDBC unique key({}), a new Client will be created", new Object[]{serverUrl});
                    UJESClient ujesClient = this.createUJESClient(serverUrl, props, sslEnabled);
                    this.ujesClients().put(uniqueKeyDes, ujesClient);
                    uJESClient = ujesClient;
                    break block6;
                }
                return uJESClient2;
            }
        }
        return uJESClient;
    }

    private UJESClient createUJESClient(String serverUrl, Properties props, boolean sslEnabled) {
        DWSClientConfigBuilder clientConfigBuilder = DWSClientConfigBuilder$.MODULE$.newBuilder();
        clientConfigBuilder.addServerUrl(serverUrl);
        clientConfigBuilder.setAuthTokenKey(props.getProperty(UJESSQLDriverMain$.MODULE$.USER()));
        clientConfigBuilder.setAuthTokenValue(props.getProperty(UJESSQLDriverMain$.MODULE$.PASSWORD()));
        clientConfigBuilder.setAuthenticationStrategy((AuthenticationStrategy)new StaticAuthenticationStrategy());
        clientConfigBuilder.readTimeout(100000L);
        clientConfigBuilder.maxConnectionSize(20);
        String params = props.getProperty(UJESSQLDriverMain$.MODULE$.PARAMS());
        BooleanRef versioned = BooleanRef.create((boolean)false);
        if (StringUtils.isNotBlank((CharSequence)params)) {
            BooleanRef enableDiscovery = BooleanRef.create((boolean)false);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])params.split(UJESSQLDriverMain$.MODULE$.PARAM_SPLIT()))).foreach((Function1 & Serializable & scala.Serializable)kv -> {
                Option option;
                Option option2;
                Option option3;
                Option option4;
                String[] stringArray = kv.split(UJESSQLDriverMain$.MODULE$.KV_SPLIT());
                Option option5 = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (!option5.isEmpty() && option5.get() != null && ((SeqLike)option5.get()).lengthCompare(2) == 0) {
                    String string = (String)((SeqLike)option5.get()).apply(0);
                    String v = (String)((SeqLike)option5.get()).apply(1);
                    String string2 = UJESSQLDriverMain$.MODULE$.VERSION();
                    String string3 = string;
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        clientConfigBuilder.setDWSVersion(v);
                        versioned$1.elem = true;
                        return BoxedUnit.UNIT;
                    }
                }
                if (!(option4 = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty() && option4.get() != null && ((SeqLike)option4.get()).lengthCompare(2) == 0) {
                    String string = (String)((SeqLike)option4.get()).apply(0);
                    String v = (String)((SeqLike)option4.get()).apply(1);
                    String string4 = UJESSQLDriverMain$.MODULE$.MAX_CONNECTION_SIZE();
                    String string5 = string;
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        return clientConfigBuilder.maxConnectionSize(new StringOps(Predef$.MODULE$.augmentString(v)).toInt());
                    }
                }
                if (!(option3 = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty() && option3.get() != null && ((SeqLike)option3.get()).lengthCompare(2) == 0) {
                    String string = (String)((SeqLike)option3.get()).apply(0);
                    String v = (String)((SeqLike)option3.get()).apply(1);
                    String string6 = UJESSQLDriverMain$.MODULE$.READ_TIMEOUT();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        return clientConfigBuilder.readTimeout(new StringOps(Predef$.MODULE$.augmentString(v)).toLong());
                    }
                }
                if (!(option2 = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(2) == 0) {
                    String string = (String)((SeqLike)option2.get()).apply(0);
                    String v = (String)((SeqLike)option2.get()).apply(1);
                    String string8 = UJESSQLDriverMain$.MODULE$.ENABLE_DISCOVERY();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        clientConfigBuilder.discoveryEnabled(new StringOps(Predef$.MODULE$.augmentString(v)).toBoolean());
                        enableDiscovery$1.elem = true;
                        return BoxedUnit.UNIT;
                    }
                }
                if (!(option = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                    String string = (String)((SeqLike)option.get()).apply(0);
                    String v = (String)((SeqLike)option.get()).apply(1);
                    String string10 = UJESSQLDriverMain$.MODULE$.ENABLE_LOADBALANCER();
                    String string11 = string;
                    if (!(string10 != null ? !string10.equals(string11) : string11 != null) && enableDiscovery$1.elem) {
                        return clientConfigBuilder.loadbalancerEnabled(new StringOps(Predef$.MODULE$.augmentString(v)).toBoolean());
                    }
                }
                return BoxedUnit.UNIT;
            });
        }
        Object object = !versioned.elem ? clientConfigBuilder.setDWSVersion(new StringBuilder(1).append("v").append(UJESSQLDriverMain$.MODULE$.DEFAULT_VERSION()).toString()) : BoxedUnit.UNIT;
        Object object2 = sslEnabled ? clientConfigBuilder.setSSL(sslEnabled) : BoxedUnit.UNIT;
        return UJESClient$.MODULE$.apply(clientConfigBuilder.build());
    }

    private UJESClientFactory$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.ujesClients = new HashMap();
    }
}

