/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.io.client;

import java.util.HashMap;
import java.util.Map;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.engine.EngineType$;
import org.apache.linkis.manager.label.entity.engine.EngineTypeLabel;
import org.apache.linkis.manager.label.entity.entrance.BindEngineLabel;
import org.apache.linkis.manager.label.entity.entrance.LoadBalanceLabel;
import org.apache.linkis.manager.label.utils.EngineTypeLabelCreator;
import org.apache.linkis.manager.label.utils.LabelUtil$;
import org.apache.linkis.orchestrator.Orchestration;
import org.apache.linkis.orchestrator.core.OrchestrationFuture;
import org.apache.linkis.orchestrator.core.OrchestrationResponse;
import org.apache.linkis.orchestrator.core.ResultSet;
import org.apache.linkis.orchestrator.domain.JobReq;
import org.apache.linkis.orchestrator.ecm.conf.ECMPluginConf$;
import org.apache.linkis.orchestrator.execution.ArrayResultSetTaskResponse;
import org.apache.linkis.orchestrator.execution.FailedTaskResponse;
import org.apache.linkis.orchestrator.execution.SucceedTaskResponse;
import org.apache.linkis.server.BDPJettyServerHelper$;
import org.apache.linkis.storage.domain.MethodEntity;
import org.apache.linkis.storage.exception.FSNotInitException;
import org.apache.linkis.storage.exception.StorageErrorCode;
import org.apache.linkis.storage.exception.StorageErrorException;
import org.apache.linkis.storage.io.client.IOClient;
import org.apache.linkis.storage.io.client.IOClient$class;
import org.apache.linkis.storage.io.conf.IOFileClientConf$;
import org.apache.linkis.storage.io.orchestrator.IOFileOrchestratorFactory$;
import org.apache.linkis.storage.io.utils.IOClientUtils$;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005\rc\u0001B\u0001\u0003\u0001=\u0011q\u0002R3gCVdG/S(DY&,g\u000e\u001e\u0006\u0003\u0007\u0011\taa\u00197jK:$(BA\u0003\u0007\u0003\tIwN\u0003\u0002\b\u0011\u000591\u000f^8sC\u001e,'BA\u0005\u000b\u0003\u0019a\u0017N\\6jg*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\t\u00175A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"a\u0006\r\u000e\u0003\tI!!\u0007\u0002\u0003\u0011%{5\t\\5f]R\u0004\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\u000bU$\u0018\u000e\\:\u000b\u0005}A\u0011AB2p[6|g.\u0003\u0002\"9\t9Aj\\4hS:<\u0007\"B\u0012\u0001\t\u0003!\u0013A\u0002\u001fj]&$h\bF\u0001&!\t9\u0002\u0001C\u0004(\u0001\t\u0007I\u0011\u0002\u0015\u0002!1|\u0017\r\u001a\"bY\u0006t7-\u001a'bE\u0016dW#A\u0015\u0011\u0005)\u001aT\"A\u0016\u000b\u00051j\u0013\u0001C3oiJ\fgnY3\u000b\u00059z\u0013AB3oi&$\u0018P\u0003\u00021c\u0005)A.\u00192fY*\u0011!\u0007C\u0001\b[\u0006t\u0017mZ3s\u0013\t!4F\u0001\tM_\u0006$')\u00197b]\u000e,G*\u00192fY\"1a\u0007\u0001Q\u0001\n%\n\u0011\u0003\\8bI\n\u000bG.\u00198dK2\u000b'-\u001a7!\u0011\u001dA\u0004A1A\u0005\ne\n1\"\u001a=ue\u0006d\u0015MY3mgV\t!\bE\u0002\u0012wuJ!\u0001\u0010\n\u0003\u000b\u0005\u0013(/Y=1\u0005y\"\u0005cA A\u00056\tQ&\u0003\u0002B[\t)A*\u00192fYB\u00111\t\u0012\u0007\u0001\t%)e)!A\u0001\u0002\u000b\u0005QJA\u0002`IEBaa\u0012\u0001!\u0002\u0013A\u0015\u0001D3yiJ\fG*\u00192fYN\u0004\u0003cA\t<\u0013B\u0012!\n\u0014\t\u0004\u007f\u0001[\u0005CA\"M\t%)e)!A\u0001\u0002\u000b\u0005Q*\u0005\u0002O#B\u0011\u0011cT\u0005\u0003!J\u0011qAT8uQ&tw\r\u0005\u0002\u0012%&\u00111K\u0005\u0002\u0004\u0003:L\b\"B+\u0001\t\u00032\u0016aB3yK\u000e,H/\u001a\u000b\u0005/z\u0003\u0007\u000e\u0005\u0002Y7:\u0011\u0011#W\u0005\u00035J\ta\u0001\u0015:fI\u00164\u0017B\u0001/^\u0005\u0019\u0019FO]5oO*\u0011!L\u0005\u0005\u0006?R\u0003\raV\u0001\u0005kN,'\u000fC\u0003b)\u0002\u0007!-\u0001\u0007nKRDw\u000eZ#oi&$\u0018\u0010\u0005\u0002dM6\tAM\u0003\u0002f\r\u00051Am\\7bS:L!a\u001a3\u0003\u00195+G\u000f[8e\u000b:$\u0018\u000e^=\t\u000b%$\u0006\u0019\u00016\u0002\u001f\tLg\u000eZ#oO&tW\rT1cK2\u0004\"AK6\n\u00051\\#a\u0004\"j]\u0012,enZ5oK2\u000b'-\u001a7\t\u000b9\u0004A\u0011A8\u0002\u001b\u0015DXmY;uKJ+7/\u001e7u)\u00159\u0006/\u001d:}\u0011\u0015yV\u000e1\u0001X\u0011\u0015\tW\u000e1\u0001c\u0011\u0015\u0019X\u000e1\u0001u\u0003\u0019\u0001\u0018M]1ngB!QO_,R\u001b\u00051(BA<y\u0003\u0011)H/\u001b7\u000b\u0003e\fAA[1wC&\u00111P\u001e\u0002\u0004\u001b\u0006\u0004\bbB?n!\u0003\u0005\rA`\u0001\u000be\u0016$(/\u001f'j[&$\bCA\t\u0000\u0013\r\t\tA\u0005\u0002\u0004\u0013:$\bbBA\u0003\u0001\u0011\u0005\u0013qA\u0001\u0011Kb,7-\u001e;f/&$\bNU3uef$\u0012bVA\u0005\u0003\u0017\ti!a\u0004\t\r}\u000b\u0019\u00011\u0001X\u0011\u0019\t\u00171\u0001a\u0001E\"1\u0011.a\u0001A\u0002)D\u0011\"!\u0005\u0002\u0004A\u0005\t\u0019\u0001@\u0002\u0015I,GK]=MS6LG\u000fC\u0005\u0002\u0016\u0001\t\n\u0011\"\u0001\u0002\u0018\u00059R\r_3dkR,'+Z:vYR$C-\u001a4bk2$H\u0005N\u000b\u0003\u00033Q3A`A\u000eW\t\ti\u0002\u0005\u0003\u0002 \u0005%RBAA\u0011\u0015\u0011\t\u0019#!\n\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0014%\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0012\u0011\u0005\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA\u0018\u0001E\u0005I\u0011IA\f\u0003i)\u00070Z2vi\u0016<\u0016\u000e\u001e5SKR\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135Q\r\u0001\u00111\u0007\t\u0005\u0003k\ty$\u0004\u0002\u00028)!\u0011\u0011HA\u001e\u0003)\u0019H/\u001a:f_RL\b/\u001a\u0006\u0004\u0003{a\u0011aD:qe&twM\u001a:b[\u0016<xN]6\n\t\u0005\u0005\u0013q\u0007\u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class DefaultIOClient
implements IOClient,
Logging {
    private final LoadBalanceLabel loadBalanceLabel;
    private final Label<?>[] extraLabels;
    private final Logger logger;
    private final int defaultRetry;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        DefaultIOClient defaultIOClient = this;
        synchronized (defaultIOClient) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<String> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.class.info((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.class.error((Logging)this, message);
    }

    @Override
    public int defaultRetry() {
        return this.defaultRetry;
    }

    @Override
    public void org$apache$linkis$storage$io$client$IOClient$_setter_$defaultRetry_$eq(int x$1) {
        this.defaultRetry = x$1;
    }

    private LoadBalanceLabel loadBalanceLabel() {
        return this.loadBalanceLabel;
    }

    private Label<?>[] extraLabels() {
        return this.extraLabels;
    }

    @Override
    public String execute(String user, MethodEntity methodEntity, BindEngineLabel bindEngineLabel) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (bindEngineLabel != null) {
            IOClientUtils$.MODULE$.addLabelToParams((Label<?>)bindEngineLabel, (Map<String, Object>)params);
        }
        return this.executeResult(user, methodEntity, params, this.executeResult$default$4());
    }

    /*
     * WARNING - void declaration
     */
    public String executeResult(String user, MethodEntity methodEntity, Map<String, Object> params, int retryLimit) {
        void var8_7;
        OrchestrationResponse response;
        OrchestrationResponse orchestrationResponse;
        EngineTypeLabel engineTypeLabel = EngineTypeLabelCreator.createEngineTypeLabel((String)EngineType$.MODULE$.mapFsTypeToEngineType(methodEntity.fsType()));
        IOClientUtils$.MODULE$.addLabelToParams((Label<?>)this.loadBalanceLabel(), params);
        IOClientUtils$.MODULE$.addLabelToParams((Label<?>)engineTypeLabel, params);
        Predef$.MODULE$.refArrayOps((Object[])this.extraLabels()).foreach((Function1)new Serializable(this, params){
            public static final long serialVersionUID = 0L;
            private final Map params$1;

            public final void apply(Label<?> label) {
                IOClientUtils$.MODULE$.addLabelToParams(label, this.params$1);
            }
            {
                this.params$1 = params$1;
            }
        });
        long startTime = System.currentTimeMillis();
        JobReq jobReq = IOClientUtils$.MODULE$.buildJobReq(user, methodEntity, params);
        if (jobReq == null) {
            throw new StorageErrorException(IOFileClientConf$.MODULE$.IO_EXECUTE_FAILED_CODE(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Job with id ", " failed to execute method fs for user : ", ", code : ", "\uff0c Because jobReq is null"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobReq.getId(), user, methodEntity})));
        }
        BindEngineLabel bindEngineLabel = LabelUtil$.MODULE$.getBindEngineLabel(jobReq.getLabels());
        if (bindEngineLabel == null) {
            throw new StorageErrorException(IOFileClientConf$.MODULE$.IO_EXECUTE_FAILED_CODE(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Job with id ", " failed to execute method fs for user : ", ", code : ", "\uff0c Because bindEngineLabel is null"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobReq.getId(), user, methodEntity})));
        }
        Orchestration orchestration = IOFileOrchestratorFactory$.MODULE$.getOrchestratorSession().orchestrate(jobReq);
        long orchestrationTime = System.currentTimeMillis();
        if (retryLimit > 0) {
            OrchestrationResponse response2 = orchestration.execute();
            int initCount = 0;
            while (!(response2 instanceof SucceedTaskResponse) && initCount < retryLimit) {
                this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"JobId ", " execute method ", " failed, to retry ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobReq.getId(), methodEntity, BoxesRunTime.boxToInteger((int)(++initCount))})));
                Orchestration reTryOrchestration = IOFileOrchestratorFactory$.MODULE$.getOrchestratorSession().orchestrate(jobReq);
                response2 = reTryOrchestration.execute();
            }
            orchestrationResponse = response2;
        } else {
            OrchestrationFuture future = orchestration.asyncExecute();
            future.waitForCompleted((long)(IOFileClientConf$.MODULE$.IO__JOB_WAIT_S() * 1000));
            orchestrationResponse = future.getResponse();
        }
        OrchestrationResponse orchestrationResponse2 = response = orchestrationResponse;
        if (orchestrationResponse2 instanceof SucceedTaskResponse) {
            String string;
            String string2;
            SucceedTaskResponse succeedTaskResponse = (SucceedTaskResponse)orchestrationResponse2;
            SucceedTaskResponse succeedTaskResponse2 = succeedTaskResponse;
            if (succeedTaskResponse2 instanceof ArrayResultSetTaskResponse) {
                String string3;
                ArrayResultSetTaskResponse arrayResultSetTaskResponse = (ArrayResultSetTaskResponse)succeedTaskResponse2;
                ResultSet firstResultSet = (ResultSet)Predef$.MODULE$.refArrayOps((Object[])arrayResultSetTaskResponse.getResultSets()).headOption().orNull(Predef$.MODULE$.$conforms());
                if (firstResultSet == null) {
                    this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"JobId ", " execute method ", " with null result."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobReq.getId(), methodEntity})));
                    string3 = IOClientUtils$.MODULE$.SUCCESS();
                } else {
                    string3 = firstResultSet.result();
                }
                string2 = string3;
            } else {
                this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"JobId ", " execute method ", " with null result."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobReq.getId(), methodEntity})));
                string2 = IOClientUtils$.MODULE$.SUCCESS();
            }
            String result = string = string2;
            long executeTime = System.currentTimeMillis();
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " execute method ", ", orchestratorTime(", "ms) execute time(", "ms)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobReq.getId(), methodEntity.methodName(), BoxesRunTime.boxToLong((long)(orchestrationTime - startTime)), BoxesRunTime.boxToLong((long)(executeTime - orchestrationTime))})));
            return result;
        }
        if (orchestrationResponse2 instanceof FailedTaskResponse) {
            FailedTaskResponse failedTaskResponse = (FailedTaskResponse)orchestrationResponse2;
            String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IO_FILE job: ", " failed to execute code : ", ", reason : ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var8_7.getId(), methodEntity, failedTaskResponse.getErrorMsg()}));
            this.logger().info(msg);
            if (failedTaskResponse.getErrorMsg().contains(StorageErrorCode.FS_NOT_INIT.getMessage()) || failedTaskResponse.getErrorMsg().contains(((Object)BoxesRunTime.boxToInteger((int)ECMPluginConf$.MODULE$.ECM_MARK_CACHE_ERROR_CODE())).toString())) {
                throw new FSNotInitException();
            }
            throw new StorageErrorException(IOFileClientConf$.MODULE$.IO_EXECUTE_FAILED_CODE(), msg);
        }
        String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IO_FILE job : ", " failed to execute code : ", ", return a unknown response : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var8_7.getId(), methodEntity, BDPJettyServerHelper$.MODULE$.gson().toJson((Object)orchestrationResponse2)}));
        this.logger().warn(msg);
        throw new StorageErrorException(IOFileClientConf$.MODULE$.IO_EXECUTE_UNKNOWN_REASON_CODE(), msg);
    }

    public int executeResult$default$4() {
        return 0;
    }

    @Override
    public String executeWithRetry(String user, MethodEntity methodEntity, BindEngineLabel bindEngineLabel, int reTryLimit) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (bindEngineLabel != null) {
            IOClientUtils$.MODULE$.addLabelToParams((Label<?>)bindEngineLabel, (Map<String, Object>)params);
        }
        String result = this.executeResult(user, methodEntity, params, reTryLimit);
        return result;
    }

    @Override
    public int executeWithRetry$default$4() {
        return this.defaultRetry();
    }

    public DefaultIOClient() {
        IOClient$class.$init$(this);
        Logging.class.$init$((Logging)this);
        this.loadBalanceLabel = IOClientUtils$.MODULE$.getDefaultLoadBalanceLabel();
        this.extraLabels = (Label[])Utils$.MODULE$.tryCatch((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Label<?>[] apply() {
                return IOClientUtils$.MODULE$.getExtraLabels();
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DefaultIOClient $outer;

            public final Label<?>[] apply(Throwable x0$1) {
                Throwable throwable = x0$1;
                if (throwable != null) {
                    Throwable throwable2 = throwable;
                    this.$outer.logger().error("Failed to create extraLabels, No extra labels will be used", throwable2);
                    Label[] labelArray = (Label[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Label.class));
                    return labelArray;
                }
                throw new MatchError((Object)throwable);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

