/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.record.Buffer;

@Deprecated
@InterfaceAudience.Public
@InterfaceStability.Stable
public class Utils {
    public static final char[] hexchars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int B10 = Integer.parseInt("10000000", 2);
    private static final int B110 = Integer.parseInt("11000000", 2);
    private static final int B1110 = Integer.parseInt("11100000", 2);
    private static final int B11110 = Integer.parseInt("11110000", 2);
    private static final int B11 = Integer.parseInt("11000000", 2);
    private static final int B111 = Integer.parseInt("11100000", 2);
    private static final int B1111 = Integer.parseInt("11110000", 2);
    private static final int B11111 = Integer.parseInt("11111000", 2);

    private Utils() {
    }

    static String toXMLString(String s2) {
        StringBuilder sb = new StringBuilder();
        for (int idx = 0; idx < s2.length(); ++idx) {
            char ch = s2.charAt(idx);
            if (ch == '<') {
                sb.append("&lt;");
                continue;
            }
            if (ch == '&') {
                sb.append("&amp;");
                continue;
            }
            if (ch == '%') {
                sb.append("%0025");
                continue;
            }
            if (ch < ' ' || ch > '\ud7ff' && ch < '\ue000' || ch > '\ufffd') {
                sb.append("%");
                sb.append(hexchars[(ch & 0xF000) >> 12]);
                sb.append(hexchars[(ch & 0xF00) >> 8]);
                sb.append(hexchars[(ch & 0xF0) >> 4]);
                sb.append(hexchars[ch & 0xF]);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static int h2c(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        return 0;
    }

    static String fromXMLString(String s2) {
        StringBuilder sb = new StringBuilder();
        int idx = 0;
        while (idx < s2.length()) {
            char ch;
            if ((ch = s2.charAt(idx++)) == '%') {
                int ch1 = Utils.h2c(s2.charAt(idx++)) << 12;
                int ch2 = Utils.h2c(s2.charAt(idx++)) << 8;
                int ch3 = Utils.h2c(s2.charAt(idx++)) << 4;
                int ch4 = Utils.h2c(s2.charAt(idx++));
                char res = (char)(ch1 | ch2 | ch3 | ch4);
                sb.append(res);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    static String toCSVString(String s2) {
        StringBuilder sb = new StringBuilder(s2.length() + 1);
        sb.append('\'');
        int len = s2.length();
        block8: for (int i = 0; i < len; ++i) {
            char c = s2.charAt(i);
            switch (c) {
                case '\u0000': {
                    sb.append("%00");
                    continue block8;
                }
                case '\n': {
                    sb.append("%0A");
                    continue block8;
                }
                case '\r': {
                    sb.append("%0D");
                    continue block8;
                }
                case ',': {
                    sb.append("%2C");
                    continue block8;
                }
                case '}': {
                    sb.append("%7D");
                    continue block8;
                }
                case '%': {
                    sb.append("%25");
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    static String fromCSVString(String s2) throws IOException {
        if (s2.charAt(0) != '\'') {
            throw new IOException("Error deserializing string.");
        }
        int len = s2.length();
        StringBuilder sb = new StringBuilder(len - 1);
        for (int i = 1; i < len; ++i) {
            char c = s2.charAt(i);
            if (c == '%') {
                char ch1 = s2.charAt(i + 1);
                char ch2 = s2.charAt(i + 2);
                i += 2;
                if (ch1 == '0' && ch2 == '0') {
                    sb.append('\u0000');
                    continue;
                }
                if (ch1 == '0' && ch2 == 'A') {
                    sb.append('\n');
                    continue;
                }
                if (ch1 == '0' && ch2 == 'D') {
                    sb.append('\r');
                    continue;
                }
                if (ch1 == '2' && ch2 == 'C') {
                    sb.append(',');
                    continue;
                }
                if (ch1 == '7' && ch2 == 'D') {
                    sb.append('}');
                    continue;
                }
                if (ch1 == '2' && ch2 == '5') {
                    sb.append('%');
                    continue;
                }
                throw new IOException("Error deserializing string.");
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static String toXMLBuffer(Buffer s2) {
        return s2.toString();
    }

    static Buffer fromXMLBuffer(String s2) throws IOException {
        if (s2.length() == 0) {
            return new Buffer();
        }
        int blen = s2.length() / 2;
        byte[] barr = new byte[blen];
        for (int idx = 0; idx < blen; ++idx) {
            char c1 = s2.charAt(2 * idx);
            char c2 = s2.charAt(2 * idx + 1);
            barr[idx] = (byte)Integer.parseInt("" + c1 + c2, 16);
        }
        return new Buffer(barr);
    }

    static String toCSVBuffer(Buffer buf) {
        StringBuilder sb = new StringBuilder("#");
        sb.append(buf.toString());
        return sb.toString();
    }

    static Buffer fromCSVBuffer(String s2) throws IOException {
        if (s2.charAt(0) != '#') {
            throw new IOException("Error deserializing buffer.");
        }
        if (s2.length() == 1) {
            return new Buffer();
        }
        int blen = (s2.length() - 1) / 2;
        byte[] barr = new byte[blen];
        for (int idx = 0; idx < blen; ++idx) {
            char c1 = s2.charAt(2 * idx + 1);
            char c2 = s2.charAt(2 * idx + 2);
            barr[idx] = (byte)Integer.parseInt("" + c1 + c2, 16);
        }
        return new Buffer(barr);
    }

    private static int utf8LenForCodePoint(int cpt) throws IOException {
        if (cpt >= 0 && cpt <= 127) {
            return 1;
        }
        if (cpt >= 128 && cpt <= 2047) {
            return 2;
        }
        if (cpt >= 2048 && cpt < 55296 || cpt > 57343 && cpt <= 65533) {
            return 3;
        }
        if (cpt >= 65536 && cpt <= 0x10FFFF) {
            return 4;
        }
        throw new IOException("Illegal Unicode Codepoint " + Integer.toHexString(cpt) + " in string.");
    }

    private static int writeUtf8(int cpt, byte[] bytes, int offset) throws IOException {
        if (cpt >= 0 && cpt <= 127) {
            bytes[offset] = (byte)cpt;
            return 1;
        }
        if (cpt >= 128 && cpt <= 2047) {
            bytes[offset + 1] = (byte)(B10 | cpt & 0x3F);
            bytes[offset] = (byte)(B110 | (cpt >>= 6) & 0x1F);
            return 2;
        }
        if (cpt >= 2048 && cpt < 55296 || cpt > 57343 && cpt <= 65533) {
            bytes[offset + 2] = (byte)(B10 | cpt & 0x3F);
            bytes[offset + 1] = (byte)(B10 | (cpt >>= 6) & 0x3F);
            bytes[offset] = (byte)(B1110 | (cpt >>= 6) & 0xF);
            return 3;
        }
        if (cpt >= 65536 && cpt <= 0x10FFFF) {
            bytes[offset + 3] = (byte)(B10 | cpt & 0x3F);
            bytes[offset + 2] = (byte)(B10 | (cpt >>= 6) & 0x3F);
            bytes[offset + 1] = (byte)(B10 | (cpt >>= 6) & 0x3F);
            bytes[offset] = (byte)(B11110 | (cpt >>= 6) & 7);
            return 4;
        }
        throw new IOException("Illegal Unicode Codepoint " + Integer.toHexString(cpt) + " in string.");
    }

    static void toBinaryString(DataOutput out, String str) throws IOException {
        int strlen = str.length();
        byte[] bytes = new byte[strlen * 4];
        int utf8Len = 0;
        int idx = 0;
        while (idx < strlen) {
            int cpt;
            idx += Character.isSupplementaryCodePoint(cpt = str.codePointAt(idx)) ? 2 : 1;
            utf8Len += Utils.writeUtf8(cpt, bytes, utf8Len);
        }
        Utils.writeVInt(out, utf8Len);
        out.write(bytes, 0, utf8Len);
    }

    static boolean isValidCodePoint(int cpt) {
        return !(cpt > 0x10FFFF || cpt >= 55296 && cpt <= 57343 || cpt >= 65534 && cpt <= 65535);
    }

    private static int utf8ToCodePoint(int b1, int b2, int b3, int b4) {
        int cpt = 0;
        cpt = (b1 & ~B11111) << 18 | (b2 & ~B11) << 12 | (b3 & ~B11) << 6 | b4 & ~B11;
        return cpt;
    }

    private static int utf8ToCodePoint(int b1, int b2, int b3) {
        int cpt = 0;
        cpt = (b1 & ~B1111) << 12 | (b2 & ~B11) << 6 | b3 & ~B11;
        return cpt;
    }

    private static int utf8ToCodePoint(int b1, int b2) {
        int cpt = 0;
        cpt = (b1 & ~B111) << 6 | b2 & ~B11;
        return cpt;
    }

    private static void checkB10(int b) throws IOException {
        if ((b & B11) != B10) {
            throw new IOException("Invalid UTF-8 representation.");
        }
    }

    static String fromBinaryString(DataInput din) throws IOException {
        int utf8Len = Utils.readVInt(din);
        byte[] bytes = new byte[utf8Len];
        din.readFully(bytes);
        int len = 0;
        StringBuilder sb = new StringBuilder(utf8Len);
        while (len < utf8Len) {
            int b3;
            int b2;
            int b1;
            int cpt = 0;
            if ((b1 = bytes[len++] & 0xFF) <= 127) {
                cpt = b1;
            } else if ((b1 & B11111) == B11110) {
                b2 = bytes[len++] & 0xFF;
                Utils.checkB10(b2);
                b3 = bytes[len++] & 0xFF;
                Utils.checkB10(b3);
                int b4 = bytes[len++] & 0xFF;
                Utils.checkB10(b4);
                cpt = Utils.utf8ToCodePoint(b1, b2, b3, b4);
            } else if ((b1 & B1111) == B1110) {
                b2 = bytes[len++] & 0xFF;
                Utils.checkB10(b2);
                b3 = bytes[len++] & 0xFF;
                Utils.checkB10(b3);
                cpt = Utils.utf8ToCodePoint(b1, b2, b3);
            } else if ((b1 & B111) == B110) {
                b2 = bytes[len++] & 0xFF;
                Utils.checkB10(b2);
                cpt = Utils.utf8ToCodePoint(b1, b2);
            } else {
                throw new IOException("Invalid UTF-8 byte " + Integer.toHexString(b1) + " at offset " + (len - 1) + " in length of " + utf8Len);
            }
            if (!Utils.isValidCodePoint(cpt)) {
                throw new IOException("Illegal Unicode Codepoint " + Integer.toHexString(cpt) + " in stream.");
            }
            sb.appendCodePoint(cpt);
        }
        return sb.toString();
    }

    public static float readFloat(byte[] bytes, int start) {
        return WritableComparator.readFloat(bytes, start);
    }

    public static double readDouble(byte[] bytes, int start) {
        return WritableComparator.readDouble(bytes, start);
    }

    public static long readVLong(byte[] bytes, int start) throws IOException {
        return WritableComparator.readVLong(bytes, start);
    }

    public static int readVInt(byte[] bytes, int start) throws IOException {
        return WritableComparator.readVInt(bytes, start);
    }

    public static long readVLong(DataInput in) throws IOException {
        return WritableUtils.readVLong(in);
    }

    public static int readVInt(DataInput in) throws IOException {
        return WritableUtils.readVInt(in);
    }

    public static int getVIntSize(long i) {
        return WritableUtils.getVIntSize(i);
    }

    public static void writeVLong(DataOutput stream, long i) throws IOException {
        WritableUtils.writeVLong(stream, i);
    }

    public static void writeVInt(DataOutput stream, int i) throws IOException {
        WritableUtils.writeVInt(stream, i);
    }

    public static int compareBytes(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        return WritableComparator.compareBytes(b1, s1, l1, b2, s2, l2);
    }
}

