/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.web.KerberosUgiAuthenticator;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.ssl.SSLFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS"})
@InterfaceStability.Unstable
public class URLConnectionFactory {
    private static final Log LOG = LogFactory.getLog(URLConnectionFactory.class);
    public static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    private final ConnectionConfigurator connConfigurator;
    private static final ConnectionConfigurator DEFAULT_TIMEOUT_CONN_CONFIGURATOR = new ConnectionConfigurator(){

        public HttpURLConnection configure(HttpURLConnection conn) throws IOException {
            URLConnectionFactory.setTimeouts(conn, 60000);
            return conn;
        }
    };
    public static final URLConnectionFactory DEFAULT_SYSTEM_CONNECTION_FACTORY = new URLConnectionFactory(DEFAULT_TIMEOUT_CONN_CONFIGURATOR);

    public static URLConnectionFactory newDefaultURLConnectionFactory(Configuration conf) {
        ConnectionConfigurator conn = null;
        try {
            conn = URLConnectionFactory.newSslConnConfigurator(60000, conf);
        }
        catch (Exception e) {
            LOG.debug("Cannot load customized ssl related configuration. Fallback to system-generic settings.", e);
            conn = DEFAULT_TIMEOUT_CONN_CONFIGURATOR;
        }
        return new URLConnectionFactory(conn);
    }

    @VisibleForTesting
    URLConnectionFactory(ConnectionConfigurator connConfigurator) {
        this.connConfigurator = connConfigurator;
    }

    private static ConnectionConfigurator newSslConnConfigurator(final int timeout, Configuration conf) throws IOException, GeneralSecurityException {
        SSLFactory factory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        factory.init();
        final SSLSocketFactory sf = factory.createSSLSocketFactory();
        final HostnameVerifier hv = factory.getHostnameVerifier();
        return new ConnectionConfigurator(){

            public HttpURLConnection configure(HttpURLConnection conn) throws IOException {
                if (conn instanceof HttpsURLConnection) {
                    HttpsURLConnection c = (HttpsURLConnection)conn;
                    c.setSSLSocketFactory(sf);
                    c.setHostnameVerifier(hv);
                }
                URLConnectionFactory.setTimeouts(conn, timeout);
                return conn;
            }
        };
    }

    public URLConnection openConnection(URL url) throws IOException {
        try {
            return this.openConnection(url, false);
        }
        catch (AuthenticationException e) {
            return null;
        }
    }

    public URLConnection openConnection(URL url, boolean isSpnego) throws IOException, AuthenticationException {
        URLConnection connection;
        if (isSpnego) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("open AuthenticatedURL connection" + url);
            }
            UserGroupInformation.getCurrentUser().checkTGTAndReloginFromKeytab();
            AuthenticatedURL.Token authToken = new AuthenticatedURL.Token();
            return new AuthenticatedURL((Authenticator)new KerberosUgiAuthenticator(), this.connConfigurator).openConnection(url, authToken);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("open URL connection");
        }
        if ((connection = url.openConnection()) instanceof HttpURLConnection) {
            this.connConfigurator.configure((HttpURLConnection)connection);
        }
        return connection;
    }

    private static void setTimeouts(URLConnection connection, int socketTimeout) {
        connection.setConnectTimeout(socketTimeout);
        connection.setReadTimeout(socketTimeout);
    }
}

