/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.MD5MD5CRC32CastagnoliFileChecksum;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.MD5MD5CRC32GzipFileChecksum;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrCodec;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.FsPermissionExtension;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectReader;

public class JsonUtil {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final DatanodeInfo[] EMPTY_DATANODE_INFO_ARRAY = new DatanodeInfo[0];

    public static String toJsonString(Token<? extends TokenIdentifier> token) throws IOException {
        return JsonUtil.toJsonString(Token.class, JsonUtil.toJsonMap(token));
    }

    private static Map<String, Object> toJsonMap(Token<? extends TokenIdentifier> token) throws IOException {
        if (token == null) {
            return null;
        }
        TreeMap<String, Object> m3 = new TreeMap<String, Object>();
        m3.put("urlString", token.encodeToUrlString());
        return m3;
    }

    public static Token<? extends TokenIdentifier> toToken(Map<?, ?> m3) throws IOException {
        if (m3 == null) {
            return null;
        }
        Token token = new Token();
        token.decodeFromUrlString((String)m3.get("urlString"));
        return token;
    }

    public static Token<DelegationTokenIdentifier> toDelegationToken(Map<?, ?> json) throws IOException {
        Map m3 = (Map)json.get(Token.class.getSimpleName());
        return JsonUtil.toToken(m3);
    }

    private static Token<BlockTokenIdentifier> toBlockToken(Map<?, ?> m3) throws IOException {
        return JsonUtil.toToken(m3);
    }

    public static String toJsonString(Exception e) {
        TreeMap<String, String> m3 = new TreeMap<String, String>();
        m3.put("exception", e.getClass().getSimpleName());
        m3.put("message", e.getMessage());
        m3.put("javaClassName", e.getClass().getName());
        return JsonUtil.toJsonString(RemoteException.class, m3);
    }

    public static RemoteException toRemoteException(Map<?, ?> json) {
        Map m3 = (Map)json.get(RemoteException.class.getSimpleName());
        String message = (String)m3.get("message");
        String javaClassName = (String)m3.get("javaClassName");
        return new RemoteException(javaClassName, message);
    }

    private static String toJsonString(Class<?> clazz, Object value) {
        return JsonUtil.toJsonString(clazz.getSimpleName(), value);
    }

    public static String toJsonString(String key, Object value) {
        TreeMap<String, Object> m3 = new TreeMap<String, Object>();
        m3.put(key, value);
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(m3);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static String toString(FsPermission permission) {
        return String.format("%o", permission.toShort());
    }

    private static FsPermission toFsPermission(String s2, Boolean aclBit, Boolean encBit) {
        boolean eBit;
        FsPermission perm = new FsPermission(Short.parseShort(s2, 8));
        boolean aBit = aclBit != null ? aclBit : false;
        boolean bl = eBit = encBit != null ? encBit : false;
        if (aBit || eBit) {
            return new FsPermissionExtension(perm, aBit, eBit);
        }
        return perm;
    }

    public static String toJsonString(HdfsFileStatus status, boolean includeType) {
        if (status == null) {
            return null;
        }
        TreeMap<String, Object> m3 = new TreeMap<String, Object>();
        m3.put("pathSuffix", status.getLocalName());
        m3.put("type", (Object)PathType.valueOf(status));
        if (status.isSymlink()) {
            m3.put("symlink", status.getSymlink());
        }
        m3.put("length", status.getLen());
        m3.put("owner", status.getOwner());
        m3.put("group", status.getGroup());
        FsPermission perm = status.getPermission();
        m3.put("permission", JsonUtil.toString(perm));
        if (perm.getAclBit()) {
            m3.put("aclBit", true);
        }
        if (perm.getEncryptedBit()) {
            m3.put("encBit", true);
        }
        m3.put("accessTime", status.getAccessTime());
        m3.put("modificationTime", status.getModificationTime());
        m3.put("blockSize", status.getBlockSize());
        m3.put("replication", status.getReplication());
        m3.put("fileId", status.getFileId());
        m3.put("childrenNum", status.getChildrenNum());
        m3.put("storagePolicy", status.getStoragePolicy());
        ObjectMapper mapper = new ObjectMapper();
        try {
            return includeType ? JsonUtil.toJsonString(FileStatus.class, m3) : mapper.writeValueAsString(m3);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static HdfsFileStatus toFileStatus(Map<?, ?> json, boolean includesType) {
        if (json == null) {
            return null;
        }
        Map m3 = includesType ? (Map)json.get(FileStatus.class.getSimpleName()) : json;
        String localName = (String)m3.get("pathSuffix");
        PathType type = PathType.valueOf((String)m3.get("type"));
        byte[] symlink = type != PathType.SYMLINK ? null : DFSUtil.string2Bytes((String)m3.get("symlink"));
        long len = ((Number)m3.get("length")).longValue();
        String owner = (String)m3.get("owner");
        String group = (String)m3.get("group");
        FsPermission permission = JsonUtil.toFsPermission((String)m3.get("permission"), (Boolean)m3.get("aclBit"), (Boolean)m3.get("encBit"));
        long aTime = ((Number)m3.get("accessTime")).longValue();
        long mTime = ((Number)m3.get("modificationTime")).longValue();
        long blockSize = ((Number)m3.get("blockSize")).longValue();
        short replication = ((Number)m3.get("replication")).shortValue();
        long fileId = m3.containsKey("fileId") ? ((Number)m3.get("fileId")).longValue() : 0L;
        int childrenNum = JsonUtil.getInt(m3, "childrenNum", -1);
        byte storagePolicy = m3.containsKey("storagePolicy") ? (byte)((Number)m3.get("storagePolicy")).longValue() : (byte)0;
        return new HdfsFileStatus(len, type == PathType.DIRECTORY, replication, blockSize, mTime, aTime, permission, owner, group, symlink, DFSUtil.string2Bytes(localName), fileId, childrenNum, null, storagePolicy);
    }

    private static Map<String, Object> toJsonMap(ExtendedBlock extendedblock) {
        if (extendedblock == null) {
            return null;
        }
        TreeMap<String, Object> m3 = new TreeMap<String, Object>();
        m3.put("blockPoolId", extendedblock.getBlockPoolId());
        m3.put("blockId", extendedblock.getBlockId());
        m3.put("numBytes", extendedblock.getNumBytes());
        m3.put("generationStamp", extendedblock.getGenerationStamp());
        return m3;
    }

    private static ExtendedBlock toExtendedBlock(Map<?, ?> m3) {
        if (m3 == null) {
            return null;
        }
        String blockPoolId = (String)m3.get("blockPoolId");
        long blockId = ((Number)m3.get("blockId")).longValue();
        long numBytes = ((Number)m3.get("numBytes")).longValue();
        long generationStamp = ((Number)m3.get("generationStamp")).longValue();
        return new ExtendedBlock(blockPoolId, blockId, numBytes, generationStamp);
    }

    static Map<String, Object> toJsonMap(DatanodeInfo datanodeinfo) {
        if (datanodeinfo == null) {
            return null;
        }
        TreeMap<String, Object> m3 = new TreeMap<String, Object>();
        m3.put("ipAddr", datanodeinfo.getIpAddr());
        m3.put("name", datanodeinfo.getXferAddr());
        m3.put("hostName", datanodeinfo.getHostName());
        m3.put("storageID", datanodeinfo.getDatanodeUuid());
        m3.put("xferPort", datanodeinfo.getXferPort());
        m3.put("infoPort", datanodeinfo.getInfoPort());
        m3.put("infoSecurePort", datanodeinfo.getInfoSecurePort());
        m3.put("ipcPort", datanodeinfo.getIpcPort());
        m3.put("capacity", datanodeinfo.getCapacity());
        m3.put("dfsUsed", datanodeinfo.getDfsUsed());
        m3.put("remaining", datanodeinfo.getRemaining());
        m3.put("blockPoolUsed", datanodeinfo.getBlockPoolUsed());
        m3.put("cacheCapacity", datanodeinfo.getCacheCapacity());
        m3.put("cacheUsed", datanodeinfo.getCacheUsed());
        m3.put("lastUpdate", datanodeinfo.getLastUpdate());
        m3.put("lastUpdateMonotonic", datanodeinfo.getLastUpdateMonotonic());
        m3.put("xceiverCount", datanodeinfo.getXceiverCount());
        m3.put("networkLocation", datanodeinfo.getNetworkLocation());
        m3.put("adminState", datanodeinfo.getAdminState().name());
        return m3;
    }

    private static int getInt(Map<?, ?> m3, String key, int defaultValue) {
        Object value = m3.get(key);
        if (value == null) {
            return defaultValue;
        }
        return ((Number)value).intValue();
    }

    private static long getLong(Map<?, ?> m3, String key, long defaultValue) {
        Object value = m3.get(key);
        if (value == null) {
            return defaultValue;
        }
        return ((Number)value).longValue();
    }

    private static String getString(Map<?, ?> m3, String key, String defaultValue) {
        Object value = m3.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (String)value;
    }

    static List<?> getList(Map<?, ?> m3, String key) {
        Object list = m3.get(key);
        if (list instanceof List) {
            return (List)list;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static DatanodeInfo toDatanodeInfo(Map<?, ?> m3) throws IOException {
        String ipAddr;
        if (m3 == null) {
            return null;
        }
        int xferPort = JsonUtil.getInt(m3, "xferPort", -1);
        Object tmpValue = m3.get("ipAddr");
        String string = ipAddr = tmpValue == null ? null : (String)tmpValue;
        if (ipAddr == null) {
            tmpValue = m3.get("name");
            if (tmpValue == null) throw new IOException("Missing both 'ipAddr' and 'name' in server response.");
            String name = (String)tmpValue;
            int colonIdx = name.indexOf(58);
            if (colonIdx <= 0) throw new IOException("Invalid value in server response: name=[" + name + "]");
            ipAddr = name.substring(0, colonIdx);
            xferPort = Integer.parseInt(name.substring(colonIdx + 1));
        }
        if (xferPort != -1) return new DatanodeInfo(ipAddr, (String)m3.get("hostName"), (String)m3.get("storageID"), xferPort, ((Number)m3.get("infoPort")).intValue(), JsonUtil.getInt(m3, "infoSecurePort", 0), ((Number)m3.get("ipcPort")).intValue(), JsonUtil.getLong(m3, "capacity", 0L), JsonUtil.getLong(m3, "dfsUsed", 0L), JsonUtil.getLong(m3, "remaining", 0L), JsonUtil.getLong(m3, "blockPoolUsed", 0L), JsonUtil.getLong(m3, "cacheCapacity", 0L), JsonUtil.getLong(m3, "cacheUsed", 0L), JsonUtil.getLong(m3, "lastUpdate", 0L), JsonUtil.getLong(m3, "lastUpdateMonotonic", 0L), JsonUtil.getInt(m3, "xceiverCount", 0), JsonUtil.getString(m3, "networkLocation", ""), DatanodeInfo.AdminStates.valueOf(JsonUtil.getString(m3, "adminState", "NORMAL")));
        throw new IOException("Invalid or missing 'xferPort' in server response.");
    }

    private static Object[] toJsonArray(DatanodeInfo[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] a = new Object[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = JsonUtil.toJsonMap(array[i]);
        }
        return a;
    }

    private static DatanodeInfo[] toDatanodeInfoArray(List<?> objects) throws IOException {
        if (objects == null) {
            return null;
        }
        if (objects.isEmpty()) {
            return EMPTY_DATANODE_INFO_ARRAY;
        }
        DatanodeInfo[] array = new DatanodeInfo[objects.size()];
        int i = 0;
        for (Object object : objects) {
            array[i++] = JsonUtil.toDatanodeInfo((Map)object);
        }
        return array;
    }

    private static Map<String, Object> toJsonMap(LocatedBlock locatedblock) throws IOException {
        if (locatedblock == null) {
            return null;
        }
        TreeMap<String, Object> m3 = new TreeMap<String, Object>();
        m3.put("blockToken", JsonUtil.toJsonMap(locatedblock.getBlockToken()));
        m3.put("isCorrupt", locatedblock.isCorrupt());
        m3.put("startOffset", locatedblock.getStartOffset());
        m3.put("block", JsonUtil.toJsonMap(locatedblock.getBlock()));
        m3.put("locations", JsonUtil.toJsonArray(locatedblock.getLocations()));
        m3.put("cachedLocations", JsonUtil.toJsonArray(locatedblock.getCachedLocations()));
        return m3;
    }

    private static LocatedBlock toLocatedBlock(Map<?, ?> m3) throws IOException {
        if (m3 == null) {
            return null;
        }
        ExtendedBlock b = JsonUtil.toExtendedBlock((Map)m3.get("block"));
        DatanodeInfo[] locations = JsonUtil.toDatanodeInfoArray(JsonUtil.getList(m3, "locations"));
        long startOffset = ((Number)m3.get("startOffset")).longValue();
        boolean isCorrupt = (Boolean)m3.get("isCorrupt");
        DatanodeInfo[] cachedLocations = JsonUtil.toDatanodeInfoArray(JsonUtil.getList(m3, "cachedLocations"));
        LocatedBlock locatedblock = new LocatedBlock(b, locations, null, null, startOffset, isCorrupt, cachedLocations);
        locatedblock.setBlockToken(JsonUtil.toBlockToken((Map)m3.get("blockToken")));
        return locatedblock;
    }

    private static Object[] toJsonArray(List<LocatedBlock> array) throws IOException {
        if (array == null) {
            return null;
        }
        if (array.size() == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] a = new Object[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            a[i] = JsonUtil.toJsonMap(array.get(i));
        }
        return a;
    }

    private static List<LocatedBlock> toLocatedBlockList(List<?> objects) throws IOException {
        if (objects == null) {
            return null;
        }
        if (objects.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LocatedBlock> list = new ArrayList<LocatedBlock>(objects.size());
        for (Object object : objects) {
            list.add(JsonUtil.toLocatedBlock((Map)object));
        }
        return list;
    }

    public static String toJsonString(LocatedBlocks locatedblocks) throws IOException {
        if (locatedblocks == null) {
            return null;
        }
        TreeMap<String, Object> m3 = new TreeMap<String, Object>();
        m3.put("fileLength", locatedblocks.getFileLength());
        m3.put("isUnderConstruction", locatedblocks.isUnderConstruction());
        m3.put("locatedBlocks", JsonUtil.toJsonArray(locatedblocks.getLocatedBlocks()));
        m3.put("lastLocatedBlock", JsonUtil.toJsonMap(locatedblocks.getLastLocatedBlock()));
        m3.put("isLastBlockComplete", locatedblocks.isLastBlockComplete());
        return JsonUtil.toJsonString(LocatedBlocks.class, m3);
    }

    public static LocatedBlocks toLocatedBlocks(Map<?, ?> json) throws IOException {
        if (json == null) {
            return null;
        }
        Map m3 = (Map)json.get(LocatedBlocks.class.getSimpleName());
        long fileLength = ((Number)m3.get("fileLength")).longValue();
        boolean isUnderConstruction = (Boolean)m3.get("isUnderConstruction");
        List<LocatedBlock> locatedBlocks = JsonUtil.toLocatedBlockList(JsonUtil.getList(m3, "locatedBlocks"));
        LocatedBlock lastLocatedBlock = JsonUtil.toLocatedBlock((Map)m3.get("lastLocatedBlock"));
        boolean isLastBlockComplete = (Boolean)m3.get("isLastBlockComplete");
        return new LocatedBlocks(fileLength, isUnderConstruction, locatedBlocks, lastLocatedBlock, isLastBlockComplete, null);
    }

    public static String toJsonString(ContentSummary contentsummary) {
        if (contentsummary == null) {
            return null;
        }
        TreeMap<String, Long> m3 = new TreeMap<String, Long>();
        m3.put("length", contentsummary.getLength());
        m3.put("fileCount", contentsummary.getFileCount());
        m3.put("directoryCount", contentsummary.getDirectoryCount());
        m3.put("quota", contentsummary.getQuota());
        m3.put("spaceConsumed", contentsummary.getSpaceConsumed());
        m3.put("spaceQuota", contentsummary.getSpaceQuota());
        return JsonUtil.toJsonString(ContentSummary.class, m3);
    }

    public static ContentSummary toContentSummary(Map<?, ?> json) {
        if (json == null) {
            return null;
        }
        Map m3 = (Map)json.get(ContentSummary.class.getSimpleName());
        long length = ((Number)m3.get("length")).longValue();
        long fileCount = ((Number)m3.get("fileCount")).longValue();
        long directoryCount = ((Number)m3.get("directoryCount")).longValue();
        long quota = ((Number)m3.get("quota")).longValue();
        long spaceConsumed = ((Number)m3.get("spaceConsumed")).longValue();
        long spaceQuota = ((Number)m3.get("spaceQuota")).longValue();
        return new ContentSummary.Builder().length(length).fileCount(fileCount).directoryCount(directoryCount).quota(quota).spaceConsumed(spaceConsumed).spaceQuota(spaceQuota).build();
    }

    public static String toJsonString(MD5MD5CRC32FileChecksum checksum) {
        if (checksum == null) {
            return null;
        }
        TreeMap<String, Object> m3 = new TreeMap<String, Object>();
        m3.put("algorithm", checksum.getAlgorithmName());
        m3.put("length", checksum.getLength());
        m3.put("bytes", StringUtils.byteToHexString(checksum.getBytes()));
        return JsonUtil.toJsonString(FileChecksum.class, m3);
    }

    public static MD5MD5CRC32FileChecksum toMD5MD5CRC32FileChecksum(Map<?, ?> json) throws IOException {
        MD5MD5CRC32FileChecksum checksum;
        if (json == null) {
            return null;
        }
        Map m3 = (Map)json.get(FileChecksum.class.getSimpleName());
        String algorithm = (String)m3.get("algorithm");
        int length = ((Number)m3.get("length")).intValue();
        byte[] bytes = StringUtils.hexStringToByte((String)m3.get("bytes"));
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        DataChecksum.Type crcType = MD5MD5CRC32FileChecksum.getCrcTypeFromAlgorithmName(algorithm);
        switch (crcType) {
            case CRC32: {
                checksum = new MD5MD5CRC32GzipFileChecksum();
                break;
            }
            case CRC32C: {
                checksum = new MD5MD5CRC32CastagnoliFileChecksum();
                break;
            }
            default: {
                throw new IOException("Unknown algorithm: " + algorithm);
            }
        }
        checksum.readFields(in);
        if (!checksum.getAlgorithmName().equals(algorithm)) {
            throw new IOException("Algorithm not matched. Expected " + algorithm + ", Received " + checksum.getAlgorithmName());
        }
        if (length != checksum.getLength()) {
            throw new IOException("Length not matched: length=" + length + ", checksum.getLength()=" + checksum.getLength());
        }
        return checksum;
    }

    public static String toJsonString(AclStatus status) {
        if (status == null) {
            return null;
        }
        TreeMap<String, Object> m3 = new TreeMap<String, Object>();
        m3.put("owner", status.getOwner());
        m3.put("group", status.getGroup());
        m3.put("stickyBit", status.isStickyBit());
        ArrayList<String> stringEntries = new ArrayList<String>();
        for (AclEntry entry : status.getEntries()) {
            stringEntries.add(entry.toString());
        }
        m3.put("entries", stringEntries);
        FsPermission perm = status.getPermission();
        if (perm != null) {
            m3.put("permission", JsonUtil.toString(perm));
            if (perm.getAclBit()) {
                m3.put("aclBit", true);
            }
            if (perm.getEncryptedBit()) {
                m3.put("encBit", true);
            }
        }
        TreeMap<String, TreeMap<String, Object>> finalMap = new TreeMap<String, TreeMap<String, Object>>();
        finalMap.put(AclStatus.class.getSimpleName(), m3);
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(finalMap);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static AclStatus toAclStatus(Map<?, ?> json) {
        if (json == null) {
            return null;
        }
        Map m3 = (Map)json.get(AclStatus.class.getSimpleName());
        AclStatus.Builder aclStatusBuilder = new AclStatus.Builder();
        aclStatusBuilder.owner((String)m3.get("owner"));
        aclStatusBuilder.group((String)m3.get("group"));
        aclStatusBuilder.stickyBit((Boolean)m3.get("stickyBit"));
        String permString = (String)m3.get("permission");
        if (permString != null) {
            FsPermission permission = JsonUtil.toFsPermission(permString, (Boolean)m3.get("aclBit"), (Boolean)m3.get("encBit"));
            aclStatusBuilder.setPermission(permission);
        }
        List entries = (List)m3.get("entries");
        ArrayList<AclEntry> aclEntryList = new ArrayList<AclEntry>();
        for (Object entry : entries) {
            AclEntry aclEntry = AclEntry.parseAclEntry((String)entry, true);
            aclEntryList.add(aclEntry);
        }
        aclStatusBuilder.addEntries(aclEntryList);
        return aclStatusBuilder.build();
    }

    private static Map<String, Object> toJsonMap(XAttr xAttr, XAttrCodec encoding) throws IOException {
        if (xAttr == null) {
            return null;
        }
        TreeMap<String, Object> m3 = new TreeMap<String, Object>();
        m3.put("name", XAttrHelper.getPrefixName(xAttr));
        m3.put("value", xAttr.getValue() != null ? XAttrCodec.encodeValue(xAttr.getValue(), encoding) : null);
        return m3;
    }

    private static Object[] toJsonArray(List<XAttr> array, XAttrCodec encoding) throws IOException {
        if (array == null) {
            return null;
        }
        if (array.size() == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] a = new Object[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            a[i] = JsonUtil.toJsonMap(array.get(i), encoding);
        }
        return a;
    }

    public static String toJsonString(List<XAttr> xAttrs, XAttrCodec encoding) throws IOException {
        TreeMap<String, Object[]> finalMap = new TreeMap<String, Object[]>();
        finalMap.put("XAttrs", JsonUtil.toJsonArray(xAttrs, encoding));
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString(finalMap);
    }

    public static String toJsonString(List<XAttr> xAttrs) throws IOException {
        ArrayList<String> names = Lists.newArrayListWithCapacity(xAttrs.size());
        for (XAttr xAttr : xAttrs) {
            names.add(XAttrHelper.getPrefixName(xAttr));
        }
        ObjectMapper mapper = new ObjectMapper();
        String ret = mapper.writeValueAsString(names);
        TreeMap<String, String> finalMap = new TreeMap<String, String>();
        finalMap.put("XAttrNames", ret);
        return mapper.writeValueAsString(finalMap);
    }

    public static byte[] getXAttr(Map<?, ?> json, String name) throws IOException {
        if (json == null) {
            return null;
        }
        Map<String, byte[]> xAttrs = JsonUtil.toXAttrs(json);
        if (xAttrs != null) {
            return xAttrs.get(name);
        }
        return null;
    }

    public static Map<String, byte[]> toXAttrs(Map<?, ?> json) throws IOException {
        if (json == null) {
            return null;
        }
        return JsonUtil.toXAttrMap(JsonUtil.getList(json, "XAttrs"));
    }

    public static List<String> toXAttrNames(Map<?, ?> json) throws IOException {
        if (json == null) {
            return null;
        }
        String namesInJson = (String)json.get("XAttrNames");
        ObjectReader reader = new ObjectMapper().reader(List.class);
        List xattrs = (List)reader.readValue(namesInJson);
        ArrayList<String> names = Lists.newArrayListWithCapacity(json.keySet().size());
        for (Object xattr : xattrs) {
            names.add((String)xattr);
        }
        return names;
    }

    private static Map<String, byte[]> toXAttrMap(List<?> objects) throws IOException {
        if (objects == null) {
            return null;
        }
        if (objects.isEmpty()) {
            return Maps.newHashMap();
        }
        HashMap<String, byte[]> xAttrs = Maps.newHashMap();
        for (Object object : objects) {
            Map m3 = (Map)object;
            String name = (String)m3.get("name");
            String value = (String)m3.get("value");
            xAttrs.put(name, JsonUtil.decodeXAttrValue(value));
        }
        return xAttrs;
    }

    private static byte[] decodeXAttrValue(String value) throws IOException {
        if (value != null) {
            return XAttrCodec.decodeValue(value);
        }
        return new byte[0];
    }

    static enum PathType {
        FILE,
        DIRECTORY,
        SYMLINK;


        static PathType valueOf(HdfsFileStatus status) {
            return status.isDir() ? DIRECTORY : (status.isSymlink() ? SYMLINK : FILE);
        }
    }
}

