/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import com.google.common.collect.Lists;
import com.google.protobuf.GeneratedMessage;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormatPBINode;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormatProtobuf;
import org.apache.hadoop.hdfs.server.namenode.FSImageUtil;
import org.apache.hadoop.hdfs.server.namenode.FsImageProto;
import org.apache.hadoop.hdfs.util.XMLUtils;
import org.apache.hadoop.util.LimitInputStream;

@InterfaceAudience.Private
public final class PBImageXmlWriter {
    private final Configuration conf;
    private final PrintStream out;
    private String[] stringTable;

    public PBImageXmlWriter(Configuration conf, PrintStream out) {
        this.conf = conf;
        this.out = out;
    }

    public void visit(RandomAccessFile file) throws IOException {
        if (!FSImageUtil.checkFileFormat(file)) {
            throw new IOException("Unrecognized FSImage");
        }
        FsImageProto.FileSummary summary = FSImageUtil.loadSummary(file);
        try (FileInputStream fin = new FileInputStream(file.getFD());){
            this.out.print("<?xml version=\"1.0\"?>\n<fsimage>");
            ArrayList<FsImageProto.FileSummary.Section> sections = Lists.newArrayList(summary.getSectionsList());
            Collections.sort(sections, new Comparator<FsImageProto.FileSummary.Section>(){

                @Override
                public int compare(FsImageProto.FileSummary.Section s1, FsImageProto.FileSummary.Section s2) {
                    FSImageFormatProtobuf.SectionName n1 = FSImageFormatProtobuf.SectionName.fromString(s1.getName());
                    FSImageFormatProtobuf.SectionName n2 = FSImageFormatProtobuf.SectionName.fromString(s2.getName());
                    if (n1 == null) {
                        return n2 == null ? 0 : -1;
                    }
                    if (n2 == null) {
                        return -1;
                    }
                    return n1.ordinal() - n2.ordinal();
                }
            });
            for (FsImageProto.FileSummary.Section s2 : sections) {
                fin.getChannel().position(s2.getOffset());
                InputStream is = FSImageUtil.wrapInputStreamForCompression(this.conf, summary.getCodec(), new BufferedInputStream(new LimitInputStream(fin, s2.getLength())));
                switch (FSImageFormatProtobuf.SectionName.fromString(s2.getName())) {
                    case NS_INFO: {
                        this.dumpNameSection(is);
                        break;
                    }
                    case STRING_TABLE: {
                        this.loadStringTable(is);
                        break;
                    }
                    case INODE: {
                        this.dumpINodeSection(is);
                        break;
                    }
                    case INODE_REFERENCE: {
                        this.dumpINodeReferenceSection(is);
                        break;
                    }
                    case INODE_DIR: {
                        this.dumpINodeDirectorySection(is);
                        break;
                    }
                    case FILES_UNDERCONSTRUCTION: {
                        this.dumpFileUnderConstructionSection(is);
                        break;
                    }
                    case SNAPSHOT: {
                        this.dumpSnapshotSection(is);
                        break;
                    }
                    case SNAPSHOT_DIFF: {
                        this.dumpSnapshotDiffSection(is);
                        break;
                    }
                    case SECRET_MANAGER: {
                        this.dumpSecretManagerSection(is);
                        break;
                    }
                    case CACHE_MANAGER: {
                        this.dumpCacheManagerSection(is);
                        break;
                    }
                }
            }
            this.out.print("</fsimage>\n");
        }
    }

    private void dumpCacheManagerSection(InputStream is) throws IOException {
        GeneratedMessage p;
        int i;
        this.out.print("<CacheManagerSection>");
        FsImageProto.CacheManagerSection s2 = FsImageProto.CacheManagerSection.parseDelimitedFrom(is);
        this.o("nextDirectiveId", s2.getNextDirectiveId());
        for (i = 0; i < s2.getNumPools(); ++i) {
            p = ClientNamenodeProtocolProtos.CachePoolInfoProto.parseDelimitedFrom(is);
            this.out.print("<pool>");
            this.o("poolName", ((ClientNamenodeProtocolProtos.CachePoolInfoProto)p).getPoolName()).o("ownerName", ((ClientNamenodeProtocolProtos.CachePoolInfoProto)p).getOwnerName()).o("groupName", ((ClientNamenodeProtocolProtos.CachePoolInfoProto)p).getGroupName()).o("mode", ((ClientNamenodeProtocolProtos.CachePoolInfoProto)p).getMode()).o("limit", ((ClientNamenodeProtocolProtos.CachePoolInfoProto)p).getLimit()).o("maxRelativeExpiry", ((ClientNamenodeProtocolProtos.CachePoolInfoProto)p).getMaxRelativeExpiry());
            this.out.print("</pool>\n");
        }
        for (i = 0; i < s2.getNumDirectives(); ++i) {
            p = ClientNamenodeProtocolProtos.CacheDirectiveInfoProto.parseDelimitedFrom(is);
            this.out.print("<directive>");
            this.o("id", ((ClientNamenodeProtocolProtos.CacheDirectiveInfoProto)p).getId()).o("path", ((ClientNamenodeProtocolProtos.CacheDirectiveInfoProto)p).getPath()).o("replication", ((ClientNamenodeProtocolProtos.CacheDirectiveInfoProto)p).getReplication()).o("pool", ((ClientNamenodeProtocolProtos.CacheDirectiveInfoProto)p).getPool());
            this.out.print("<expiration>");
            ClientNamenodeProtocolProtos.CacheDirectiveInfoExpirationProto e = ((ClientNamenodeProtocolProtos.CacheDirectiveInfoProto)p).getExpiration();
            this.o("millis", e.getMillis()).o("relatilve", e.getIsRelative());
            this.out.print("</expiration>\n");
            this.out.print("</directive>\n");
        }
        this.out.print("</CacheManagerSection>\n");
    }

    private void dumpFileUnderConstructionSection(InputStream in) throws IOException {
        FsImageProto.FilesUnderConstructionSection.FileUnderConstructionEntry e;
        this.out.print("<FileUnderConstructionSection>");
        while ((e = FsImageProto.FilesUnderConstructionSection.FileUnderConstructionEntry.parseDelimitedFrom(in)) != null) {
            this.out.print("<inode>");
            this.o("id", e.getInodeId()).o("path", e.getFullPath());
            this.out.print("</inode>\n");
        }
        this.out.print("</FileUnderConstructionSection>\n");
    }

    private void dumpINodeDirectory(FsImageProto.INodeSection.INodeDirectory d) {
        this.o("mtime", d.getModificationTime()).o("permission", this.dumpPermission(d.getPermission()));
        if (d.hasDsQuota() && d.hasNsQuota()) {
            this.o("nsquota", d.getNsQuota()).o("dsquota", d.getDsQuota());
        }
    }

    private void dumpINodeDirectorySection(InputStream in) throws IOException {
        FsImageProto.INodeDirectorySection.DirEntry e;
        this.out.print("<INodeDirectorySection>");
        while ((e = FsImageProto.INodeDirectorySection.DirEntry.parseDelimitedFrom(in)) != null) {
            this.out.print("<directory>");
            this.o("parent", e.getParent());
            Iterator<Number> iterator = e.getChildrenList().iterator();
            while (iterator.hasNext()) {
                long id = iterator.next();
                this.o("inode", id);
            }
            iterator = e.getRefChildrenList().iterator();
            while (iterator.hasNext()) {
                int refId = (Integer)iterator.next();
                this.o("inodereference-index", refId);
            }
            this.out.print("</directory>\n");
        }
        this.out.print("</INodeDirectorySection>\n");
    }

    private void dumpINodeReferenceSection(InputStream in) throws IOException {
        FsImageProto.INodeReferenceSection.INodeReference e;
        this.out.print("<INodeReferenceSection>");
        while ((e = FsImageProto.INodeReferenceSection.INodeReference.parseDelimitedFrom(in)) != null) {
            this.dumpINodeReference(e);
        }
        this.out.print("</INodeReferenceSection>");
    }

    private void dumpINodeReference(FsImageProto.INodeReferenceSection.INodeReference r) {
        this.out.print("<ref>");
        this.o("referredId", r.getReferredId()).o("name", r.getName().toStringUtf8()).o("dstSnapshotId", r.getDstSnapshotId()).o("lastSnapshotId", r.getLastSnapshotId());
        this.out.print("</ref>\n");
    }

    private void dumpINodeFile(FsImageProto.INodeSection.INodeFile f) {
        this.o("replication", f.getReplication()).o("mtime", f.getModificationTime()).o("atime", f.getAccessTime()).o("perferredBlockSize", f.getPreferredBlockSize()).o("permission", this.dumpPermission(f.getPermission()));
        if (f.getBlocksCount() > 0) {
            this.out.print("<blocks>");
            for (HdfsProtos.BlockProto b : f.getBlocksList()) {
                this.out.print("<block>");
                this.o("id", b.getBlockId()).o("genstamp", b.getGenStamp()).o("numBytes", b.getNumBytes());
                this.out.print("</block>\n");
            }
            this.out.print("</blocks>\n");
        }
        if (f.hasFileUC()) {
            FsImageProto.INodeSection.FileUnderConstructionFeature u = f.getFileUC();
            this.out.print("<file-under-construction>");
            this.o("clientName", u.getClientName()).o("clientMachine", u.getClientMachine());
            this.out.print("</file-under-construction>\n");
        }
    }

    private void dumpINodeSection(InputStream in) throws IOException {
        FsImageProto.INodeSection s2 = FsImageProto.INodeSection.parseDelimitedFrom(in);
        this.out.print("<INodeSection>");
        this.o("lastInodeId", s2.getLastInodeId());
        int i = 0;
        while ((long)i < s2.getNumInodes()) {
            FsImageProto.INodeSection.INode p = FsImageProto.INodeSection.INode.parseDelimitedFrom(in);
            this.out.print("<inode>");
            this.o("id", p.getId()).o("type", p.getType()).o("name", p.getName().toStringUtf8());
            if (p.hasFile()) {
                this.dumpINodeFile(p.getFile());
            } else if (p.hasDirectory()) {
                this.dumpINodeDirectory(p.getDirectory());
            } else if (p.hasSymlink()) {
                this.dumpINodeSymlink(p.getSymlink());
            }
            this.out.print("</inode>\n");
            ++i;
        }
        this.out.print("</INodeSection>\n");
    }

    private void dumpINodeSymlink(FsImageProto.INodeSection.INodeSymlink s2) {
        this.o("permission", this.dumpPermission(s2.getPermission())).o("target", s2.getTarget().toStringUtf8()).o("mtime", s2.getModificationTime()).o("atime", s2.getAccessTime());
    }

    private void dumpNameSection(InputStream in) throws IOException {
        FsImageProto.NameSystemSection s2 = FsImageProto.NameSystemSection.parseDelimitedFrom(in);
        this.out.print("<NameSection>\n");
        this.o("genstampV1", s2.getGenstampV1()).o("genstampV2", s2.getGenstampV2()).o("genstampV1Limit", s2.getGenstampV1Limit()).o("lastAllocatedBlockId", s2.getLastAllocatedBlockId()).o("txid", s2.getTransactionId());
        this.out.print("</NameSection>\n");
    }

    private String dumpPermission(long permission) {
        return FSImageFormatPBINode.Loader.loadPermission(permission, this.stringTable).toString();
    }

    private void dumpSecretManagerSection(InputStream is) throws IOException {
        this.out.print("<SecretManagerSection>");
        FsImageProto.SecretManagerSection s2 = FsImageProto.SecretManagerSection.parseDelimitedFrom(is);
        this.o("currentId", s2.getCurrentId()).o("tokenSequenceNumber", s2.getTokenSequenceNumber());
        this.out.print("</SecretManagerSection>");
    }

    private void dumpSnapshotDiffSection(InputStream in) throws IOException {
        FsImageProto.SnapshotDiffSection.DiffEntry e;
        this.out.print("<SnapshotDiffSection>");
        while ((e = FsImageProto.SnapshotDiffSection.DiffEntry.parseDelimitedFrom(in)) != null) {
            this.out.print("<diff>");
            this.o("inodeid", e.getInodeId());
            switch (e.getType()) {
                case FILEDIFF: {
                    int i;
                    for (i = 0; i < e.getNumOfDiff(); ++i) {
                        this.out.print("<filediff>");
                        FsImageProto.SnapshotDiffSection.FileDiff f = FsImageProto.SnapshotDiffSection.FileDiff.parseDelimitedFrom(in);
                        this.o("snapshotId", f.getSnapshotId()).o("size", f.getFileSize()).o("name", f.getName().toStringUtf8());
                        this.out.print("</filediff>\n");
                    }
                    break;
                }
                case DIRECTORYDIFF: {
                    int i;
                    for (i = 0; i < e.getNumOfDiff(); ++i) {
                        this.out.print("<dirdiff>");
                        FsImageProto.SnapshotDiffSection.DirectoryDiff d = FsImageProto.SnapshotDiffSection.DirectoryDiff.parseDelimitedFrom(in);
                        this.o("snapshotId", d.getSnapshotId()).o("isSnapshotroot", d.getIsSnapshotRoot()).o("childrenSize", d.getChildrenSize()).o("name", d.getName().toStringUtf8());
                        for (int j = 0; j < d.getCreatedListSize(); ++j) {
                            FsImageProto.SnapshotDiffSection.CreatedListEntry ce = FsImageProto.SnapshotDiffSection.CreatedListEntry.parseDelimitedFrom(in);
                            this.out.print("<created>");
                            this.o("name", ce.getName().toStringUtf8());
                            this.out.print("</created>\n");
                        }
                        Iterator<Number> iterator = d.getDeletedINodeList().iterator();
                        while (iterator.hasNext()) {
                            long did = iterator.next();
                            this.out.print("<deleted>");
                            this.o("inode", did);
                            this.out.print("</deleted>\n");
                        }
                        iterator = d.getDeletedINodeRefList().iterator();
                        while (iterator.hasNext()) {
                            int dRefid = (Integer)iterator.next();
                            this.out.print("<deleted>");
                            this.o("inodereference-index", dRefid);
                            this.out.print("</deleted>\n");
                        }
                        this.out.print("</dirdiff>\n");
                    }
                    break;
                }
            }
            this.out.print("</diff>");
        }
        this.out.print("</SnapshotDiffSection>\n");
    }

    private void dumpSnapshotSection(InputStream in) throws IOException {
        this.out.print("<SnapshotSection>");
        FsImageProto.SnapshotSection s2 = FsImageProto.SnapshotSection.parseDelimitedFrom(in);
        this.o("snapshotCounter", s2.getSnapshotCounter());
        if (s2.getSnapshottableDirCount() > 0) {
            this.out.print("<snapshottableDir>");
            for (long id : s2.getSnapshottableDirList()) {
                this.o("dir", id);
            }
            this.out.print("</snapshottableDir>\n");
        }
        for (int i = 0; i < s2.getNumSnapshots(); ++i) {
            FsImageProto.SnapshotSection.Snapshot pbs = FsImageProto.SnapshotSection.Snapshot.parseDelimitedFrom(in);
            this.o("snapshot", pbs.getSnapshotId());
        }
        this.out.print("</SnapshotSection>\n");
    }

    private void loadStringTable(InputStream in) throws IOException {
        FsImageProto.StringTableSection s2 = FsImageProto.StringTableSection.parseDelimitedFrom(in);
        this.stringTable = new String[s2.getNumEntry() + 1];
        for (int i = 0; i < s2.getNumEntry(); ++i) {
            FsImageProto.StringTableSection.Entry e = FsImageProto.StringTableSection.Entry.parseDelimitedFrom(in);
            this.stringTable[e.getId()] = e.getStr();
        }
    }

    private PBImageXmlWriter o(String e, Object v) {
        this.out.print("<" + e + ">" + XMLUtils.mangleXmlString(v.toString(), true) + "</" + e + ">");
        return this;
    }
}

