/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

class SerialNumberManager {
    static final SerialNumberManager INSTANCE = new SerialNumberManager();
    private final SerialNumberMap<String> usermap = new SerialNumberMap();
    private final SerialNumberMap<String> groupmap = new SerialNumberMap();

    private SerialNumberManager() {
        this.getUserSerialNumber(null);
        this.getGroupSerialNumber(null);
    }

    int getUserSerialNumber(String u) {
        return this.usermap.get(u);
    }

    int getGroupSerialNumber(String g2) {
        return this.groupmap.get(g2);
    }

    String getUser(int n) {
        return this.usermap.get(n);
    }

    String getGroup(int n) {
        return this.groupmap.get(n);
    }

    private static class SerialNumberMap<T> {
        private final AtomicInteger max = new AtomicInteger(1);
        private final ConcurrentMap<T, Integer> t2i = new ConcurrentHashMap<T, Integer>();
        private final ConcurrentMap<Integer, T> i2t = new ConcurrentHashMap<Integer, T>();

        private SerialNumberMap() {
        }

        int get(T t) {
            if (t == null) {
                return 0;
            }
            Integer sn = (Integer)this.t2i.get(t);
            if (sn == null) {
                sn = this.max.getAndIncrement();
                Integer old = this.t2i.putIfAbsent(t, sn);
                if (old != null) {
                    return old;
                }
                this.i2t.put(sn, t);
            }
            return sn;
        }

        T get(int i) {
            if (i == 0) {
                return null;
            }
            Object t = this.i2t.get(i);
            if (t == null) {
                throw new IllegalStateException("!i2t.containsKey(" + i + "), this=" + this);
            }
            return (T)t;
        }

        public String toString() {
            return "max=" + this.max + ",\n  t2i=" + this.t2i + ",\n  i2t=" + this.i2t;
        }
    }
}

