/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguousUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.util.LightWeightGSet;

@InterfaceAudience.Private
public class BlockInfoContiguous
extends Block
implements LightWeightGSet.LinkedElement {
    public static final BlockInfoContiguous[] EMPTY_ARRAY = new BlockInfoContiguous[0];
    private BlockCollection bc;
    private LightWeightGSet.LinkedElement nextLinkedElement;
    private Object[] triplets;

    public BlockInfoContiguous(short replication) {
        this.triplets = new Object[3 * replication];
        this.bc = null;
    }

    public BlockInfoContiguous(Block blk, short replication) {
        super(blk);
        this.triplets = new Object[3 * replication];
        this.bc = null;
    }

    protected BlockInfoContiguous(BlockInfoContiguous from) {
        this(from, from.bc.getBlockReplication());
        this.bc = from.bc;
    }

    public BlockCollection getBlockCollection() {
        return this.bc;
    }

    public void setBlockCollection(BlockCollection bc) {
        this.bc = bc;
    }

    public DatanodeDescriptor getDatanode(int index) {
        DatanodeStorageInfo storage = this.getStorageInfo(index);
        return storage == null ? null : storage.getDatanodeDescriptor();
    }

    DatanodeStorageInfo getStorageInfo(int index) {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (index >= 0 && index * 3 < this.triplets.length) : "Index is out of bound";
        return (DatanodeStorageInfo)this.triplets[index * 3];
    }

    private BlockInfoContiguous getPrevious(int index) {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (index >= 0 && index * 3 + 1 < this.triplets.length) : "Index is out of bound";
        BlockInfoContiguous info = (BlockInfoContiguous)this.triplets[index * 3 + 1];
        assert (info == null || info.getClass().getName().startsWith(BlockInfoContiguous.class.getName())) : "BlockInfo is expected at " + index * 3;
        return info;
    }

    BlockInfoContiguous getNext(int index) {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (index >= 0 && index * 3 + 2 < this.triplets.length) : "Index is out of bound";
        BlockInfoContiguous info = (BlockInfoContiguous)this.triplets[index * 3 + 2];
        assert (info == null || info.getClass().getName().startsWith(BlockInfoContiguous.class.getName())) : "BlockInfo is expected at " + index * 3;
        return info;
    }

    private void setStorageInfo(int index, DatanodeStorageInfo storage) {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (index >= 0 && index * 3 < this.triplets.length) : "Index is out of bound";
        this.triplets[index * 3] = storage;
    }

    private BlockInfoContiguous setPrevious(int index, BlockInfoContiguous to) {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (index >= 0 && index * 3 + 1 < this.triplets.length) : "Index is out of bound";
        BlockInfoContiguous info = (BlockInfoContiguous)this.triplets[index * 3 + 1];
        this.triplets[index * 3 + 1] = to;
        return info;
    }

    private BlockInfoContiguous setNext(int index, BlockInfoContiguous to) {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (index >= 0 && index * 3 + 2 < this.triplets.length) : "Index is out of bound";
        BlockInfoContiguous info = (BlockInfoContiguous)this.triplets[index * 3 + 2];
        this.triplets[index * 3 + 2] = to;
        return info;
    }

    public int getCapacity() {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (this.triplets.length % 3 == 0) : "Malformed BlockInfo";
        return this.triplets.length / 3;
    }

    private int ensureCapacity(int num) {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        int last = this.numNodes();
        if (this.triplets.length >= (last + num) * 3) {
            return last;
        }
        Object[] old = this.triplets;
        this.triplets = new Object[(last + num) * 3];
        System.arraycopy(old, 0, this.triplets, 0, last * 3);
        return last;
    }

    public int numNodes() {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (this.triplets.length % 3 == 0) : "Malformed BlockInfo";
        for (int idx = this.getCapacity() - 1; idx >= 0; --idx) {
            if (this.getDatanode(idx) == null) continue;
            return idx + 1;
        }
        return 0;
    }

    boolean addStorage(DatanodeStorageInfo storage) {
        int lastNode = this.ensureCapacity(1);
        this.setStorageInfo(lastNode, storage);
        this.setNext(lastNode, null);
        this.setPrevious(lastNode, null);
        return true;
    }

    boolean removeStorage(DatanodeStorageInfo storage) {
        int dnIndex = this.findStorageInfo(storage);
        if (dnIndex < 0) {
            return false;
        }
        assert (this.getPrevious(dnIndex) == null && this.getNext(dnIndex) == null) : "Block is still in the list and must be removed first.";
        int lastNode = this.numNodes() - 1;
        this.setStorageInfo(dnIndex, this.getStorageInfo(lastNode));
        this.setNext(dnIndex, this.getNext(lastNode));
        this.setPrevious(dnIndex, this.getPrevious(lastNode));
        this.setStorageInfo(lastNode, null);
        this.setNext(lastNode, null);
        this.setPrevious(lastNode, null);
        return true;
    }

    boolean findDatanode(DatanodeDescriptor dn) {
        int len = this.getCapacity();
        for (int idx = 0; idx < len; ++idx) {
            DatanodeDescriptor cur = this.getDatanode(idx);
            if (cur == dn) {
                return true;
            }
            if (cur == null) break;
        }
        return false;
    }

    DatanodeStorageInfo findStorageInfo(DatanodeDescriptor dn) {
        DatanodeStorageInfo cur;
        int len = this.getCapacity();
        for (int idx = 0; idx < len && (cur = this.getStorageInfo(idx)) != null; ++idx) {
            if (cur.getDatanodeDescriptor() != dn) continue;
            return cur;
        }
        return null;
    }

    int findStorageInfo(DatanodeStorageInfo storageInfo) {
        int len = this.getCapacity();
        for (int idx = 0; idx < len; ++idx) {
            DatanodeStorageInfo cur = this.getStorageInfo(idx);
            if (cur == storageInfo) {
                return idx;
            }
            if (cur == null) break;
        }
        return -1;
    }

    BlockInfoContiguous listInsert(BlockInfoContiguous head, DatanodeStorageInfo storage) {
        int dnIndex = this.findStorageInfo(storage);
        assert (dnIndex >= 0) : "Data node is not found: current";
        assert (this.getPrevious(dnIndex) == null && this.getNext(dnIndex) == null) : "Block is already in the list and cannot be inserted.";
        this.setPrevious(dnIndex, null);
        this.setNext(dnIndex, head);
        if (head != null) {
            head.setPrevious(head.findStorageInfo(storage), this);
        }
        return this;
    }

    BlockInfoContiguous listRemove(BlockInfoContiguous head, DatanodeStorageInfo storage) {
        if (head == null) {
            return null;
        }
        int dnIndex = this.findStorageInfo(storage);
        if (dnIndex < 0) {
            return head;
        }
        BlockInfoContiguous next = this.getNext(dnIndex);
        BlockInfoContiguous prev = this.getPrevious(dnIndex);
        this.setNext(dnIndex, null);
        this.setPrevious(dnIndex, null);
        if (prev != null) {
            prev.setNext(prev.findStorageInfo(storage), next);
        }
        if (next != null) {
            next.setPrevious(next.findStorageInfo(storage), prev);
        }
        if (this == head) {
            head = next;
        }
        return head;
    }

    public BlockInfoContiguous moveBlockToHead(BlockInfoContiguous head, DatanodeStorageInfo storage, int curIndex, int headIndex) {
        if (head == this) {
            return this;
        }
        BlockInfoContiguous next = this.setNext(curIndex, head);
        BlockInfoContiguous prev = this.setPrevious(curIndex, null);
        head.setPrevious(headIndex, this);
        prev.setNext(prev.findStorageInfo(storage), next);
        if (next != null) {
            next.setPrevious(next.findStorageInfo(storage), prev);
        }
        return this;
    }

    public HdfsServerConstants.BlockUCState getBlockUCState() {
        return HdfsServerConstants.BlockUCState.COMPLETE;
    }

    public boolean isComplete() {
        return this.getBlockUCState().equals((Object)HdfsServerConstants.BlockUCState.COMPLETE);
    }

    public BlockInfoContiguousUnderConstruction convertToBlockUnderConstruction(HdfsServerConstants.BlockUCState s2, DatanodeStorageInfo[] targets) {
        if (this.isComplete()) {
            BlockInfoContiguousUnderConstruction ucBlock = new BlockInfoContiguousUnderConstruction(this, this.getBlockCollection().getBlockReplication(), s2, targets);
            ucBlock.setBlockCollection(this.getBlockCollection());
            return ucBlock;
        }
        BlockInfoContiguousUnderConstruction ucBlock = (BlockInfoContiguousUnderConstruction)this;
        ucBlock.setBlockUCState(s2);
        ucBlock.setExpectedLocations(targets);
        ucBlock.setBlockCollection(this.getBlockCollection());
        return ucBlock;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || super.equals(obj);
    }

    @Override
    public LightWeightGSet.LinkedElement getNext() {
        return this.nextLinkedElement;
    }

    @Override
    public void setNext(LightWeightGSet.LinkedElement next) {
        this.nextLinkedElement = next;
    }
}

