/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol.datatransfer;

import com.google.protobuf.Message;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.datatransfer.BlockConstructionStage;
import org.apache.hadoop.hdfs.protocol.datatransfer.DataTransferProtoUtil;
import org.apache.hadoop.hdfs.protocol.datatransfer.DataTransferProtocol;
import org.apache.hadoop.hdfs.protocol.datatransfer.Op;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitShm;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DataChecksum;
import org.apache.htrace.Span;
import org.apache.htrace.Trace;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class Sender
implements DataTransferProtocol {
    private final DataOutputStream out;

    public Sender(DataOutputStream out) {
        this.out = out;
    }

    private static void op(DataOutput out, Op op) throws IOException {
        out.writeShort(28);
        op.write(out);
    }

    private static void send(DataOutputStream out, Op opcode, Message proto) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Sending DataTransferOp " + proto.getClass().getSimpleName() + ": " + proto);
        }
        Sender.op(out, opcode);
        proto.writeDelimitedTo(out);
        out.flush();
    }

    private static DataTransferProtos.CachingStrategyProto getCachingStrategy(CachingStrategy cachingStrategy) {
        DataTransferProtos.CachingStrategyProto.Builder builder = DataTransferProtos.CachingStrategyProto.newBuilder();
        if (cachingStrategy.getReadahead() != null) {
            builder.setReadahead(cachingStrategy.getReadahead());
        }
        if (cachingStrategy.getDropBehind() != null) {
            builder.setDropBehind(cachingStrategy.getDropBehind());
        }
        return builder.build();
    }

    @Override
    public void readBlock(ExtendedBlock blk, Token<BlockTokenIdentifier> blockToken, String clientName, long blockOffset, long length, boolean sendChecksum, CachingStrategy cachingStrategy) throws IOException {
        DataTransferProtos.OpReadBlockProto proto = DataTransferProtos.OpReadBlockProto.newBuilder().setHeader(DataTransferProtoUtil.buildClientHeader(blk, clientName, blockToken)).setOffset(blockOffset).setLen(length).setSendChecksums(sendChecksum).setCachingStrategy(Sender.getCachingStrategy(cachingStrategy)).build();
        Sender.send(this.out, Op.READ_BLOCK, proto);
    }

    @Override
    public void writeBlock(ExtendedBlock blk, StorageType storageType, Token<BlockTokenIdentifier> blockToken, String clientName, DatanodeInfo[] targets, StorageType[] targetStorageTypes, DatanodeInfo source, BlockConstructionStage stage, int pipelineSize, long minBytesRcvd, long maxBytesRcvd, long latestGenerationStamp, DataChecksum requestedChecksum, CachingStrategy cachingStrategy, boolean allowLazyPersist, boolean pinning, boolean[] targetPinnings) throws IOException {
        DataTransferProtos.ClientOperationHeaderProto header = DataTransferProtoUtil.buildClientHeader(blk, clientName, blockToken);
        DataTransferProtos.ChecksumProto checksumProto = DataTransferProtoUtil.toProto(requestedChecksum);
        DataTransferProtos.OpWriteBlockProto.Builder proto = DataTransferProtos.OpWriteBlockProto.newBuilder().setHeader(header).setStorageType(PBHelper.convertStorageType(storageType)).addAllTargets(PBHelper.convert(targets, 1)).addAllTargetStorageTypes(PBHelper.convertStorageTypes(targetStorageTypes, 1)).setStage(DataTransferProtoUtil.toProto(stage)).setPipelineSize(pipelineSize).setMinBytesRcvd(minBytesRcvd).setMaxBytesRcvd(maxBytesRcvd).setLatestGenerationStamp(latestGenerationStamp).setRequestedChecksum(checksumProto).setCachingStrategy(Sender.getCachingStrategy(cachingStrategy)).setAllowLazyPersist(allowLazyPersist).setPinning(pinning).addAllTargetPinnings(PBHelper.convert(targetPinnings, 1));
        if (source != null) {
            proto.setSource(PBHelper.convertDatanodeInfo(source));
        }
        Sender.send(this.out, Op.WRITE_BLOCK, proto.build());
    }

    @Override
    public void transferBlock(ExtendedBlock blk, Token<BlockTokenIdentifier> blockToken, String clientName, DatanodeInfo[] targets, StorageType[] targetStorageTypes) throws IOException {
        DataTransferProtos.OpTransferBlockProto proto = DataTransferProtos.OpTransferBlockProto.newBuilder().setHeader(DataTransferProtoUtil.buildClientHeader(blk, clientName, blockToken)).addAllTargets(PBHelper.convert(targets)).addAllTargetStorageTypes(PBHelper.convertStorageTypes(targetStorageTypes)).build();
        Sender.send(this.out, Op.TRANSFER_BLOCK, proto);
    }

    @Override
    public void requestShortCircuitFds(ExtendedBlock blk, Token<BlockTokenIdentifier> blockToken, ShortCircuitShm.SlotId slotId, int maxVersion, boolean supportsReceiptVerification) throws IOException {
        DataTransferProtos.OpRequestShortCircuitAccessProto.Builder builder = DataTransferProtos.OpRequestShortCircuitAccessProto.newBuilder().setHeader(DataTransferProtoUtil.buildBaseHeader(blk, blockToken)).setMaxVersion(maxVersion);
        if (slotId != null) {
            builder.setSlotId(PBHelper.convert(slotId));
        }
        builder.setSupportsReceiptVerification(supportsReceiptVerification);
        DataTransferProtos.OpRequestShortCircuitAccessProto proto = builder.build();
        Sender.send(this.out, Op.REQUEST_SHORT_CIRCUIT_FDS, proto);
    }

    @Override
    public void releaseShortCircuitFds(ShortCircuitShm.SlotId slotId) throws IOException {
        DataTransferProtos.ReleaseShortCircuitAccessRequestProto.Builder builder = DataTransferProtos.ReleaseShortCircuitAccessRequestProto.newBuilder().setSlotId(PBHelper.convert(slotId));
        if (Trace.isTracing()) {
            Span s2 = Trace.currentSpan();
            builder.setTraceInfo(DataTransferProtos.DataTransferTraceInfoProto.newBuilder().setTraceId(s2.getTraceId()).setParentId(s2.getSpanId()));
        }
        DataTransferProtos.ReleaseShortCircuitAccessRequestProto proto = builder.build();
        Sender.send(this.out, Op.RELEASE_SHORT_CIRCUIT_FDS, proto);
    }

    @Override
    public void requestShortCircuitShm(String clientName) throws IOException {
        DataTransferProtos.ShortCircuitShmRequestProto.Builder builder = DataTransferProtos.ShortCircuitShmRequestProto.newBuilder().setClientName(clientName);
        if (Trace.isTracing()) {
            Span s2 = Trace.currentSpan();
            builder.setTraceInfo(DataTransferProtos.DataTransferTraceInfoProto.newBuilder().setTraceId(s2.getTraceId()).setParentId(s2.getSpanId()));
        }
        DataTransferProtos.ShortCircuitShmRequestProto proto = builder.build();
        Sender.send(this.out, Op.REQUEST_SHORT_CIRCUIT_SHM, proto);
    }

    @Override
    public void replaceBlock(ExtendedBlock blk, StorageType storageType, Token<BlockTokenIdentifier> blockToken, String delHint, DatanodeInfo source) throws IOException {
        DataTransferProtos.OpReplaceBlockProto proto = DataTransferProtos.OpReplaceBlockProto.newBuilder().setHeader(DataTransferProtoUtil.buildBaseHeader(blk, blockToken)).setStorageType(PBHelper.convertStorageType(storageType)).setDelHint(delHint).setSource(PBHelper.convertDatanodeInfo(source)).build();
        Sender.send(this.out, Op.REPLACE_BLOCK, proto);
    }

    @Override
    public void copyBlock(ExtendedBlock blk, Token<BlockTokenIdentifier> blockToken) throws IOException {
        DataTransferProtos.OpCopyBlockProto proto = DataTransferProtos.OpCopyBlockProto.newBuilder().setHeader(DataTransferProtoUtil.buildBaseHeader(blk, blockToken)).build();
        Sender.send(this.out, Op.COPY_BLOCK, proto);
    }

    @Override
    public void blockChecksum(ExtendedBlock blk, Token<BlockTokenIdentifier> blockToken) throws IOException {
        DataTransferProtos.OpBlockChecksumProto proto = DataTransferProtos.OpBlockChecksumProto.newBuilder().setHeader(DataTransferProtoUtil.buildBaseHeader(blk, blockToken)).build();
        Sender.send(this.out, Op.BLOCK_CHECKSUM, proto);
    }
}

