/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class Command
extends Configured {
    public static String NAME;
    public static String USAGE;
    public static String DESCRIPTION;
    protected String[] args;
    protected String name;
    protected int exitCode = 0;
    protected int numErrors = 0;
    protected boolean recursive = false;
    private int depth = 0;
    protected ArrayList<Exception> exceptions = new ArrayList();
    private static final Log LOG;
    public PrintStream out = System.out;
    public PrintStream err = System.err;
    private CommandFactory commandFactory = null;

    protected Command() {
        this.out = System.out;
        this.err = System.err;
    }

    protected Command(Configuration conf) {
        super(conf);
    }

    public abstract String getCommandName();

    protected void setRecursive(boolean flag) {
        this.recursive = flag;
    }

    protected boolean isRecursive() {
        return this.recursive;
    }

    protected int getDepth() {
        return this.depth;
    }

    protected abstract void run(Path var1) throws IOException;

    public int runAll() {
        int exitCode = 0;
        for (String src : this.args) {
            try {
                PathData[] srcs;
                for (PathData s2 : srcs = PathData.expandAsGlob(src, this.getConf())) {
                    this.run(s2.path);
                }
            }
            catch (IOException e) {
                exitCode = -1;
                this.displayError(e);
            }
        }
        return exitCode;
    }

    public void setCommandFactory(CommandFactory factory) {
        this.commandFactory = factory;
    }

    protected CommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    public int run(String ... argv) {
        LinkedList<String> args = new LinkedList<String>(Arrays.asList(argv));
        try {
            if (this.isDeprecated()) {
                this.displayWarning("DEPRECATED: Please use '" + this.getReplacementCommand() + "' instead.");
            }
            this.processOptions(args);
            this.processRawArguments(args);
        }
        catch (IOException e) {
            this.displayError(e);
        }
        return this.numErrors == 0 ? this.exitCode : this.exitCodeForError();
    }

    protected int exitCodeForError() {
        return 1;
    }

    protected void processOptions(LinkedList<String> args) throws IOException {
    }

    protected void processRawArguments(LinkedList<String> args) throws IOException {
        this.processArguments(this.expandArguments(args));
    }

    protected LinkedList<PathData> expandArguments(LinkedList<String> args) throws IOException {
        LinkedList<PathData> expandedArgs = new LinkedList<PathData>();
        for (String arg : args) {
            try {
                expandedArgs.addAll(this.expandArgument(arg));
            }
            catch (IOException e) {
                this.displayError(e);
            }
        }
        return expandedArgs;
    }

    protected List<PathData> expandArgument(String arg) throws IOException {
        PathData[] items = PathData.expandAsGlob(arg, this.getConf());
        if (items.length == 0) {
            throw new PathNotFoundException(arg);
        }
        return Arrays.asList(items);
    }

    protected void processArguments(LinkedList<PathData> args) throws IOException {
        for (PathData arg : args) {
            try {
                this.processArgument(arg);
            }
            catch (IOException e) {
                this.displayError(e);
            }
        }
    }

    protected void processArgument(PathData item) throws IOException {
        if (item.exists) {
            this.processPathArgument(item);
        } else {
            this.processNonexistentPath(item);
        }
    }

    protected void processPathArgument(PathData item) throws IOException {
        this.depth = 0;
        this.processPaths(null, item);
    }

    protected void processNonexistentPath(PathData item) throws IOException {
        throw new PathNotFoundException(item.toString());
    }

    protected void processPaths(PathData parent, PathData ... items) throws IOException {
        for (PathData item : items) {
            try {
                this.processPath(item);
                if (this.recursive && this.isPathRecursable(item)) {
                    this.recursePath(item);
                }
                this.postProcessPath(item);
            }
            catch (IOException e) {
                this.displayError(e);
            }
        }
    }

    protected boolean isPathRecursable(PathData item) throws IOException {
        return item.stat.isDirectory();
    }

    protected void processPath(PathData item) throws IOException {
        throw new RuntimeException("processPath() is not implemented");
    }

    protected void postProcessPath(PathData item) throws IOException {
    }

    protected void recursePath(PathData item) throws IOException {
        try {
            ++this.depth;
            this.processPaths(item, item.getDirectoryContents());
        }
        finally {
            --this.depth;
        }
    }

    public void displayError(Exception e) {
        this.exceptions.add(e);
        String errorMessage = e.getLocalizedMessage();
        if (errorMessage == null) {
            errorMessage = StringUtils.stringifyException(e);
            LOG.debug(errorMessage);
        } else {
            errorMessage = errorMessage.split("\n", 2)[0];
        }
        this.displayError(errorMessage);
    }

    public void displayError(String message) {
        ++this.numErrors;
        this.displayWarning(message);
    }

    public void displayWarning(String message) {
        this.err.println(this.getName() + ": " + message);
    }

    public String getName() {
        return this.name == null ? this.getCommandField("NAME") : (this.name.startsWith("-") ? this.name.substring(1) : this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUsage() {
        String cmd = "-" + this.getName();
        String usage = this.isDeprecated() ? "" : this.getCommandField("USAGE");
        return usage.isEmpty() ? cmd : cmd + " " + usage;
    }

    public String getDescription() {
        return this.isDeprecated() ? "(DEPRECATED) Same as '" + this.getReplacementCommand() + "'" : this.getCommandField("DESCRIPTION");
    }

    public final boolean isDeprecated() {
        return this.getReplacementCommand() != null;
    }

    public String getReplacementCommand() {
        return null;
    }

    private String getCommandField(String field) {
        String value;
        try {
            Field f = this.getClass().getDeclaredField(field);
            f.setAccessible(true);
            value = f.get(this).toString();
        }
        catch (Exception e) {
            throw new RuntimeException("failed to get " + this.getClass().getSimpleName() + "." + field, e);
        }
        return value;
    }

    static {
        LOG = LogFactory.getLog(Command.class);
    }
}

