/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.httpclient.dws.authentication;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.httpclient.authentication.AbstractAuthenticationStrategy;
import org.apache.linkis.httpclient.authentication.Authentication;
import org.apache.linkis.httpclient.authentication.AuthenticationAction;
import org.apache.linkis.httpclient.authentication.AuthenticationResult;
import org.apache.linkis.httpclient.dws.exception.AuthenticationFailedException;
import org.apache.linkis.httpclient.dws.request.DWSAuthenticationAction;
import org.apache.linkis.httpclient.dws.response.DWSAuthenticationResult;
import org.apache.linkis.httpclient.errorcode.LinkisGwHttpclientSupportErrorCodeSummary;
import org.apache.linkis.httpclient.request.Action;
import org.apache.linkis.httpclient.request.UserAction;
import org.apache.linkis.httpclient.request.UserPwdAction;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001]4Aa\u0004\t\u0001;!A1\u0005\u0001BC\u0002\u0013EC\u0005\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003&\u0011\u0015a\u0003\u0001\"\u0001.\u0011\u0015a\u0003\u0001\"\u00012\u0011\u001d\u0011\u0004\u00011A\u0005\n\u0011Bqa\r\u0001A\u0002\u0013%A\u0007\u0003\u0004;\u0001\u0001\u0006K!\n\u0005\u0006w\u0001!\t\u0001\u0010\u0005\u0006}\u0001!\t\u0001\n\u0005\u0006\u007f\u0001!\t\u0006\u0011\u0005\u0006)\u0002!\t&\u0016\u0005\u00069\u0002!\t%\u0018\u0005\u0006U\u0002!\te\u001b\u0005\u0006g\u0002!\t\u0005\u001e\u0002\u001d'R\fG/[2BkRDWM\u001c;jG\u0006$\u0018n\u001c8TiJ\fG/Z4z\u0015\t\t\"#\u0001\bbkRDWM\u001c;jG\u0006$\u0018n\u001c8\u000b\u0005M!\u0012a\u00013xg*\u0011QCF\u0001\u000bQR$\bo\u00197jK:$(BA\f\u0019\u0003\u0019a\u0017N\\6jg*\u0011\u0011DG\u0001\u0007CB\f7\r[3\u000b\u0003m\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0010\u0011\u0005}\tS\"\u0001\u0011\u000b\u0005E!\u0012B\u0001\u0012!\u0005y\t%m\u001d;sC\u000e$\u0018)\u001e;iK:$\u0018nY1uS>t7\u000b\u001e:bi\u0016<\u00170A\ntKN\u001c\u0018n\u001c8NCb\fE.\u001b<f)&lW-F\u0001&!\t1\u0013&D\u0001(\u0015\u0005A\u0013!B:dC2\f\u0017B\u0001\u0016(\u0005\u0011auN\\4\u0002)M,7o]5p]6\u000b\u00070\u00117jm\u0016$\u0016.\\3!\u0003\u0019a\u0014N\\5u}Q\u0011a\u0006\r\t\u0003_\u0001i\u0011\u0001\u0005\u0005\u0006G\r\u0001\r!\n\u000b\u0002]\u0005!2/\u001a:wKJ\u001cVm]:j_:$\u0016.\\3pkR\f\u0001d]3sm\u0016\u00148+Z:tS>tG+[7f_V$x\fJ3r)\t)\u0004\b\u0005\u0002'm%\u0011qg\n\u0002\u0005+:LG\u000fC\u0004:\r\u0005\u0005\t\u0019A\u0013\u0002\u0007a$\u0013'A\u000btKJ4XM]*fgNLwN\u001c+j[\u0016|W\u000f\u001e\u0011\u0002/M,GoU3sm\u0016\u00148+Z:tS>tG+[7f_V$HCA\u001b>\u0011\u0015\u0011\u0004\u00021\u0001&\u0003]9W\r^*feZ,'oU3tg&|g\u000eV5nK>+H/A\u0004hKR,6/\u001a:\u0015\u0005\u0005c\u0005C\u0001\"J\u001d\t\u0019u\t\u0005\u0002EO5\tQI\u0003\u0002G9\u00051AH]8pizJ!\u0001S\u0014\u0002\rA\u0013X\rZ3g\u0013\tQ5J\u0001\u0004TiJLgn\u001a\u0006\u0003\u0011\u001eBQ!\u0014\u0006A\u00029\u000bQB]3rk\u0016\u001cH/Q2uS>t\u0007CA(S\u001b\u0005\u0001&BA)\u0015\u0003\u001d\u0011X-];fgRL!a\u0015)\u0003\r\u0005\u001bG/[8o\u0003]9W\r^!vi\",g\u000e^5dCRLwN\\!di&|g\u000eF\u0002W3j\u0003\"aH,\n\u0005a\u0003#\u0001F!vi\",g\u000e^5dCRLwN\\!di&|g\u000eC\u0003N\u0017\u0001\u0007a\nC\u0003\\\u0017\u0001\u0007\u0011)A\u0005tKJ4XM]+sY\u00069r-\u001a;BkRDWM\u001c;jG\u0006$\u0018n\u001c8SKN,H\u000e\u001e\u000b\u0004=\u0006L\u0007CA\u0010`\u0013\t\u0001\u0007E\u0001\u000bBkRDWM\u001c;jG\u0006$\u0018n\u001c8SKN,H\u000e\u001e\u0005\u0006E2\u0001\raY\u0001\te\u0016\u001c\bo\u001c8tKB\u0011AmZ\u0007\u0002K*\u0011a\rG\u0001\u0005QR$\b/\u0003\u0002iK\na\u0001\n\u001e;q%\u0016\u001c\bo\u001c8tK\")Q\n\u0004a\u0001-\u0006I\u0011n\u001d+j[\u0016|W\u000f\u001e\u000b\u0003Y>\u0004\"AJ7\n\u00059<#a\u0002\"p_2,\u0017M\u001c\u0005\u0006#5\u0001\r\u0001\u001d\t\u0003?EL!A\u001d\u0011\u0003\u001d\u0005+H\u000f[3oi&\u001c\u0017\r^5p]\u0006aQM\u001c4pe\u000e,Gj\\4j]R\u0019\u0001/\u001e<\t\u000b5s\u0001\u0019\u0001(\t\u000bms\u0001\u0019A!")
public class StaticAuthenticationStrategy
extends AbstractAuthenticationStrategy {
    private final long sessionMaxAliveTime;
    private long serverSessionTimeout;

    public long sessionMaxAliveTime() {
        return this.sessionMaxAliveTime;
    }

    private long serverSessionTimeout() {
        return this.serverSessionTimeout;
    }

    private void serverSessionTimeout_$eq(long x$1) {
        this.serverSessionTimeout = x$1;
    }

    public void setServerSessionTimeout(long serverSessionTimeout) {
        this.serverSessionTimeout_$eq(serverSessionTimeout);
    }

    public long getServerSessionTimeOut() {
        return this.serverSessionTimeout();
    }

    public String getUser(Action requestAction) {
        Action action = requestAction;
        if (action instanceof AuthenticationAction) {
            return null;
        }
        if (action instanceof UserAction) {
            Action action2 = action;
            if (StringUtils.isBlank((CharSequence)((UserAction)action2).getUser())) {
                return this.getClientConfig().getAuthTokenKey();
            }
            return ((UserAction)action2).getUser();
        }
        if (StringUtils.isNotBlank((CharSequence)this.getClientConfig().getAuthTokenKey())) {
            return this.getClientConfig().getAuthTokenKey();
        }
        return null;
    }

    public AuthenticationAction getAuthenticationAction(Action requestAction, String serverUrl) {
        DWSAuthenticationAction action = new DWSAuthenticationAction(serverUrl);
        Action action2 = requestAction;
        if (action2 instanceof UserPwdAction) {
            Action action3 = action2;
            action.addRequestPayload("userName", ((UserAction)action3).getUser());
            action.addRequestPayload("password", ((UserPwdAction)action3).getPassword().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.pwd$1()));
        } else if (action2 instanceof UserAction) {
            Action action4 = action2;
            action.addRequestPayload("userName", ((UserAction)action4).getUser());
            action.addRequestPayload("password", this.pwd$1());
        } else {
            if (StringUtils.isBlank((CharSequence)this.getClientConfig().getAuthTokenKey())) {
                throw new AuthenticationFailedException(LinkisGwHttpclientSupportErrorCodeSummary.AUTHTOKENVALUE_BE_EXISTS.getErrorDesc());
            }
            action.addRequestPayload("userName", this.getClientConfig().getAuthTokenKey());
            action.addRequestPayload("password", this.pwd$1());
        }
        return action;
    }

    public AuthenticationResult getAuthenticationResult(HttpResponse response, AuthenticationAction requestAction) {
        DWSAuthenticationResult result;
        block0: {
            result = new DWSAuthenticationResult(response, requestAction.serverUrl());
            Object timeout = result.getData().get("sessionTimeOut");
            if (timeout == null) break block0;
            this.setServerSessionTimeout(new StringOps(Predef$.MODULE$.augmentString(timeout.toString())).toLong());
        }
        return result;
    }

    public boolean isTimeout(Authentication authentication) {
        return System.currentTimeMillis() - authentication.getLastAccessTime() >= this.serverSessionTimeout();
    }

    public Authentication enforceLogin(Action requestAction, String serverUrl) {
        Authentication authentication;
        String key = this.getKey(requestAction, serverUrl);
        if (key == null) {
            return null;
        }
        long requestTime = System.currentTimeMillis();
        String string = key.intern();
        synchronized (string) {
            Authentication authentication2 = this.getAuthenticationActionByKey(key);
            if (authentication2 == null || authentication2.getCreateTime() < requestTime && System.currentTimeMillis() - authentication2.getCreateTime() > 1000L) {
                authentication2 = this.tryLogin(requestAction, serverUrl);
                this.putSession(key, authentication2);
                this.logger().info(new StringBuilder(17).append(key).append(" try enforceLogin").toString());
            }
            authentication = authentication2;
        }
        return authentication;
    }

    private final String pwd$1() {
        if (StringUtils.isNotBlank((CharSequence)this.getClientConfig().getAuthTokenValue())) {
            return this.getClientConfig().getAuthTokenValue();
        }
        throw new AuthenticationFailedException(LinkisGwHttpclientSupportErrorCodeSummary.AUTHTOKENVALUE_BE_EXISTS.getErrorDesc());
    }

    public StaticAuthenticationStrategy(long sessionMaxAliveTime) {
        this.sessionMaxAliveTime = sessionMaxAliveTime;
        this.serverSessionTimeout = sessionMaxAliveTime;
    }

    public StaticAuthenticationStrategy() {
        this(ByteTimeUtils.timeStringAsMs((String)"1h"));
    }
}

