/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.trino.utils;

import org.apache.linkis.engineplugin.trino.conf.TrinoConfiguration$;
import org.apache.linkis.engineplugin.trino.exception.TrinoClientException;
import org.apache.linkis.engineplugin.trino.exception.TrinoGrantmaException;
import org.apache.linkis.engineplugin.trino.exception.TrinoModifySchemaException;
import scala.runtime.BoxesRunTime;

public final class TrinoCode$ {
    public static TrinoCode$ MODULE$;
    private final String SPACE;

    static {
        new TrinoCode$();
    }

    private String SPACE() {
        return this.SPACE;
    }

    private boolean willGrant(String code) {
        return code.matches("(?=.*grant)(?=.*on)(?=.*to)^.*$");
    }

    private boolean willModifySchema(String code) {
        String trimmedCode = code.replaceAll("\n", this.SPACE()).replaceAll("\\s+", this.SPACE()).toLowerCase();
        return trimmedCode.contains("create schema") || trimmedCode.contains("drop schema") || trimmedCode.contains("alter schema");
    }

    private boolean hasFetchFirst(String code) {
        String trimmedCode = code.replaceAll("\n", this.SPACE()).replaceAll("\\s+", this.SPACE()).toLowerCase();
        return trimmedCode.matches(".*fetch first (\\d+ )?row only.*");
    }

    public void checkCode(String code) {
        if (BoxesRunTime.unboxToBoolean((Object)TrinoConfiguration$.MODULE$.TRINO_FORBID_MODIFY_SCHEMA().getValue()) && this.willModifySchema(code)) {
            throw new TrinoModifySchemaException("CREATE, ALTER, DROP SCHEMA is not allowed");
        }
        if (BoxesRunTime.unboxToBoolean((Object)TrinoConfiguration$.MODULE$.TRINO_FORBID_GRANT().getValue()) && this.willGrant(code)) {
            throw new TrinoGrantmaException("Grant schema or table is not allowed");
        }
        if (BoxesRunTime.unboxToBoolean((Object)TrinoConfiguration$.MODULE$.TRINO_FORBID_FETCHFIRST().getValue()) && this.hasFetchFirst(code)) {
            throw new TrinoClientException("Fetch first row only is not allowed, please use limit n.");
        }
    }

    private TrinoCode$() {
        MODULE$ = this;
        this.SPACE = " ";
    }
}

