/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.sqoop.client;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.DefaultManagerFactory;
import com.cloudera.sqoop.tool.SqoopTool;
import com.cloudera.sqoop.util.OptionsFileUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.mapred.TIPStatus;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskReport;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.linkis.engineconnplugin.sqoop.client.config.ParamsMapping;
import org.apache.linkis.engineconnplugin.sqoop.client.errorcode.SqoopErrorCodeSummary;
import org.apache.linkis.engineconnplugin.sqoop.client.exception.JobClosableException;
import org.apache.linkis.engineconnplugin.sqoop.context.SqoopEnvConfiguration;
import org.apache.linkis.engineconnplugin.sqoop.context.SqoopParamsConfiguration;
import org.apache.linkis.protocol.engine.JobProgressInfo;
import org.apache.sqoop.manager.SqlManager;
import org.apache.sqoop.manager.oracle.OraOopManagerFactory;
import org.apache.sqoop.util.LoggingUtils;

public class Sqoop
extends Configured
implements Tool {
    public static final Log LOG = LogFactory.getLog((String)Sqoop.class.getName());
    public static volatile AtomicReference<Job> job = new AtomicReference();
    public static SqlManager sqlManager;
    public static final String[] DEFAULT_FACTORY_CLASS_NAMES_ARR;
    public static final String FACTORY_CLASS_NAMES_KEY = "sqoop.connection.factories";
    public static final String METRICS_RUN_TIME = "MetricsRunTime";
    private static Float progress;
    public static final String SQOOP_RETHROW_PROPERTY = "sqoop.throwOnError";
    public static final String SQOOP_OPTIONS_FILE_SPECIFIER = "--options-file";
    private SqoopTool tool;
    private SqoopOptions options;
    private String[] childPrgmArgs;

    public Sqoop(SqoopTool tool) {
        this(tool, null);
    }

    public Sqoop(SqoopTool tool, Configuration conf) {
        this(tool, conf, new SqoopOptions());
    }

    public Sqoop(SqoopTool tool, Configuration conf, SqoopOptions opts) {
        if (null != conf) {
            this.setConf(conf);
        }
        this.options = opts;
        this.options.setConf(this.getConf());
        this.tool = tool;
    }

    public SqoopOptions getOptions() {
        return this.options;
    }

    public SqoopTool getTool() {
        return this.tool;
    }

    public int run(String[] args) {
        if (this.options.getConf() == null) {
            this.options.setConf(this.getConf());
        }
        this.options.getConf().setStrings(FACTORY_CLASS_NAMES_KEY, DEFAULT_FACTORY_CLASS_NAMES_ARR);
        try {
            this.options = this.tool.parseArguments(args, null, this.options, false);
            this.tool.appendArgs(this.childPrgmArgs);
            this.tool.validateOptions(this.options);
            if (this.options.getVerbose()) {
                LoggingUtils.setDebugLevel();
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            System.err.println(e.getMessage());
            return 1;
        }
        return this.tool.run(this.options);
    }

    private String[] stashChildPrgmArgs(String[] argv) {
        for (int i = 0; i < argv.length; ++i) {
            if (!"--".equals(argv[i])) continue;
            this.childPrgmArgs = Arrays.copyOfRange(argv, i, argv.length);
            return Arrays.copyOfRange(argv, 0, i);
        }
        return argv;
    }

    public static int runSqoop(Sqoop sqoop, String[] args) {
        String[] toolArgs = sqoop.stashChildPrgmArgs(args);
        try {
            return ToolRunner.run((Configuration)sqoop.getConf(), (Tool)sqoop, (String[])toolArgs);
        }
        catch (Exception e) {
            LOG.error((Object)("Got exception running Sqoop: " + e.toString()));
            e.printStackTrace();
            Sqoop.rethrowIfRequired(toolArgs, e);
            return 1;
        }
    }

    public static void rethrowIfRequired(String[] toolArgs, Exception ex) {
        RuntimeException exceptionToThrow = ex instanceof RuntimeException ? (RuntimeException)ex : new RuntimeException(ex);
        throw exceptionToThrow;
    }

    public static int runTool(Map<String, String> argsMap, Configuration conf) {
        String[] expandedArgs = null;
        try {
            String[] flatArgs = Sqoop.convertParamsMapToAarray(argsMap, conf);
            expandedArgs = OptionsFileUtil.expandArguments((String[])flatArgs);
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while expanding arguments", (Throwable)ex);
            System.err.println(ex.getMessage());
            System.err.println("Try 'sqoop help' for usage.");
            return 1;
        }
        String toolName = expandedArgs[0];
        Configuration pluginConf = SqoopTool.loadPlugins((Configuration)conf);
        SqoopTool tool = SqoopTool.getTool((String)toolName);
        if (null == tool) {
            System.err.println("No such sqoop tool: " + toolName + ". See 'sqoop help'.");
            return 1;
        }
        Sqoop sqoop = new Sqoop(tool, pluginConf);
        return Sqoop.runSqoop(sqoop, Arrays.copyOfRange(expandedArgs, 1, expandedArgs.length));
    }

    private static String[] convertParamsMapToAarray(Map<String, String> paramsMap, Configuration conf) throws Exception {
        ArrayList<String> paramsList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : paramsMap.entrySet()) {
            if (!StringUtils.isNotBlank((CharSequence)entry.getKey())) continue;
            String key = entry.getKey().toLowerCase();
            if (key.equals(SqoopParamsConfiguration.SQOOP_PARAM_MODE().getValue())) {
                paramsList.add(0, entry.getValue());
                continue;
            }
            if (key.startsWith((String)SqoopParamsConfiguration.SQOOP_PARAM_ENV_PREFIX().getValue())) {
                key = key.substring(((String)SqoopParamsConfiguration.SQOOP_PARAM_ENV_PREFIX().getValue()).length());
                conf.set(key, entry.getValue());
                continue;
            }
            String conKey = ParamsMapping.mapping.get(key);
            if (conKey != null) {
                if (entry.getValue() != null && entry.getValue().length() != 0) {
                    paramsList.add(conKey);
                    paramsList.add(entry.getValue());
                    continue;
                }
                paramsList.add(conKey);
                continue;
            }
            LOG.warn((Object)("The Key " + entry.getKey() + " Is Not Supported"));
        }
        return paramsList.toArray(new String[0]);
    }

    public static int runTool(Map<String, String> params) {
        Configuration conf = new Configuration();
        try {
            for (String fileName : ((String)SqoopEnvConfiguration.SQOOP_HADOOP_SITE_FILE().getValue()).split(";")) {
                File resourceFile = Paths.get(fileName, new String[0]).toFile();
                if (!resourceFile.exists()) continue;
                LOG.info((Object)("Append resource: [" + resourceFile.getPath() + "] to configuration"));
                conf.addResource(resourceFile.toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            System.exit(1);
        }
        return Sqoop.runTool(params, conf);
    }

    public static int main(Map<String, String> code) {
        return Sqoop.runTool(code);
    }

    public static void close() throws JobClosableException {
        block8: {
            Job runnableJob = job.get();
            try {
                if (Objects.nonNull(runnableJob)) {
                    runnableJob.killJob();
                }
                if (sqlManager != null && sqlManager.getConnection() != null) {
                    sqlManager.getConnection().close();
                }
            }
            catch (IllegalStateException se) {
                if (Sqoop.isJobReady(runnableJob)) {
                    LOG.warn((Object)"Unable to close the mapReduce job, it seems that the job isn't connected to the cluster");
                }
                if (!Objects.nonNull(runnableJob)) break block8;
                String cluster = "UNKNOWN";
                try {
                    cluster = runnableJob.getCluster().getFileSystem().getCanonicalServiceName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new JobClosableException(SqoopErrorCodeSummary.UNABLE_TO_CLOSE.getErrorDesc() + "[" + cluster + "]", se);
            }
            catch (IOException | SQLException e) {
                throw new JobClosableException(SqoopErrorCodeSummary.ERROR_IN_CLOSING.getErrorDesc(), e);
            }
        }
    }

    public static String getApplicationId() {
        String applicationId = "";
        try {
            JobID jobId;
            Job runnableJob = job.get();
            if (Objects.nonNull(runnableJob) && Objects.nonNull(jobId = runnableJob.getJobID())) {
                applicationId = jobId.toString();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"GetApplicationId in sqoop Error", (Throwable)e);
        }
        return applicationId;
    }

    public static String getApplicationURL() {
        String applicationUrl = "";
        Job runnableJob = job.get();
        try {
            if (Objects.nonNull(runnableJob)) {
                return runnableJob.getTrackingURL();
            }
        }
        catch (Exception e) {
            if (e instanceof IllegalStateException && !Sqoop.isJobReady(runnableJob)) {
                LOG.trace((Object)"The mapReduce job is not ready, wait for the job status to be Running");
            }
            LOG.error((Object)"GetApplicationURL in sqoop Error", (Throwable)e);
        }
        return applicationUrl;
    }

    public static Float progress() {
        Job runnableJob = job.get();
        try {
            if (Objects.nonNull(runnableJob)) {
                progress = Float.valueOf((runnableJob.mapProgress() + runnableJob.reduceProgress()) / 2.0f);
            }
        }
        catch (Exception e) {
            if (e instanceof IllegalStateException && !Sqoop.isJobReady(runnableJob)) {
                LOG.trace((Object)"The mapReduce job is not ready, the value of progress is 0.0 always");
            }
            LOG.error((Object)"Get progress in sqoop Error", (Throwable)e);
        }
        return progress;
    }

    public static JobProgressInfo getProgressInfo() {
        Job runnableJob = job.get();
        try {
            if (Objects.nonNull(runnableJob)) {
                TaskType[] analyzeTypes;
                AtomicInteger totalTasks = new AtomicInteger();
                AtomicInteger failedTasks = new AtomicInteger();
                AtomicInteger runTasks = new AtomicInteger();
                AtomicInteger successTasks = new AtomicInteger();
                for (TaskType taskType : analyzeTypes = new TaskType[]{TaskType.MAP, TaskType.REDUCE}) {
                    TaskReport[] taskReports = runnableJob.getTaskReports(taskType);
                    Optional.ofNullable(taskReports).ifPresent(reports -> {
                        totalTasks.addAndGet(((TaskReport[])reports).length);
                        block5: for (TaskReport report : reports) {
                            TIPStatus tipStatus = report.getCurrentStatus();
                            switch (tipStatus) {
                                case FAILED: 
                                case KILLED: {
                                    failedTasks.getAndIncrement();
                                    continue block5;
                                }
                                case PENDING: 
                                case RUNNING: {
                                    runTasks.getAndIncrement();
                                    continue block5;
                                }
                                case COMPLETE: {
                                    successTasks.getAndIncrement();
                                    continue block5;
                                }
                            }
                        }
                    });
                }
                return new JobProgressInfo(Sqoop.getApplicationId(), totalTasks.get(), runTasks.get(), failedTasks.get(), successTasks.get());
            }
        }
        catch (Exception e) {
            if (e instanceof IllegalStateException && !Sqoop.isJobReady(runnableJob)) {
                LOG.trace((Object)"The mapReduce job is not ready, the value of progressInfo is always empty");
            }
            LOG.error((Object)"Get progress info in sqoop Error", (Throwable)e);
        }
        return new JobProgressInfo(Sqoop.getApplicationId(), 0, 0, 0, 0);
    }

    public static Map<String, Object> getMetrics() {
        Job runnableJob = job.get();
        HashMap<String, Object> metricsMap = new HashMap<String, Object>();
        try {
            if (Objects.nonNull(runnableJob)) {
                Counters counters = runnableJob.getCounters();
                counters.forEach(group -> metricsMap.computeIfAbsent(group.getName(), groupName -> {
                    HashMap map = new HashMap();
                    group.forEach(counter -> map.put(counter.getName(), counter.getValue()));
                    return map;
                }));
                long startTime = runnableJob.getStartTime();
                long endTime = runnableJob.getFinishTime() > 0L ? runnableJob.getFinishTime() : System.currentTimeMillis();
                metricsMap.put(METRICS_RUN_TIME, startTime > 0L ? endTime - startTime : 0L);
            }
        }
        catch (Exception e) {
            if (e instanceof IllegalStateException && !Sqoop.isJobReady(runnableJob)) {
                LOG.trace((Object)"The mapReduce job is not ready, the value of metricsMap is always empty");
            }
            LOG.error((Object)"Get metrics info in sqoop Error", (Throwable)e);
        }
        return metricsMap;
    }

    public static Map<String, Object> getDiagnosis() {
        Job runnableJob = job.get();
        HashMap<String, Object> diagnosis = new HashMap<String, Object>();
        try {
            if (Objects.nonNull(runnableJob)) {
                TaskType[] analyzeTypes = new TaskType[]{TaskType.MAP, TaskType.REDUCE};
                ArrayList<TaskReport> listReports = new ArrayList<TaskReport>();
                for (TaskType taskType : analyzeTypes) {
                    listReports.addAll(Arrays.asList(runnableJob.getTaskReports(taskType)));
                }
                listReports.forEach(report -> diagnosis.put(report.getTaskId(), report.getDiagnostics()));
            }
        }
        catch (Exception e) {
            if (e instanceof IllegalStateException && !Sqoop.isJobReady(runnableJob)) {
                LOG.trace((Object)"The mapReduce job is not ready, the value of diagnosis is always empty");
            }
            LOG.error((Object)"Get diagnosis info in sqoop Error", (Throwable)e);
        }
        return diagnosis;
    }

    private static boolean isJobReady(Job runnableJob) {
        boolean ready = false;
        try {
            Field stateField = Job.class.getDeclaredField("state");
            stateField.setAccessible(true);
            Job.JobState state = (Job.JobState)stateField.get(runnableJob);
            ready = state.equals((Object)Job.JobState.RUNNING);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return ready;
    }

    static {
        DEFAULT_FACTORY_CLASS_NAMES_ARR = new String[]{OraOopManagerFactory.class.getName(), DefaultManagerFactory.class.getName()};
        progress = Float.valueOf(0.0f);
        Configuration.addDefaultResource((String)"sqoop-site.xml");
    }
}

