/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.sqoop.client;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.engineconn.computation.executor.utlis.JarLoader;
import org.apache.linkis.protocol.engine.JobProgressInfo;
import org.apache.sqoop.SqoopOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkisSqoopClient {
    private static Class<?> sqoopEngineClass;
    private static Logger logger;
    private static JarLoader jarLoader;

    public static int run(Map<String, String> params) {
        try {
            jarLoader = new JarLoader(new String[]{LinkisSqoopClient.class.getProtectionDomain().getCodeSource().getLocation().getPath()});
            jarLoader.loadClass("org.apache.sqoop.mapreduce.JobBase", false);
            jarLoader.addJarURL(SqoopOptions.class.getProtectionDomain().getCodeSource().getLocation().getPath());
            Thread.currentThread().setContextClassLoader((ClassLoader)jarLoader);
            sqoopEngineClass = jarLoader.loadClass("org.apache.linkis.engineconnplugin.sqoop.client.Sqoop");
            Method method = sqoopEngineClass.getDeclaredMethod("main", Map.class);
            return (Integer)method.invoke(null, params);
        }
        catch (Throwable e) {
            logger.error("Run Error Message:" + LinkisSqoopClient.getLog(e), e);
            return -1;
        }
    }

    public static void close() {
        LinkisSqoopClient.operateInClassLoader((ClassLoader)jarLoader, () -> {
            Method method = sqoopEngineClass.getDeclaredMethod("close", new Class[0]);
            method.invoke(null, new Object[0]);
            return null;
        }, e -> logger.error("Close Error Message: {}", (Object)LinkisSqoopClient.getLog(e)));
    }

    public static String getApplicationId() {
        return LinkisSqoopClient.operateInClassLoader((ClassLoader)jarLoader, () -> {
            Method method = sqoopEngineClass.getDeclaredMethod("getApplicationId", new Class[0]);
            return (String)method.invoke(null, new Object[0]);
        }, e -> logger.error("Linkis SqoopClient getApplicationId: {}", (Object)LinkisSqoopClient.getLog(e)));
    }

    public static String getApplicationURL() {
        return LinkisSqoopClient.operateInClassLoader((ClassLoader)jarLoader, () -> {
            Method method = sqoopEngineClass.getDeclaredMethod("getApplicationURL", new Class[0]);
            return (String)method.invoke(null, new Object[0]);
        }, e -> logger.error("Linkis SqoopClient getApplicationURL: {}", (Object)LinkisSqoopClient.getLog(e)));
    }

    public static Float progress() {
        return LinkisSqoopClient.operateInClassLoader((ClassLoader)jarLoader, () -> {
            Method method = sqoopEngineClass.getDeclaredMethod("progress", new Class[0]);
            return (Float)method.invoke(null, new Object[0]);
        }, e -> logger.error("Linkis SqoopClient progress: {}", (Object)LinkisSqoopClient.getLog(e)));
    }

    public static JobProgressInfo getProgressInfo() {
        return LinkisSqoopClient.operateInClassLoader((ClassLoader)jarLoader, () -> {
            Method method = sqoopEngineClass.getDeclaredMethod("getProgressInfo", new Class[0]);
            return (JobProgressInfo)method.invoke(null, new Object[0]);
        }, e -> logger.error("Linkis SqoopClient getProgressInfo: {}", (Object)LinkisSqoopClient.getLog(e)));
    }

    public static Map<String, Object> getMetrics() {
        return LinkisSqoopClient.operateInClassLoader((ClassLoader)jarLoader, () -> {
            Method method = sqoopEngineClass.getDeclaredMethod("getMetrics", new Class[0]);
            return (Map)method.invoke(null, new Object[0]);
        }, e -> logger.error("Linkis SqoopClient getMetrics: {}", (Object)LinkisSqoopClient.getLog(e)));
    }

    public static Map<String, Object> getDiagnosis() {
        return LinkisSqoopClient.operateInClassLoader((ClassLoader)jarLoader, () -> {
            Method method = sqoopEngineClass.getDeclaredMethod("getDiagnosis", new Class[0]);
            return (Map)method.invoke(null, new Object[0]);
        }, e -> logger.error("Linkis SqoopClient getDiagnosis: {}", (Object)LinkisSqoopClient.getLog(e)));
    }

    private static String getLog(Throwable e) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        e.printStackTrace(printWriter);
        return e.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <R> R operateInClassLoader(ClassLoader classLoader, ClientOperation<R> operation, Consumer<Throwable> resolver) {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        R result = null;
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            result = operation.operate();
        }
        catch (Exception t) {
            resolver.accept(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
        return result;
    }

    static {
        logger = LoggerFactory.getLogger(LinkisSqoopClient.class);
    }

    @FunctionalInterface
    static interface ClientOperation<T> {
        public T operate() throws ErrorException, NoSuchMethodException, InvocationTargetException, IllegalAccessException;
    }
}

