/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.repl.executor.javarepl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.apache.commons.lang3.StringUtils;

public class JavaReplBuilder {
    private String className;
    private String superClassName = "java.lang.Object";
    private final List<String> imports = new ArrayList<String>();
    private final Map<String, String> fullNames = new HashMap<String, String>();
    private final List<String> ifaces = new ArrayList<String>();
    private final List<String> constructors = new ArrayList<String>();
    private final List<String> fields = new ArrayList<String>();
    private final List<String> methods = new ArrayList<String>();

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public void setSuperClassName(String superClassName) {
        this.superClassName = this.getQualifiedClassName(superClassName);
    }

    public List<String> getImports() {
        return this.imports;
    }

    public void addImports(String pkg) {
        int pi = pkg.lastIndexOf(46);
        if (pi > 0) {
            String pkgName = pkg.substring(0, pi);
            this.imports.add(pkgName);
            if (!pkg.endsWith(".*")) {
                this.fullNames.put(pkg.substring(pi + 1), pkg);
            }
        }
    }

    public List<String> getInterfaces() {
        return this.ifaces;
    }

    public void addInterface(String iface) {
        this.ifaces.add(this.getQualifiedClassName(iface));
    }

    public List<String> getConstructors() {
        return this.constructors;
    }

    public void addConstructor(String constructor) {
        this.constructors.add(constructor);
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void addField(String field) {
        this.fields.add(field);
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public void addMethod(String method) {
        this.methods.add(method);
    }

    protected String getQualifiedClassName(String className) {
        if (className.contains(".")) {
            return className;
        }
        if (this.fullNames.containsKey(className)) {
            return this.fullNames.get(className);
        }
        return JavaReplBuilder.forName(this.imports.toArray(new String[0]), className).getName();
    }

    public CtClass build(ClassLoader classLoader) throws NotFoundException, CannotCompileException {
        ClassPool pool = new ClassPool(true);
        pool.insertClassPath((ClassPath)new LoaderClassPath(classLoader));
        CtClass ctClass = null;
        ctClass = StringUtils.isNotBlank((CharSequence)this.superClassName) ? pool.makeClass(this.className, pool.get(this.superClassName)) : pool.makeClass(this.className);
        this.imports.forEach(arg_0 -> ((ClassPool)pool).importPackage(arg_0));
        for (String iface : this.ifaces) {
            ctClass.addInterface(pool.get(iface));
        }
        for (String constructor : this.constructors) {
            ctClass.addConstructor(CtNewConstructor.make((String)constructor, (CtClass)ctClass));
        }
        for (String field : this.fields) {
            ctClass.addField(CtField.make((String)field, (CtClass)ctClass));
        }
        for (String method : this.methods) {
            ctClass.addMethod(CtNewMethod.make((String)method, (CtClass)ctClass));
        }
        return ctClass;
    }

    public static Class<?> forName(String[] packages, String className) {
        try {
            return JavaReplBuilder.classForName(className);
        }
        catch (ClassNotFoundException e) {
            if (packages != null && packages.length > 0) {
                for (String pkg : packages) {
                    try {
                        return JavaReplBuilder.classForName(pkg + "." + className);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
            }
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static Class<?> classForName(String className) throws ClassNotFoundException {
        switch (className) {
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "boolean[]": {
                return boolean[].class;
            }
            case "byte[]": {
                return byte[].class;
            }
            case "char[]": {
                return char[].class;
            }
            case "short[]": {
                return short[].class;
            }
            case "int[]": {
                return int[].class;
            }
            case "long[]": {
                return long[].class;
            }
            case "float[]": {
                return float[].class;
            }
            case "double[]": {
                return double[].class;
            }
        }
        try {
            return JavaReplBuilder.arrayForName(className);
        }
        catch (ClassNotFoundException e) {
            if (className.indexOf(46) == -1) {
                try {
                    return JavaReplBuilder.arrayForName("java.lang." + className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    private static Class<?> arrayForName(String className) throws ClassNotFoundException {
        return Class.forName(className.endsWith("[]") ? "[L" + className.substring(0, className.length() - 2) + ";" : className, true, Thread.currentThread().getContextClassLoader());
    }
}

