/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.jdbc.monitor;

import com.alibaba.druid.pool.DruidPooledStatement;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.protocol.engine.JobProgressInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProgressMonitor<T>
implements Consumer<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ProgressMonitor.class);
    private static final Map<String, String> MONITORS = new ConcurrentHashMap<String, String>();

    public static void register(String statementClassName, String monitorClassName) {
        MONITORS.put(statementClassName, monitorClassName);
    }

    public static ProgressMonitor<?> attachMonitor(Statement statement) {
        ProgressMonitor progressMonitor = null;
        if (statement instanceof DruidPooledStatement) {
            statement = ((DruidPooledStatement)statement).getStatement();
        }
        try {
            String monitorName = MONITORS.get(statement.getClass().getName());
            if (StringUtils.isNotBlank((CharSequence)monitorName)) {
                progressMonitor = (ProgressMonitor)Class.forName(monitorName).newInstance();
            }
            if (progressMonitor != null) {
                progressMonitor.attach(statement);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to create monitor for statement: {}, exception: {} - {}", new Object[]{statement, e.getClass().getName(), e.getMessage()});
        }
        return progressMonitor;
    }

    public abstract void attach(Statement var1);

    public abstract void callback(Runnable var1);

    public abstract float getSqlProgress();

    public abstract int getSucceedTasks();

    public abstract int getTotalTasks();

    public abstract int getRunningTasks();

    public abstract int getFailedTasks();

    public abstract JobProgressInfo jobProgressInfo(String var1);

    static {
        ProgressMonitor.register("io.trino.jdbc.TrinoStatement", "org.apache.linkis.manager.engineplugin.jdbc.monitor.impl.TrinoProgressMonitor");
    }
}

