/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.elasticsearch.executor.client;

import java.io.IOException;
import org.apache.linkis.engineplugin.elasticsearch.executor.client.EsClientOperate;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.sniff.Sniffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EsClient
implements EsClientOperate {
    private static final Logger logger = LoggerFactory.getLogger(EsClient.class);
    private String datasourceName;
    public RestClient client;
    private Sniffer sniffer;

    public EsClient(String datasourceName, RestClient client, Sniffer sniffer) {
        this.datasourceName = datasourceName;
        this.client = client;
        this.sniffer = sniffer;
    }

    public String getDatasourceName() {
        return this.datasourceName;
    }

    public RestClient getRestClient() {
        return this.client;
    }

    public Sniffer getSniffer() {
        return this.sniffer;
    }

    @Override
    public void close() {
        if (this.sniffer != null) {
            this.sniffer.close();
        }
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException e) {
                logger.warn("RestClient close warn");
            }
        }
    }
}

