/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.elasticsearch;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.linkis.engineplugin.elasticsearch.builder.ElasticSearchProcessEngineConnLaunchBuilder;
import org.apache.linkis.engineplugin.elasticsearch.conf.ElasticSearchConfiguration;
import org.apache.linkis.engineplugin.elasticsearch.factory.ElasticSearchEngineConnFactory;
import org.apache.linkis.manager.engineplugin.common.EngineConnPlugin;
import org.apache.linkis.manager.engineplugin.common.creation.EngineConnFactory;
import org.apache.linkis.manager.engineplugin.common.launch.EngineConnLaunchBuilder;
import org.apache.linkis.manager.engineplugin.common.resource.EngineResourceFactory;
import org.apache.linkis.manager.engineplugin.common.resource.GenericEngineResourceFactory;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.engine.EngineType;
import org.apache.linkis.manager.label.entity.engine.EngineTypeLabel;

public class ElasticSearchEngineConnPlugin
implements EngineConnPlugin {
    private EngineResourceFactory engineResourceFactory;
    private EngineConnFactory engineFactory;
    private List<Label<?>> defaultLabels = new ArrayList();
    private Object resourceLocker = new Object();
    private Object engineFactoryLocker = new Object();

    public void init(Map<String, Object> params) {
        EngineTypeLabel typeLabel = new EngineTypeLabel();
        typeLabel.setEngineType(EngineType.ELASTICSEARCH().toString());
        typeLabel.setVersion((String)ElasticSearchConfiguration.DEFAULT_VERSION.getValue());
        this.defaultLabels.add((Label<?>)typeLabel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EngineResourceFactory getEngineResourceFactory() {
        if (this.engineResourceFactory == null) {
            Object object = this.resourceLocker;
            synchronized (object) {
                if (this.engineResourceFactory == null) {
                    this.engineResourceFactory = new GenericEngineResourceFactory();
                }
            }
        }
        return this.engineResourceFactory;
    }

    public EngineConnLaunchBuilder getEngineConnLaunchBuilder() {
        return new ElasticSearchProcessEngineConnLaunchBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EngineConnFactory getEngineConnFactory() {
        if (this.engineFactory == null) {
            Object object = this.engineFactoryLocker;
            synchronized (object) {
                if (this.engineFactory == null) {
                    this.engineFactory = new ElasticSearchEngineConnFactory();
                }
            }
        }
        return this.engineFactory;
    }

    public List<Label<?>> getDefaultLabels() {
        return this.defaultLabels;
    }
}

