/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.runtime.client.JobStatusMessage;
import org.apache.flink.yarn.configuration.YarnConfigOptions;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.engineconn.core.executor.ExecutorManager$;
import org.apache.linkis.engineconn.executor.entity.Executor;
import org.apache.linkis.engineconn.executor.entity.YarnExecutor;
import org.apache.linkis.engineconnplugin.flink.client.config.FlinkVersionThreadLocal;
import org.apache.linkis.engineconnplugin.flink.client.shims.FlinkShims;
import org.apache.linkis.engineconnplugin.flink.client.shims.exception.JobExecutionException;
import org.apache.linkis.engineconnplugin.flink.config.FlinkEnvConfiguration$;
import org.apache.linkis.governance.common.conf.GovernanceCommonConf$;
import org.apache.linkis.governance.common.constant.ec.ECConstants$;
import org.apache.linkis.manager.common.entity.enumeration.NodeStatus;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class YarnUtil$
implements Logging {
    public static YarnUtil$ MODULE$;
    private final String CORE_SITE;
    private final String YARN_SITE;
    private final String HDFS_SITE;
    private final String MAPRED_SITE;
    private YarnClient yarnClient;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new YarnUtil$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        YarnUtil$ yarnUtil$ = this;
        synchronized (yarnUtil$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String CORE_SITE() {
        return this.CORE_SITE;
    }

    public String YARN_SITE() {
        return this.YARN_SITE;
    }

    public String HDFS_SITE() {
        return this.HDFS_SITE;
    }

    public String MAPRED_SITE() {
        return this.MAPRED_SITE;
    }

    private YarnClient yarnClient() {
        return this.yarnClient;
    }

    private void yarnClient_$eq(YarnClient x$1) {
        this.yarnClient = x$1;
    }

    public YarnClient getYarnClient() {
        if (this.yarnClient() == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (this.yarnClient() == null) {
                    this.yarnClient_$eq(this.createYarnClient());
                }
            }
        }
        return this.yarnClient();
    }

    private YarnClient createYarnClient() {
        YarnClient yarnClient = YarnClient.createYarnClient();
        org.apache.hadoop.conf.Configuration hadoopConf = this.getHadoopConf();
        YarnConfiguration yarnConfiguration = new YarnConfiguration(hadoopConf);
        yarnClient.init((org.apache.hadoop.conf.Configuration)yarnConfiguration);
        yarnClient.start();
        return yarnClient;
    }

    private org.apache.hadoop.conf.Configuration getHadoopConf() {
        org.apache.hadoop.conf.Configuration conf = new org.apache.hadoop.conf.Configuration();
        String confRoot = (String)FlinkEnvConfiguration$.MODULE$.HADOOP_CONF_DIR().getValue();
        if (StringUtils.isBlank((CharSequence)confRoot)) {
            throw new JobExecutionException("HADOOP_CONF_DIR or linkis.flink.hadoop.conf.dir not set!");
        }
        confRoot = new StringBuilder(1).append(confRoot).append("/").toString();
        conf.addResource(new StringBuilder(0).append(confRoot).append(this.HDFS_SITE()).toString());
        conf.addResource(new StringBuilder(0).append(confRoot).append(this.CORE_SITE()).toString());
        conf.addResource(new StringBuilder(0).append(confRoot).append(this.MAPRED_SITE()).toString());
        conf.addResource(new StringBuilder(0).append(confRoot).append(this.YARN_SITE()).toString());
        return conf;
    }

    public void setClusterEntrypointInfoToConfig(Configuration flinkConfiguration, ApplicationReport appReport) {
        if (appReport == null) {
            String msg = "Invalid null appReport";
            this.logger().error(msg);
            throw new JobExecutionException(msg);
        }
        ApplicationId appId = appReport.getApplicationId();
        String host = appReport.getHost();
        int port = appReport.getRpcPort();
        this.logger().info(new StringBuilder(40).append("Found Web Interface ").append(host).append(":").append(port).append(" of application '").append(appId).append("'.").toString());
        flinkConfiguration.setString(JobManagerOptions.ADDRESS, host);
        flinkConfiguration.setInteger(JobManagerOptions.PORT, port);
        flinkConfiguration.setString(RestOptions.ADDRESS, host);
        flinkConfiguration.setInteger(RestOptions.PORT, port);
        flinkConfiguration.set(YarnConfigOptions.APPLICATION_ID, (Object)ConverterUtils.toString((ApplicationId)appId));
        if (!flinkConfiguration.contains(HighAvailabilityOptions.HA_CLUSTER_ID)) {
            flinkConfiguration.set(HighAvailabilityOptions.HA_CLUSTER_ID, (Object)ConverterUtils.toString((ApplicationId)appId));
            return;
        }
    }

    public ErrorException logAndException(String msg, Throwable t) {
        this.logger().error(msg, t);
        return new JobExecutionException(msg);
    }

    public Throwable logAndException$default$2() {
        return null;
    }

    public ApplicationId retrieveApplicationId(String appIdStr) {
        String[] parts = appIdStr.split("_");
        long clusterTimestamp = new StringOps(Predef$.MODULE$.augmentString(parts[1])).toLong();
        int sequenceNumber = new StringOps(Predef$.MODULE$.augmentString(parts[2])).toInt();
        ApplicationId appId = ApplicationId.newInstance((long)clusterTimestamp, (int)sequenceNumber);
        return appId;
    }

    public String triggerSavepoint(String appIdStr, String checkPointPath, RestClusterClient<ApplicationId> restClient) {
        Collection jobs = (Collection)restClient.listJobs().get();
        if (jobs == null || jobs.size() > 1) {
            int size = jobs == null ? 0 : jobs.size();
            String msg = new StringBuilder(38).append("App : ").append(appIdStr).append(" have ").append(size).append(" jobs, cannot do snapshot.").toString();
            throw this.logAndException(msg, this.logAndException$default$2());
        }
        if (StringUtils.isBlank((CharSequence)checkPointPath)) {
            String msg = new StringBuilder(52).append("App : ").append(appIdStr).append(" checkpoint path is null, cannot do checkpoint").toString();
            throw this.logAndException(msg, this.logAndException$default$2());
        }
        JobStatusMessage firstJob = (JobStatusMessage)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(jobs).asScala()).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> null);
        if (firstJob == null) {
            String msg = new StringBuilder(56).append("App : ").append(appIdStr).append(" got no head job, cannot do checkPoint and cancel.").toString();
            throw new JobExecutionException(msg);
        }
        String rs = (String)FlinkShims.getInstance((String)FlinkVersionThreadLocal.getFlinkVersion()).triggerSavepoint(restClient, (Object)firstJob.getJobId(), checkPointPath).get();
        return rs;
    }

    /*
     * Enabled aggressive block sorting
     */
    public NodeStatus convertYarnStateToNodeStatus(String appIdStr, String appStatus) {
        NodeStatus nodeStatus;
        String string = appStatus;
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])FinalApplicationStatus.values())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).contains((Object)string)) {
            FinalApplicationStatus finalApplicationStatus = FinalApplicationStatus.valueOf((String)string);
            if (FinalApplicationStatus.KILLED.equals(finalApplicationStatus) ? true : FinalApplicationStatus.FAILED.equals(finalApplicationStatus)) {
                nodeStatus = NodeStatus.Failed;
                return nodeStatus;
            }
            if (FinalApplicationStatus.SUCCEEDED.equals(finalApplicationStatus)) {
                nodeStatus = NodeStatus.Success;
                return nodeStatus;
            } else {
                String msg = appStatus != null ? new StringBuilder(35).append("Application : ").append(appIdStr).append(" has unknown state : ").append(appStatus.toString()).toString() : new StringBuilder(29).append("Application : ").append(appIdStr).append(" has null state").toString();
                throw new JobExecutionException(msg);
            }
        }
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])YarnApplicationState.values())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).contains((Object)string)) {
            YarnApplicationState yarnApplicationState = YarnApplicationState.valueOf((String)string);
            if (YarnApplicationState.FINISHED.equals(yarnApplicationState)) {
                String msg = "Invalid yarn app state : FINISHED";
                throw new JobExecutionException(msg);
            }
            nodeStatus = (YarnApplicationState.KILLED.equals(yarnApplicationState) ? true : YarnApplicationState.FAILED.equals(yarnApplicationState)) ? NodeStatus.Failed : NodeStatus.Running;
            return nodeStatus;
        } else {
            String msg = appStatus != null ? new StringBuilder(35).append("Application : ").append(appIdStr).append(" has unknown state : ").append(appStatus.toString()).toString() : new StringBuilder(29).append("Application : ").append(appIdStr).append(" has null state").toString();
            throw new JobExecutionException(msg);
        }
    }

    public boolean isDetach(Map<String, Object> params) {
        Object managerOn = params.getOrDefault(FlinkEnvConfiguration$.MODULE$.FLINK_MANAGER_MODE_CONFIG_KEY().key(), FlinkEnvConfiguration$.MODULE$.FLINK_MANAGER_MODE_CONFIG_KEY().getValue());
        if (managerOn != null && new StringOps(Predef$.MODULE$.augmentString(managerOn.toString())).toBoolean()) {
            return true;
        }
        String clientType = params.getOrDefault(GovernanceCommonConf$.MODULE$.EC_APP_MANAGE_MODE().key(), GovernanceCommonConf$.MODULE$.EC_APP_MANAGE_MODE().getValue()).toString();
        this.logger().info(new StringBuilder(13).append("clientType : ").append(clientType).toString());
        String string = clientType.toLowerCase();
        String string2 = ECConstants$.MODULE$.EC_CLIENT_TYPE_DETACH();
        String string3 = string;
        return !(string2 != null ? !string2.equals(string3) : string3 != null);
    }

    public String[] getAppIds() {
        ArrayBuffer ids;
        block0: {
            ids = new ArrayBuffer();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ExecutorManager$.MODULE$.getInstance().getExecutors())).foreach((Function1 & Serializable & scala.Serializable)executor -> {
                YarnUtil$.$anonfun$getAppIds$1(ids, executor);
                return BoxedUnit.UNIT;
            });
            if (ids.size() <= 1) break block0;
            this.logger().error(new StringBuilder(73).append("There are more than one yarn application running, please check it. Ids : ").append(ids.mkString(",")).toString());
        }
        return (String[])ids.toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public static final /* synthetic */ void $anonfun$getAppIds$1(ArrayBuffer ids$1, Executor executor) {
        Executor executor2 = executor;
        if (executor2 instanceof YarnExecutor) {
            YarnExecutor yarnExecutor = (YarnExecutor)executor2;
            ids$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{yarnExecutor.getApplicationId()}));
            return;
        }
    }

    private YarnUtil$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.CORE_SITE = "core-site.xml";
        this.YARN_SITE = "yarn-site.xml";
        this.HDFS_SITE = "hdfs-site.xml";
        this.MAPRED_SITE = "mapred-site.xml";
    }
}

