/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.setting;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.yarn.configuration.YarnConfigOptions;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.linkis.common.conf.CommonVars$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.engineconn.common.creation.EngineCreationContext;
import org.apache.linkis.engineconnplugin.flink.client.shims.errorcode.FlinkErrorCodeSummary;
import org.apache.linkis.engineconnplugin.flink.client.shims.exception.FlinkInitFailedException;
import org.apache.linkis.engineconnplugin.flink.context.EnvironmentContext;
import org.apache.linkis.engineconnplugin.flink.context.FlinkEngineConnContext;
import org.apache.linkis.engineconnplugin.flink.setting.HudiSettings$;
import org.apache.linkis.engineconnplugin.flink.setting.Settings;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001B\t\u0013\u0001}AQA\r\u0001\u0005\u0002MBQ!\u000e\u0001\u0005\nYBQA\u0016\u0001\u0005B]CQA\u001b\u0001\u0005B-<Q!\u001d\n\t\u0002I4Q!\u0005\n\t\u0002MDQA\r\u0004\u0005\u0002QDq!\u001e\u0004C\u0002\u0013%a\u000f\u0003\u0004\u007f\r\u0001\u0006Ia\u001e\u0005\b\u007f\u001a\u0011\r\u0011\"\u0003w\u0011\u001d\t\tA\u0002Q\u0001\n]D\u0011\"a\u0001\u0007\u0005\u0004%I!!\u0002\t\u0011\u0005ea\u0001)A\u0005\u0003\u000fA\u0011\"a\u0007\u0007\u0005\u0004%I!!\b\t\u0011\u0005\u0005b\u0001)A\u0005\u0003?Aq!a\t\u0007\t\u0013\t)C\u0001\u0007Ik\u0012L7+\u001a;uS:<7O\u0003\u0002\u0014)\u000591/\u001a;uS:<'BA\u000b\u0017\u0003\u00151G.\u001b8l\u0015\t9\u0002$\u0001\tf]\u001eLg.Z2p]:\u0004H.^4j]*\u0011\u0011DG\u0001\u0007Y&t7.[:\u000b\u0005ma\u0012AB1qC\u000eDWMC\u0001\u001e\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0001E\n\u0016\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\r\u0005s\u0017PU3g!\t9\u0003&D\u0001\u0013\u0013\tI#C\u0001\u0005TKR$\u0018N\\4t!\tY\u0003'D\u0001-\u0015\tic&A\u0003vi&d7O\u0003\u000201\u000511m\\7n_:L!!\r\u0017\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012\u0001\u000e\t\u0003O\u0001\t\u0001c]3u\u000bb$(/Y*fiRLgnZ:\u0015\t]Rt*\u0015\t\u0003CaJ!!\u000f\u0012\u0003\tUs\u0017\u000e\u001e\u0005\u0006w\t\u0001\r\u0001P\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\b\u0003B\u001fC\t\u0012k\u0011A\u0010\u0006\u0003\u007f\u0001\u000bq!\\;uC\ndWM\u0003\u0002BE\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\rs$aA'baB\u0011Q\t\u0014\b\u0003\r*\u0003\"a\u0012\u0012\u000e\u0003!S!!\u0013\u0010\u0002\rq\u0012xn\u001c;?\u0013\tY%%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001b:\u0013aa\u0015;sS:<'BA&#\u0011\u0015\u0001&\u00011\u0001E\u0003\u0019\u0001(/\u001a4jq\")!K\u0001a\u0001'\u0006\u00191/\u001a;\u0011\u000b\u0005\"F\tR\u001c\n\u0005U\u0013#!\u0003$v]\u000e$\u0018n\u001c83\u0003U\u0019X\r^#om&\u0014xN\\7f]R\u001cuN\u001c;fqR$2a\u000e-d\u0011\u0015I6\u00011\u0001[\u0003U)gnZ5oK\u000e\u0013X-\u0019;j_:\u001cuN\u001c;fqR\u0004\"aW1\u000e\u0003qS!!\u00180\u0002\u0011\r\u0014X-\u0019;j_:T!aL0\u000b\u0005\u0001D\u0012AC3oO&tWmY8o]&\u0011!\r\u0018\u0002\u0016\u000b:<\u0017N\\3De\u0016\fG/[8o\u0007>tG/\u001a=u\u0011\u0015!7\u00011\u0001f\u0003\u001d\u0019wN\u001c;fqR\u0004\"A\u001a5\u000e\u0003\u001dT!\u0001\u001a\u000b\n\u0005%<'AE#om&\u0014xN\\7f]R\u001cuN\u001c;fqR\f1c]3u\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR$2a\u000e7n\u0011\u0015IF\u00011\u0001[\u0011\u0015!G\u00011\u0001o!\t1w.\u0003\u0002qO\n1b\t\\5oW\u0016sw-\u001b8f\u0007>tgnQ8oi\u0016DH/\u0001\u0007Ik\u0012L7+\u001a;uS:<7\u000f\u0005\u0002(\rM\u0011a\u0001\t\u000b\u0002e\u0006\tb\tT%O\u0017~CU\u000bR%`!J+e)\u0013-\u0016\u0003]\u0004\"\u0001_?\u000e\u0003eT!A_>\u0002\t1\fgn\u001a\u0006\u0002y\u0006!!.\u0019<b\u0013\ti\u00150\u0001\nG\u0019&s5j\u0018%V\t&{\u0006KU#G\u0013b\u0003\u0013!\u0005$M\u0013:[u,W!S\u001d~\u0003&+\u0012$J1\u0006\u0011b\tT%O\u0017~K\u0016I\u0015(`!J+e)\u0013-!\u0003-AU\u000bR%`\u000b:\u000b%\tT#\u0016\u0005\u0005\u001d\u0001CBA\u0005\u0003\u001f\t\u0019\"\u0004\u0002\u0002\f)\u0019\u0011Q\u0002\u0018\u0002\t\r|gNZ\u0005\u0005\u0003#\tYA\u0001\u0006D_6lwN\u001c,beN\u00042!IA\u000b\u0013\r\t9B\t\u0002\b\u0005>|G.Z1o\u00031AU\u000bR%`\u000b:\u000b%\tT#!\u0003eAU\u000bR%`\u000bb#&+Q0Z\u0003Jsul\u0011'B'N\u0003\u0016\t\u0016%\u0016\u0005\u0005}\u0001#BA\u0005\u0003\u001f9\u0018A\u0007%V\t&{V\t\u0017+S\u0003~K\u0016I\u0015(`\u00072\u000b5k\u0015)B)\"\u0003\u0013aD4fi\"+H-\u001b&beB\u000bG\u000f[:\u0015\t\u0005\u001d\u0012Q\u0006\t\u0005C\u0005%B)C\u0002\u0002,\t\u0012Q!\u0011:sCfDq!a\f\u0011\u0001\u0004\t\t$A\u0004paRLwN\\:\u0011\r\u0005M\u0012\u0011\b#E\u001b\t\t)DC\u0002\u00028m\fA!\u001e;jY&\u00191)!\u000e")
public class HudiSettings
implements Settings,
Logging {
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        HudiSettings hudiSettings = this;
        synchronized (hudiSettings) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private void setExtraSettings(Map<String, String> properties, String prefix, Function2<String, String, BoxedUnit> set) {
        ((IterableLike)properties.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HudiSettings.$anonfun$setExtraSettings$1(prefix, x$1)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HudiSettings.$anonfun$setExtraSettings$2(this, prefix, set, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void setEnvironmentContext(EngineCreationContext engineCreationContext, EnvironmentContext context) {
        Configuration configuration;
        if (!BoxesRunTime.unboxToBoolean((Object)HudiSettings$.MODULE$.org$apache$linkis$engineconnplugin$flink$setting$HudiSettings$$HUDI_ENABLE().getValue(engineCreationContext.getOptions()))) {
            return;
        }
        this.logger().info("hudi is enabled, now try to set hudi configurations...");
        List shipFiles = (List)context.getFlinkConfig().get(YarnConfigOptions.SHIP_FILES);
        ArrayList hudiJarPaths = Lists.newArrayList((Object[])HudiSettings$.MODULE$.org$apache$linkis$engineconnplugin$flink$setting$HudiSettings$$getHudiJarPaths(engineCreationContext.getOptions()));
        if (CollectionUtils.isEmpty((Collection)hudiJarPaths)) {
            throw new FlinkInitFailedException(FlinkErrorCodeSummary.HUDIJARS_NOT_EXISTS.getErrorDesc());
        }
        this.logger().info(new StringBuilder(16).append("hudi jar is in ").append(hudiJarPaths).append(".").toString());
        context.getDependencies().addAll((Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)hudiJarPaths).asScala()).map((Function1 & Serializable & scala.Serializable)path -> new File((String)path).toURI().toURL(), Buffer$.MODULE$.canBuildFrom())).asJava());
        if (CollectionUtils.isEmpty((Collection)shipFiles)) {
            configuration = context.getFlinkConfig().set(YarnConfigOptions.SHIP_FILES, (Object)hudiJarPaths);
        } else {
            ArrayList newShipFiles = new ArrayList(shipFiles);
            newShipFiles.addAll(hudiJarPaths);
            configuration = context.getFlinkConfig().set(YarnConfigOptions.SHIP_FILES, newShipFiles);
        }
        Configuration configuration2 = context.getFlinkConfig();
        this.setExtraSettings((Map<String, String>)((Map)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(CommonVars$.MODULE$.properties()).asScala()), HudiSettings$.MODULE$.org$apache$linkis$engineconnplugin$flink$setting$HudiSettings$$FLINK_HUDI_PREFIX(), (Function2<String, String, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$1, x$2) -> {
            configuration2.setString(x$1, x$2);
            return BoxedUnit.UNIT;
        });
        Configuration configuration3 = context.getFlinkConfig();
        this.setExtraSettings((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(engineCreationContext.getOptions()).asScala()), HudiSettings$.MODULE$.org$apache$linkis$engineconnplugin$flink$setting$HudiSettings$$FLINK_HUDI_PREFIX(), (Function2<String, String, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$1, x$2) -> {
            configuration3.setString(x$1, x$2);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void setExecutionContext(EngineCreationContext engineCreationContext, FlinkEngineConnContext context) {
        if (!BoxesRunTime.unboxToBoolean((Object)HudiSettings$.MODULE$.org$apache$linkis$engineconnplugin$flink$setting$HudiSettings$$HUDI_ENABLE().getValue(engineCreationContext.getOptions()))) {
            return;
        }
        YarnConfiguration configuration = context.getExecutionContext().getClusterClientFactory().getYarnConfiguration(context.getExecutionContext().getFlinkConfig());
        Buffer classpath = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])YarnConfiguration.DEFAULT_YARN_APPLICATION_CLASSPATH)).toBuffer();
        classpath.$plus$eq((Object)new StringBuilder(25).append(ApplicationConstants.Environment.HADOOP_COMMON_HOME.$()).append("/share/hadoop/mapreduce/*").toString());
        Function1 & Serializable & scala.Serializable addExtraClasspath = (Function1 & Serializable & scala.Serializable)extraClasspath -> {
            HudiSettings.$anonfun$setExecutionContext$1(classpath, extraClasspath);
            return BoxedUnit.UNIT;
        };
        addExtraClasspath.apply(HudiSettings$.MODULE$.org$apache$linkis$engineconnplugin$flink$setting$HudiSettings$$HUDI_EXTRA_YARN_CLASSPATH().getValue(engineCreationContext.getOptions()));
        addExtraClasspath.apply(HudiSettings$.MODULE$.org$apache$linkis$engineconnplugin$flink$setting$HudiSettings$$HUDI_EXTRA_YARN_CLASSPATH().getValue());
        configuration.set("yarn.application.classpath", classpath.toSet().mkString(","));
        this.logger().info(new StringBuilder(32).append("set ").append("yarn.application.classpath").append("=").append(configuration.get("yarn.application.classpath")).append(".").toString());
        this.setExtraSettings((Map<String, String>)((Map)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(CommonVars$.MODULE$.properties()).asScala()), HudiSettings$.MODULE$.org$apache$linkis$engineconnplugin$flink$setting$HudiSettings$$FLINK_YARN_PREFIX(), (Function2<String, String, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$1, x$2) -> {
            configuration.set(x$1, x$2);
            return BoxedUnit.UNIT;
        });
        this.setExtraSettings((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(engineCreationContext.getOptions()).asScala()), HudiSettings$.MODULE$.org$apache$linkis$engineconnplugin$flink$setting$HudiSettings$$FLINK_YARN_PREFIX(), (Function2<String, String, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$1, x$2) -> {
            configuration.set(x$1, x$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$setExtraSettings$1(String prefix$1, Tuple2 x$1) {
        return ((String)x$1._1()).startsWith(prefix$1);
    }

    public static final /* synthetic */ void $anonfun$setExtraSettings$2(HudiSettings $this, String prefix$1, Function2 set$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            String realKey = key.substring(prefix$1.length());
            $this.logger().info(new StringBuilder(6).append("set ").append(realKey).append("=").append(value).append(".").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)set$1.apply((Object)realKey, (Object)value);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$setExecutionContext$1(Buffer classpath$1, String extraClasspath) {
        if (StringUtils.isNotBlank((CharSequence)extraClasspath)) {
            classpath$1.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])extraClasspath.split(","))));
            return;
        }
    }

    public HudiSettings() {
        Logging.$init$((Logging)this);
    }
}

