/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.operator;

import java.text.MessageFormat;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.engineconn.launch.EngineConnServer$;
import org.apache.linkis.engineconn.once.executor.OnceExecutor;
import org.apache.linkis.engineconn.once.executor.creation.OnceExecutorManager$;
import org.apache.linkis.engineconnplugin.flink.client.deployment.ClusterDescriptorAdapter;
import org.apache.linkis.engineconnplugin.flink.constants.FlinkECConstant$;
import org.apache.linkis.engineconnplugin.flink.errorcode.FlinkErrorCodeSummary;
import org.apache.linkis.engineconnplugin.flink.exception.JobExecutionException;
import org.apache.linkis.engineconnplugin.flink.executor.FlinkOnceExecutor;
import org.apache.linkis.engineconnplugin.flink.operator.clientmanager.FlinkRestClientManager$;
import org.apache.linkis.engineconnplugin.flink.util.YarnUtil$;
import org.apache.linkis.governance.common.constant.ec.ECConstants$;
import org.apache.linkis.manager.common.operator.Operator;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u001d3A\u0001B\u0003\u0001%!)\u0011\u0006\u0001C\u0001U!)Q\u0006\u0001C!]!)Q\b\u0001C!}\tABK]5hO\u0016\u00148+\u0019<fa>Lg\u000e^(qKJ\fGo\u001c:\u000b\u0005\u00199\u0011\u0001C8qKJ\fGo\u001c:\u000b\u0005!I\u0011!\u00024mS:\\'B\u0001\u0006\f\u0003A)gnZ5oK\u000e|gN\u001c9mk\u001eLgN\u0003\u0002\r\u001b\u00051A.\u001b8lSNT!AD\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0012aA8sO\u000e\u00011\u0003\u0002\u0001\u00143\t\u0002\"\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\u0011a!\u00118z%\u00164\u0007C\u0001\u000e!\u001b\u0005Y\"B\u0001\u0004\u001d\u0015\tib$\u0001\u0004d_6lwN\u001c\u0006\u0003?-\tq!\\1oC\u001e,'/\u0003\u0002\"7\tAq\n]3sCR|'\u000f\u0005\u0002$O5\tAE\u0003\u0002&M\u0005)Q\u000f^5mg*\u0011QdC\u0005\u0003Q\u0011\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002WA\u0011A\u0006A\u0007\u0002\u000b\u0005Aq-\u001a;OC6,7/F\u00010!\r!\u0002GM\u0005\u0003cU\u0011Q!\u0011:sCf\u0004\"a\r\u001e\u000f\u0005QB\u0004CA\u001b\u0016\u001b\u00051$BA\u001c\u0012\u0003\u0019a$o\\8u}%\u0011\u0011(F\u0001\u0007!J,G-\u001a4\n\u0005mb$AB*ue&twM\u0003\u0002:+\u0005)\u0011\r\u001d9msR\u0011q(\u0012\t\u0005g\u0001\u0013$)\u0003\u0002By\t\u0019Q*\u00199\u0011\u0005Q\u0019\u0015B\u0001#\u0016\u0005\r\te.\u001f\u0005\u0006\r\u000e\u0001\u001daP\u0001\u0007a\u0006\u0014\u0018-\\:")
public class TriggerSavepointOperator
implements Operator,
Logging {
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    public <T> T getAs(String key, Function0<T> defaultVal, Map<String, Object> parameters) {
        return (T)Operator.getAs$((Operator)this, (String)key, defaultVal, parameters);
    }

    public <T> T getAsThrow(String key, Map<String, Object> parameters) {
        return (T)Operator.getAsThrow$((Operator)this, (String)key, parameters);
    }

    private Logger logger$lzycompute() {
        TriggerSavepointOperator triggerSavepointOperator = this;
        synchronized (triggerSavepointOperator) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String[] getNames() {
        return (String[])((Object[])new String[]{"doSavepoint"});
    }

    public Map<String, Object> apply(Map<String, Object> params) {
        Option option;
        HashMap rsMap = new HashMap();
        String savepointPath = (String)this.getAsThrow(FlinkECConstant$.MODULE$.SAVAPOINT_PATH_KEY(), params);
        String appIdStr = (String)this.getAsThrow(ECConstants$.MODULE$.YARN_APPID_NAME_KEY(), params);
        String mode = (String)this.getAsThrow(FlinkECConstant$.MODULE$.SAVEPOINT_MODE_KEY(), params);
        ApplicationId appId = YarnUtil$.MODULE$.retrieveApplicationId(appIdStr);
        YarnClient yarnClient = YarnUtil$.MODULE$.getYarnClient();
        ApplicationReport appReport = yarnClient.getApplicationReport(appId);
        FinalApplicationStatus finalApplicationStatus = appReport.getFinalApplicationStatus();
        FinalApplicationStatus finalApplicationStatus2 = FinalApplicationStatus.UNDEFINED;
        if (finalApplicationStatus == null ? finalApplicationStatus2 != null : !finalApplicationStatus.equals(finalApplicationStatus2)) {
            String msg = new StringBuilder(85).append("The application ").append(appIdStr).append(" doesn't run anymore. It has previously completed with final status: ").append(appReport.getFinalApplicationStatus().toString()).toString();
            throw YarnUtil$.MODULE$.logAndException(msg, YarnUtil$.MODULE$.logAndException$default$2());
        }
        this.logger().info(new StringBuilder(29).append("try to ").append(mode).append(" savepoint with path ").append(savepointPath).append(".").toString());
        if (YarnUtil$.MODULE$.isDetach(EngineConnServer$.MODULE$.getEngineCreationContext().getOptions())) {
            this.logger().info("The flink cluster is detached, use rest api to trigger savepoint.");
            RestClusterClient<ApplicationId> restClient = FlinkRestClientManager$.MODULE$.getFlinkRestClient(appIdStr);
            String rs = YarnUtil$.MODULE$.triggerSavepoint(appIdStr, savepointPath, restClient);
            option = rsMap.put((Object)FlinkECConstant$.MODULE$.RESULT_SAVEPOINT_KEY(), (Object)rs);
        } else {
            this.logger().info("The flink cluster is not detached, use flink client to trigger savepoint.");
            OnceExecutor onceExecutor = OnceExecutorManager$.MODULE$.getInstance().getReportExecutor();
            if (onceExecutor instanceof FlinkOnceExecutor) {
                FlinkOnceExecutor flinkOnceExecutor = (FlinkOnceExecutor)onceExecutor;
                String writtenSavepoint = ((ClusterDescriptorAdapter)flinkOnceExecutor.getClusterDescriptorAdapter()).doSavepoint(savepointPath, mode);
                option = rsMap.put((Object)FlinkECConstant$.MODULE$.RESULT_SAVEPOINT_KEY(), (Object)writtenSavepoint);
            } else {
                throw new JobExecutionException(new StringBuilder(0).append(FlinkErrorCodeSummary.NOT_SUPPORT_SAVEPOTION.getErrorDesc()).append(onceExecutor.getClass().getSimpleName()).append(MessageFormat.format(FlinkErrorCodeSummary.NOT_SUPPORT_SAVEPOTION.getErrorDesc(), onceExecutor.getClass().getSimpleName())).toString());
            }
        }
        return rsMap.toMap(Predef$.MODULE$.$conforms());
    }

    public TriggerSavepointOperator() {
        Operator.$init$((Operator)this);
        Logging.$init$((Logging)this);
    }
}

