/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.operator;

import java.io.Serializable;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconnplugin.flink.operator.StatusOperator$;
import org.apache.linkis.engineconnplugin.flink.util.YarnUtil$;
import org.apache.linkis.governance.common.constant.ec.ECConstants$;
import org.apache.linkis.manager.common.entity.enumeration.NodeStatus;
import org.apache.linkis.manager.common.operator.Operator;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r4A\u0001D\u0007\u00015!)\u0011\u0007\u0001C\u0001e!)Q\u0007\u0001C!m!)Q\t\u0001C!\r\u001e)q*\u0004E\u0001!\u001a)A\"\u0004E\u0001#\")\u0011'\u0002C\u0001%\"91+\u0002a\u0001\n\u0013!\u0006b\u0002-\u0006\u0001\u0004%I!\u0017\u0005\u0007?\u0016\u0001\u000b\u0015B+\t\u000b\u0001,A\u0011A1\t\u000b\t,A\u0011\u0001+\u0003\u001dM#\u0018\r^;t\u001fB,'/\u0019;pe*\u0011abD\u0001\t_B,'/\u0019;pe*\u0011\u0001#E\u0001\u0006M2Lgn\u001b\u0006\u0003%M\t\u0001#\u001a8hS:,7m\u001c8oa2,x-\u001b8\u000b\u0005Q)\u0012A\u00027j].L7O\u0003\u0002\u0017/\u00051\u0011\r]1dQ\u0016T\u0011\u0001G\u0001\u0004_J<7\u0001A\n\u0005\u0001m\t#\u0006\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VM\u001a\t\u0003E!j\u0011a\t\u0006\u0003\u001d\u0011R!!\n\u0014\u0002\r\r|W.\\8o\u0015\t93#A\u0004nC:\fw-\u001a:\n\u0005%\u001a#\u0001C(qKJ\fGo\u001c:\u0011\u0005-zS\"\u0001\u0017\u000b\u00055r\u0013!B;uS2\u001c(BA\u0013\u0014\u0013\t\u0001DFA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005\u0019\u0004C\u0001\u001b\u0001\u001b\u0005i\u0011\u0001C4fi:\u000bW.Z:\u0016\u0003]\u00022\u0001\b\u001d;\u0013\tITDA\u0003BeJ\f\u0017\u0010\u0005\u0002<\u0005:\u0011A\b\u0011\t\u0003{ui\u0011A\u0010\u0006\u0003\u007fe\ta\u0001\u0010:p_Rt\u0014BA!\u001e\u0003\u0019\u0001&/\u001a3fM&\u00111\t\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0005k\u0012!B1qa2LHCA$N!\u0011Y\u0004J\u000f&\n\u0005%#%aA'baB\u0011AdS\u0005\u0003\u0019v\u00111!\u00118z\u0011\u0015q5\u0001q\u0001H\u0003\u0019\u0001\u0018M]1ng\u0006q1\u000b^1ukN|\u0005/\u001a:bi>\u0014\bC\u0001\u001b\u0006'\r)1D\u000b\u000b\u0002!\u0006Q\u0001.\u00198eg\"\f7.\u001a3\u0016\u0003U\u0003\"\u0001\b,\n\u0005]k\"a\u0002\"p_2,\u0017M\\\u0001\u000fQ\u0006tGm\u001d5bW\u0016$w\fJ3r)\tQV\f\u0005\u0002\u001d7&\u0011A,\b\u0002\u0005+:LG\u000fC\u0004_\u0011\u0005\u0005\t\u0019A+\u0002\u0007a$\u0013'A\u0006iC:$7\u000f[1lK\u0012\u0004\u0013\u0001D1eI\"\u000bg\u000eZ:iC.,G#\u0001.\u0002\u0019%\u001c\b*\u00198eg\"\f7.\u001a3")
public class StatusOperator
implements Operator,
Logging {
    private Logger logger;
    private volatile boolean bitmap$0;

    public static boolean isHandshaked() {
        return StatusOperator$.MODULE$.isHandshaked();
    }

    public static void addHandshake() {
        StatusOperator$.MODULE$.addHandshake();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    public <T> T getAs(String key, Function0<T> defaultVal, Map<String, Object> parameters) {
        return (T)Operator.getAs$((Operator)this, (String)key, defaultVal, parameters);
    }

    public <T> T getAsThrow(String key, Map<String, Object> parameters) {
        return (T)Operator.getAsThrow$((Operator)this, (String)key, parameters);
    }

    private Logger logger$lzycompute() {
        StatusOperator statusOperator = this;
        synchronized (statusOperator) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String[] getNames() {
        return (String[])((Object[])new String[]{"status"});
    }

    public Map<String, Object> apply(Map<String, Object> params) {
        Map map;
        Object object = new Object();
        try {
            String appIdStr = (String)params.getOrElse((Object)ECConstants$.MODULE$.YARN_APPID_NAME_KEY(), (Function0 & Serializable & scala.Serializable)() -> "");
            String[] parts = appIdStr.split("_");
            long clusterTimestamp = new StringOps(Predef$.MODULE$.augmentString(parts[1])).toLong();
            int sequenceNumber = new StringOps(Predef$.MODULE$.augmentString(parts[2])).toInt();
            ApplicationId appId = ApplicationId.newInstance((long)clusterTimestamp, (int)sequenceNumber);
            HashMap rsMap = new HashMap();
            YarnClient yarnClient = YarnUtil$.MODULE$.getYarnClient();
            ObjectRef appReport = ObjectRef.create(null);
            Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                appReport$1.elem = yarnClient.getApplicationReport(appId);
                if ((ApplicationReport)appReport$1.elem == null) {
                    throw YarnUtil$.MODULE$.logAndException(new StringBuilder(31).append("Got null appReport for appid : ").append(appIdStr).toString(), YarnUtil$.MODULE$.logAndException$default$2());
                }
            }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
                StatusOperator.$anonfun$apply$3(this, appIdStr, rsMap, object, x0$1);
                return BoxedUnit.UNIT;
            });
            FinalApplicationStatus finalApplicationStatus = ((ApplicationReport)appReport.elem).getFinalApplicationStatus();
            FinalApplicationStatus finalApplicationStatus2 = FinalApplicationStatus.UNDEFINED;
            YarnApplicationState appStatus = (finalApplicationStatus == null ? finalApplicationStatus2 != null : !finalApplicationStatus.equals(finalApplicationStatus2)) ? ((ApplicationReport)appReport.elem).getFinalApplicationStatus() : ((ApplicationReport)appReport.elem).getYarnApplicationState();
            NodeStatus nodeStatus = YarnUtil$.MODULE$.convertYarnStateToNodeStatus(appIdStr, appStatus.toString());
            this.logger().info(new StringBuilder(28).append("try to get appid: ").append(appIdStr).append(", status ").append(nodeStatus.toString()).append(".").toString());
            rsMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ECConstants$.MODULE$.NODE_STATUS_KEY()), (Object)nodeStatus.toString()));
            rsMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ECConstants$.MODULE$.YARN_APPID_NAME_KEY()), (Object)appIdStr));
            map = rsMap.toMap(Predef$.MODULE$.$conforms());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                map = (Map)ex.value();
            }
            throw ex;
        }
        return map;
    }

    public static final /* synthetic */ void $anonfun$apply$3(StatusOperator $this, String appIdStr$1, HashMap rsMap$1, Object nonLocalReturnKey1$1, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof ApplicationNotFoundException) {
            $this.logger().error(new StringBuilder(57).append("Application : ").append(appIdStr$1).append(" not exists, will set the status to failed.").toString());
            rsMap$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ECConstants$.MODULE$.NODE_STATUS_KEY()), (Object)NodeStatus.Failed.toString()));
            rsMap$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ECConstants$.MODULE$.YARN_APPID_NAME_KEY()), (Object)appIdStr$1));
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)rsMap$1.toMap(Predef$.MODULE$.$conforms()));
        }
        throw new MatchError((Object)throwable);
    }

    public StatusOperator() {
        Operator.$init$((Operator)this);
        Logging.$init$((Logging)this);
    }
}

