/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.operator;

import java.io.Serializable;
import java.util.Collection;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconnplugin.flink.constants.FlinkECConstant$;
import org.apache.linkis.engineconnplugin.flink.operator.clientmanager.FlinkRestClientManager$;
import org.apache.linkis.engineconnplugin.flink.util.YarnUtil$;
import org.apache.linkis.governance.common.constant.ec.ECConstants$;
import org.apache.linkis.manager.common.operator.Operator;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u001d3A\u0001B\u0003\u0001%!)\u0011\u0006\u0001C\u0001U!)Q\u0006\u0001C!]!)Q\b\u0001C!}\ta1*\u001b7m\u001fB,'/\u0019;pe*\u0011aaB\u0001\t_B,'/\u0019;pe*\u0011\u0001\"C\u0001\u0006M2Lgn\u001b\u0006\u0003\u0015-\t\u0001#\u001a8hS:,7m\u001c8oa2,x-\u001b8\u000b\u00051i\u0011A\u00027j].L7O\u0003\u0002\u000f\u001f\u00051\u0011\r]1dQ\u0016T\u0011\u0001E\u0001\u0004_J<7\u0001A\n\u0005\u0001MI\"\u0005\u0005\u0002\u0015/5\tQCC\u0001\u0017\u0003\u0015\u00198-\u00197b\u0013\tARC\u0001\u0004B]f\u0014VM\u001a\t\u00035\u0001j\u0011a\u0007\u0006\u0003\rqQ!!\b\u0010\u0002\r\r|W.\\8o\u0015\ty2\"A\u0004nC:\fw-\u001a:\n\u0005\u0005Z\"\u0001C(qKJ\fGo\u001c:\u0011\u0005\r:S\"\u0001\u0013\u000b\u0005\u00152\u0013!B;uS2\u001c(BA\u000f\f\u0013\tACEA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005Y\u0003C\u0001\u0017\u0001\u001b\u0005)\u0011\u0001C4fi:\u000bW.Z:\u0016\u0003=\u00022\u0001\u0006\u00193\u0013\t\tTCA\u0003BeJ\f\u0017\u0010\u0005\u00024u9\u0011A\u0007\u000f\t\u0003kUi\u0011A\u000e\u0006\u0003oE\ta\u0001\u0010:p_Rt\u0014BA\u001d\u0016\u0003\u0019\u0001&/\u001a3fM&\u00111\b\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005e*\u0012!B1qa2LHCA F!\u0011\u0019\u0004I\r\"\n\u0005\u0005c$aA'baB\u0011AcQ\u0005\u0003\tV\u00111!\u00118z\u0011\u001515\u0001q\u0001@\u0003\u0019\u0001\u0018M]1ng\u0002")
public class KillOperator
implements Operator,
Logging {
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    public <T> T getAs(String key, Function0<T> defaultVal, Map<String, Object> parameters) {
        return (T)Operator.getAs$((Operator)this, (String)key, defaultVal, parameters);
    }

    public <T> T getAsThrow(String key, Map<String, Object> parameters) {
        return (T)Operator.getAsThrow$((Operator)this, (String)key, parameters);
    }

    private Logger logger$lzycompute() {
        KillOperator killOperator = this;
        synchronized (killOperator) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String[] getNames() {
        return (String[])((Object[])new String[]{"kill"});
    }

    public Map<String, Object> apply(Map<String, Object> params) {
        BoxedUnit boxedUnit;
        HashMap rsMap = new HashMap();
        String appIdStr = (String)params.getOrElse((Object)ECConstants$.MODULE$.YARN_APPID_NAME_KEY(), (Function0 & Serializable & scala.Serializable)() -> "");
        boolean snapShot = new StringOps(Predef$.MODULE$.augmentString(params.getOrElse((Object)FlinkECConstant$.MODULE$.SNAPHOT_KEY(), (Function0 & Serializable & scala.Serializable)() -> "false").toString())).toBoolean();
        ApplicationId appId = YarnUtil$.MODULE$.retrieveApplicationId(appIdStr);
        BooleanRef isStopped = BooleanRef.create((boolean)false);
        RestClusterClient restClient = (RestClusterClient)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> FlinkRestClientManager$.MODULE$.getFlinkRestClient(appIdStr), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof Exception) {
                Exception exception = (Exception)throwable;
                YarnClient yarnClient = YarnUtil$.MODULE$.getYarnClient();
                ApplicationReport appReport = yarnClient.getApplicationReport(appId);
                FinalApplicationStatus finalApplicationStatus = appReport.getFinalApplicationStatus();
                FinalApplicationStatus finalApplicationStatus2 = FinalApplicationStatus.UNDEFINED;
                if (finalApplicationStatus == null ? finalApplicationStatus2 != null : !finalApplicationStatus.equals(finalApplicationStatus2)) {
                    String msg = new StringBuilder(85).append("The application ").append(appIdStr).append(" doesn't run anymore. It has previously completed with final status: ").append(appReport.getFinalApplicationStatus().toString()).toString();
                    YarnUtil$.MODULE$.logAndException(msg, YarnUtil$.MODULE$.logAndException$default$2());
                    isStopped$1.elem = true;
                    return null;
                }
                String msg = new StringBuilder(38).append("Get client for app ").append(appIdStr).append(" failed, because : ").append(exception.getMessage()).toString();
                throw YarnUtil$.MODULE$.logAndException(msg, YarnUtil$.MODULE$.logAndException$default$2());
            }
            throw new MatchError((Object)throwable);
        });
        if (!isStopped.elem) {
            BoxedUnit boxedUnit2;
            if (snapShot) {
                String checkPointPath = (String)params.getOrElse((Object)FlinkECConstant$.MODULE$.SAVAPOINT_PATH_KEY(), (Function0 & Serializable & scala.Serializable)() -> null);
                String rs = YarnUtil$.MODULE$.triggerSavepoint(appIdStr, checkPointPath, (RestClusterClient<ApplicationId>)restClient);
                boxedUnit2 = rsMap.put((Object)FlinkECConstant$.MODULE$.MSG_KEY(), (Object)rs);
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            ObjectRef msg = ObjectRef.create((Object)"");
            Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Collection jobs = (Collection)restClient.listJobs().get();
                if (jobs == null || jobs.isEmpty()) {
                    String msg = new StringBuilder(38).append("App : ").append(appIdStr).append(" have no jobs, but is not ended.").toString();
                    throw YarnUtil$.MODULE$.logAndException(msg, YarnUtil$.MODULE$.logAndException$default$2());
                }
                msg$1.elem = new StringBuilder(27).append("Try to kill ").append(jobs.size()).append(" jobs of app : ").append(appIdStr).toString();
                ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(jobs).asScala()).foreach((Function1 & Serializable & scala.Serializable)job -> restClient.cancel(job.getJobId()));
            }, (Function1 & Serializable & scala.Serializable)x0$2 -> {
                KillOperator.$anonfun$apply$8(this, appIdStr, appId, restClient, x0$2);
                return BoxedUnit.UNIT;
            });
            boxedUnit = rsMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)FlinkECConstant$.MODULE$.MSG_KEY()), (Object)((String)msg.elem)));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return rsMap.toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ void $anonfun$apply$8(KillOperator $this, String appIdStr$1, ApplicationId appId$1, RestClusterClient restClient$1, Throwable x0$2) {
        Throwable throwable = x0$2;
        if (throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            $this.logger().error(new StringBuilder(67).append("Error on killing jobs of appid : ").append(appIdStr$1).append(", will kill it by yarn, because : ").append(exception.getMessage()).toString(), (Throwable)exception);
            YarnUtil$.MODULE$.getYarnClient().killApplication(appId$1);
            FlinkRestClientManager$.MODULE$.removeFlinkRestClient(appIdStr$1, (RestClusterClient<ApplicationId>)restClient$1);
            return;
        }
        throw new MatchError((Object)throwable);
    }

    public KillOperator() {
        Operator.$init$((Operator)this);
        Logging.$init$((Logging)this);
    }
}

