/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.utils;

import java.io.File;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;

public class YarnConfLoader {
    public static YarnConfiguration getYarnConf(String yarnConfDir) {
        YarnConfiguration yarnConf = new YarnConfiguration();
        try {
            File[] xmlFileList;
            File dir = new File(yarnConfDir);
            if (dir.exists() && dir.isDirectory() && (xmlFileList = new File(yarnConfDir).listFiles((dir1, name) -> name.endsWith(".xml"))) != null) {
                for (File xmlFile : xmlFileList) {
                    yarnConf.addResource(xmlFile.toURI().toURL());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        YarnConfLoader.haYarnConf((Configuration)yarnConf);
        return yarnConf;
    }

    private static Configuration haYarnConf(Configuration yarnConf) {
        for (Map.Entry entry : yarnConf) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith("yarn.resourcemanager.hostname.")) continue;
            String rm = key.substring("yarn.resourcemanager.hostname.".length());
            String addressKey = "yarn.resourcemanager.address." + rm;
            if (yarnConf.get(addressKey) != null) continue;
            yarnConf.set(addressKey, value + ":" + 8032);
        }
        return yarnConf;
    }
}

