/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.sql.parser;

import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;

public enum SqlCommand {
    LINKIS_GRAMMAR,
    SELECT,
    INSERT_INTO,
    INSERT_OVERWRITE,
    CREATE_TABLE,
    ALTER_TABLE,
    DROP_TABLE,
    CREATE_CATALOG,
    DROP_CATALOG,
    CREATE_VIEW,
    DROP_VIEW,
    CREATE_DATABASE,
    CREATE_FUNCTION,
    ALTER_DATABASE,
    DROP_DATABASE,
    USE_CATALOG,
    USE,
    SHOW_CATALOGS,
    SHOW_DATABASES,
    SHOW_TABLES,
    SHOW_FUNCTIONS,
    EXPLAIN,
    DESCRIBE_TABLE,
    RESET,
    SET("SET", Inner_Config.access$000()),
    SHOW_MODULES("SHOW\\s+MODULES", Inner_Config.access$000()),
    SHOW_VIEWS("SHOW\\s+VIEWS", Inner_Config.access$000()),
    SHOW_CURRENT_CATALOG("SHOW\\s+CURRENT\\s+CATALOG", Inner_Config.access$000()),
    SHOW_CURRENT_DATABASE("SHOW\\s+CURRENT\\s+DATABASE", Inner_Config.access$000());

    private final Pattern pattern;
    private final Function<String[], Optional<String[]>> operandConverter;

    private SqlCommand(String matchingRegex, Function<String[], Optional<String[]>> operandConverter) {
        this.pattern = Pattern.compile(matchingRegex, 34);
        this.operandConverter = operandConverter;
    }

    private SqlCommand() {
        this.pattern = null;
        this.operandConverter = null;
    }

    public String toString() {
        return super.toString().replace('_', ' ');
    }

    boolean hasPattern() {
        return this.pattern != null && this.operandConverter != null;
    }

    Pattern getPattern() {
        return this.pattern;
    }

    Function<String[], Optional<String[]>> getOperandConverter() {
        return this.operandConverter;
    }

    static class Inner_Config {
        private static final Function<String[], Optional<String[]>> NO_OPERANDS = operands -> Optional.of(new String[0]);
        private static final int DEFAULT_PATTERN_FLAGS = 34;

        Inner_Config() {
        }

        static /* synthetic */ Function access$000() {
            return NO_OPERANDS;
        }
    }
}

