/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.result;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.stream.Stream;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.net.ConnectionUtils;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.runtime.types.TypeInfoDataTypeConverter;
import org.apache.linkis.engineconnplugin.flink.client.result.BatchResult;
import org.apache.linkis.engineconnplugin.flink.client.result.ChangelogResult;
import org.apache.linkis.engineconnplugin.flink.client.shims.config.Environment;
import org.apache.linkis.engineconnplugin.flink.client.shims.config.entries.DeploymentEntry;
import org.apache.linkis.engineconnplugin.flink.client.shims.errorcode.FlinkErrorCodeSummary;
import org.apache.linkis.engineconnplugin.flink.client.shims.exception.SqlExecutionException;

public class ResultUtil {
    public static <C> BatchResult<C> createBatchResult(TableSchema schema, ExecutionConfig config) {
        TypeInformation[] schemaTypeInfos = (TypeInformation[])Stream.of(schema.getFieldDataTypes()).map(TypeInfoDataTypeConverter::fromDataTypeToTypeInfo).toArray(TypeInformation[]::new);
        RowTypeInfo outputType = new RowTypeInfo(schemaTypeInfos, schema.getFieldNames());
        return new BatchResult(schema, outputType, config);
    }

    public static ChangelogResult createChangelogResult(Configuration flinkConfig, Environment env, TableSchema schema, ExecutionConfig config) throws SqlExecutionException {
        TypeInformation[] schemaTypeInfos = (TypeInformation[])Stream.of(schema.getFieldDataTypes()).map(TypeInfoDataTypeConverter::fromDataTypeToTypeInfo).toArray(TypeInformation[]::new);
        RowTypeInfo outputType = new RowTypeInfo(schemaTypeInfos, schema.getFieldNames());
        InetAddress gatewayAddress = ResultUtil.getGatewayAddress(env.getDeployment(), flinkConfig);
        int gatewayPort = ResultUtil.getGatewayPort(env.getDeployment());
        int maxBufferSize = env.getExecution().getMaxTableResultRows();
        return new ChangelogResult(outputType, schema, config, gatewayAddress, gatewayPort, maxBufferSize);
    }

    private static int getGatewayPort(DeploymentEntry deploy) {
        return deploy.getGatewayPort();
    }

    private static InetAddress getGatewayAddress(DeploymentEntry deploy, Configuration flinkConfig) throws SqlExecutionException {
        String address = deploy.getGatewayAddress();
        if (!address.isEmpty()) {
            try {
                return InetAddress.getByName(address);
            }
            catch (UnknownHostException e) {
                throw new SqlExecutionException(FlinkErrorCodeSummary.NOT_SOCKET_RETRIEVAL.getErrorDesc() + address, (Throwable)e);
            }
        }
        String jobManagerAddress = flinkConfig.getString(JobManagerOptions.ADDRESS);
        int jobManagerPort = flinkConfig.getInteger(JobManagerOptions.PORT);
        if (jobManagerAddress != null && !jobManagerAddress.isEmpty()) {
            try {
                return ConnectionUtils.findConnectingAddress((InetSocketAddress)new InetSocketAddress(jobManagerAddress, jobManagerPort), (long)deploy.getResponseTimeout(), (long)400L);
            }
            catch (Exception e) {
                throw new SqlExecutionException(FlinkErrorCodeSummary.NOT_DETERMINE_ADDRESS_JOB.getErrorDesc(), (Throwable)e);
            }
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new SqlExecutionException(FlinkErrorCodeSummary.NOT_DETERMINE_ADDRESS.getErrorDesc(), (Throwable)e);
        }
    }
}

