/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.factory;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.KubernetesClusterClientFactory;
import org.apache.flink.kubernetes.KubernetesClusterDescriptor;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.kubeclient.FlinkKubeClient;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.Preconditions;
import org.apache.linkis.engineconnplugin.flink.client.config.FlinkVersionThreadLocal;
import org.apache.linkis.engineconnplugin.flink.config.FlinkEnvConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkisKubernetesClusterClientFactory
extends KubernetesClusterClientFactory
implements Closeable {
    private static final String CLUSTER_ID_PREFIX = "flink-cluster-";
    private Configuration configuration;
    private FlinkKubeClient flinkKubeClient;
    private String clusterId;
    private static final Logger LOG = LoggerFactory.getLogger(LinkisKubernetesClusterClientFactory.class);

    public KubernetesClusterDescriptor createClusterDescriptor(Configuration configuration) {
        this.configuration = configuration;
        Preconditions.checkNotNull((Object)configuration);
        if (!configuration.contains(KubernetesConfigOptions.CLUSTER_ID)) {
            this.clusterId = this.generateClusterId();
            configuration.setString(KubernetesConfigOptions.CLUSTER_ID, this.clusterId);
        }
        if (FlinkVersionThreadLocal.getFlinkVersion().equals(FlinkEnvConfiguration.FLINK_1_12_2_VERSION())) {
            try {
                Class<?> clazz = Class.forName("org.apache.flink.kubernetes.kubeclient.DefaultKubeClientFactory");
                Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                Object obj = constructor.newInstance(new Object[0]);
                Method method = clazz.getDeclaredMethod("fromConfiguration", Configuration.class);
                method.setAccessible(true);
                this.flinkKubeClient = (FlinkKubeClient)method.invoke(obj, configuration);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (FlinkVersionThreadLocal.getFlinkVersion().equals(FlinkEnvConfiguration.FLINK_1_16_2_VERSION())) {
            try {
                Class<?> clazz = Class.forName("org.apache.flink.kubernetes.kubeclient.FlinkKubeClientFactory");
                Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                Object obj = constructor.newInstance(new Object[0]);
                Method method = clazz.getDeclaredMethod("fromConfiguration", Configuration.class, String.class);
                method.setAccessible(true);
                this.flinkKubeClient = (FlinkKubeClient)method.invoke(obj, configuration, "client");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return new KubernetesClusterDescriptor(configuration, this.flinkKubeClient);
    }

    @Override
    public void close() throws IOException {
        try {
            this.flinkKubeClient.stopAndCleanupCluster(this.clusterId);
        }
        catch (Exception e) {
            LOG.error("Could not kill Kubernetes cluster " + this.clusterId);
        }
        try {
            this.flinkKubeClient.close();
        }
        catch (Exception e) {
            LOG.error("failed to close client, exception {}", (Object)e.toString());
        }
    }

    private String generateClusterId() {
        String randomID = new AbstractID().toString();
        return (CLUSTER_ID_PREFIX + randomID).substring(0, 45);
    }
}

