/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.deployment;

import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.kubernetes.configuration.KubernetesDeploymentTarget;
import org.apache.flink.yarn.configuration.YarnDeploymentTarget;
import org.apache.linkis.engineconnplugin.flink.client.context.ExecutionContext;
import org.apache.linkis.engineconnplugin.flink.client.deployment.ClusterDescriptorAdapter;
import org.apache.linkis.engineconnplugin.flink.client.deployment.KubernetesApplicationClusterDescriptorAdapter;
import org.apache.linkis.engineconnplugin.flink.client.deployment.KubernetesSessionClusterDescriptorAdapter;
import org.apache.linkis.engineconnplugin.flink.client.deployment.YarnApplicationClusterDescriptorAdapter;
import org.apache.linkis.engineconnplugin.flink.client.deployment.YarnPerJobClusterDescriptorAdapter;
import org.apache.linkis.engineconnplugin.flink.client.deployment.YarnSessionClusterDescriptorAdapter;

public class ClusterDescriptorAdapterFactory {
    public static ClusterDescriptorAdapter create(ExecutionContext executionContext) {
        String flinkDeploymentTarget = (String)executionContext.getFlinkConfig().get(DeploymentOptions.TARGET);
        ClusterDescriptorAdapter clusterDescriptorAdapter = null;
        if (YarnDeploymentTarget.PER_JOB.getName().equals(flinkDeploymentTarget)) {
            clusterDescriptorAdapter = new YarnPerJobClusterDescriptorAdapter(executionContext);
        } else if (YarnDeploymentTarget.APPLICATION.getName().equals(flinkDeploymentTarget)) {
            clusterDescriptorAdapter = new YarnApplicationClusterDescriptorAdapter(executionContext);
        } else if (YarnDeploymentTarget.SESSION.getName().equals(flinkDeploymentTarget)) {
            clusterDescriptorAdapter = new YarnSessionClusterDescriptorAdapter(executionContext);
        } else if (KubernetesDeploymentTarget.APPLICATION.getName().equals(flinkDeploymentTarget)) {
            clusterDescriptorAdapter = new KubernetesApplicationClusterDescriptorAdapter(executionContext);
        } else if (KubernetesDeploymentTarget.SESSION.getName().equals(flinkDeploymentTarget)) {
            clusterDescriptorAdapter = new KubernetesSessionClusterDescriptorAdapter(executionContext);
        }
        return clusterDescriptorAdapter;
    }
}

