/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.ecm.server.operator;

import java.io.Closeable;
import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.ecm.errorcode.EngineconnServerErrorCodeSummary;
import org.apache.linkis.ecm.server.conf.ECMConfiguration$;
import org.apache.linkis.ecm.server.exception.ECMErrorException;
import org.apache.linkis.ecm.server.operator.EngineConnLogOperator$;
import org.apache.linkis.manager.common.operator.Operator;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001B\f\u0019\u0001\u0015BQ\u0001\u0010\u0001\u0005\u0002uBQ\u0001\u0011\u0001\u0005B\u0005CQ\u0001\u0015\u0001\u0005BECQA\u0017\u0001\u0005\u0012mCQ!\u001a\u0001\u0005\u0012\u0019DQa\u001c\u0001\u0005\u0012ADQ!\u001e\u0001\u0005\nY<q!!\u0001\u0019\u0011\u0003\t\u0019A\u0002\u0004\u00181!\u0005\u0011Q\u0001\u0005\u0007y%!\t!a\u0002\t\u0013\u0005%\u0011B1A\u0005\u0002\u0005-\u0001\u0002CA\f\u0013\u0001\u0006I!!\u0004\t\u0013\u0005e\u0011B1A\u0005\u0002\u0005m\u0001\u0002CA\u0015\u0013\u0001\u0006I!!\b\t\u0013\u0005-\u0012B1A\u0005\u0002\u00055\u0002\u0002CA\u001c\u0013\u0001\u0006I!a\f\t\u0013\u0005e\u0012B1A\u0005\u0002\u00055\u0002\u0002CA\u001e\u0013\u0001\u0006I!a\f\t\u0013\u0005u\u0012B1A\u0005\u0002\u0005m\u0001\u0002CA \u0013\u0001\u0006I!!\b\t\u0013\u0005\u0005\u0013B1A\u0005\u0002\u00055\u0002\u0002CA\"\u0013\u0001\u0006I!a\f\u0003+\u0015sw-\u001b8f\u0007>tg\u000eT8h\u001fB,'/\u0019;pe*\u0011\u0011DG\u0001\t_B,'/\u0019;pe*\u00111\u0004H\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005uq\u0012aA3d[*\u0011q\u0004I\u0001\u0007Y&t7.[:\u000b\u0005\u0005\u0012\u0013AB1qC\u000eDWMC\u0001$\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\u0005L\u001b\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\r\u0005s\u0017PU3g!\ti3'D\u0001/\u0015\tIrF\u0003\u00021c\u000511m\\7n_:T!A\r\u0010\u0002\u000f5\fg.Y4fe&\u0011AG\f\u0002\t\u001fB,'/\u0019;peB\u0011aGO\u0007\u0002o)\u0011\u0001(O\u0001\u0006kRLGn\u001d\u0006\u0003ayI!aO\u001c\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012A\u0010\t\u0003\u007f\u0001i\u0011\u0001G\u0001\tO\u0016$h*Y7fgV\t!\tE\u0002(\u0007\u0016K!\u0001\u0012\u0015\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u0019keBA$L!\tA\u0005&D\u0001J\u0015\tQE%\u0001\u0004=e>|GOP\u0005\u0003\u0019\"\na\u0001\u0015:fI\u00164\u0017B\u0001(P\u0005\u0019\u0019FO]5oO*\u0011A\nK\u0001\u0006CB\u0004H.\u001f\u000b\u0003%b\u0003BAR*F+&\u0011Ak\u0014\u0002\u0004\u001b\u0006\u0004\bCA\u0014W\u0013\t9\u0006FA\u0002B]fDQ!W\u0002A\u0004I\u000b!\u0002]1sC6,G/\u001a:t\u0003)9W\r\u001e'pOB\u000bG\u000f\u001b\u000b\u00039\u0012\u0004\"!\u00182\u000e\u0003yS!a\u00181\u0002\u0005%|'\"A1\u0002\t)\fg/Y\u0005\u0003Gz\u0013AAR5mK\")\u0011\f\u0002a\u0002%\u0006qq-\u001a;MS:,\u0007+\u0019;uKJtW#A4\u0011\u0005!lW\"A5\u000b\u0005)\\\u0017\u0001C7bi\u000eD\u0017N\\4\u000b\u00051D\u0013\u0001B;uS2L!A\\5\u0003\u000bI+w-\u001a=\u0002#\u001d,G/\u00128hS:,7i\u001c8o\u0013:4w\u000e\u0006\u0002riB)qE]#F\u000b&\u00111\u000f\u000b\u0002\u0007)V\u0004H.Z\u001a\t\u000be3\u00019\u0001*\u0002\u0017%t7\r\\;eK2Kg.\u001a\u000b\u0005ojdh\u0010\u0005\u0002(q&\u0011\u0011\u0010\u000b\u0002\b\u0005>|G.Z1o\u0011\u0015Yx\u00011\u0001F\u0003\u0011a\u0017N\\3\t\u000bu<\u0001\u0019\u0001\"\u0002\u001f=tG._&fs^|'\u000f\u001a'jgRDQa`\u0004A\u0002\t\u000b\u0011#[4o_J,7*Z=x_J$G*[:u\u0003U)enZ5oK\u000e{gN\u001c'pO>\u0003XM]1u_J\u0004\"aP\u0005\u0014\u0005%1CCAA\u0002\u00035y\u0005+\u0012*B)>\u0013vLT!N\u000bV\u0011\u0011Q\u0002\t\u0005\u0003\u001f\t)\"\u0004\u0002\u0002\u0012)\u0019\u00111\u00031\u0002\t1\fgnZ\u0005\u0004\u001d\u0006E\u0011AD(Q\u000bJ\u000bEk\u0014*`\u001d\u0006kU\tI\u0001\u000e\u0019>;uLR%M\u000b~s\u0015)T#\u0016\u0005\u0005u\u0001CBA\u0010\u0003K\ti!\u0004\u0002\u0002\")\u0019\u00111E\u001d\u0002\t\r|gNZ\u0005\u0005\u0003O\t\tC\u0001\u0006D_6lwN\u001c,beN\fa\u0002T(H?\u001aKE*R0O\u00036+\u0005%\u0001\nN\u0003b{FjT$`\r\u0016#6\tS0T\u0013j+UCAA\u0018!\u0019\ty\"!\n\u00022A\u0019q%a\r\n\u0007\u0005U\u0002FA\u0002J]R\f1#T!Y?2{ui\u0018$F)\u000eCulU%[\u000b\u0002\nq#T!Y?2{ui\u0018+B\u00132{6\u000bV!S)~\u001b\u0016JW#\u000215\u000b\u0005l\u0018'P\u000f~#\u0016)\u0013'`'R\u000b%\u000bV0T\u0013j+\u0005%A\tN+2#\u0016\nT%O\u000b~\u0003\u0016\t\u0016+F%:\u000b!#T+M)&c\u0015JT#`!\u0006#F+\u0012*OA\u0005iQ*\u0016'U\u00132Ke*R0N\u0003b\u000ba\"T+M)&c\u0015JT#`\u001b\u0006C\u0006\u0005")
public class EngineConnLogOperator
implements Operator,
Logging {
    private Logger logger;
    private volatile boolean bitmap$0;

    public static CommonVars<Object> MULTILINE_MAX() {
        return EngineConnLogOperator$.MODULE$.MULTILINE_MAX();
    }

    public static CommonVars<String> MULTILINE_PATTERN() {
        return EngineConnLogOperator$.MODULE$.MULTILINE_PATTERN();
    }

    public static CommonVars<Object> MAX_LOG_TAIL_START_SIZE() {
        return EngineConnLogOperator$.MODULE$.MAX_LOG_TAIL_START_SIZE();
    }

    public static CommonVars<Object> MAX_LOG_FETCH_SIZE() {
        return EngineConnLogOperator$.MODULE$.MAX_LOG_FETCH_SIZE();
    }

    public static CommonVars<String> LOG_FILE_NAME() {
        return EngineConnLogOperator$.MODULE$.LOG_FILE_NAME();
    }

    public static String OPERATOR_NAME() {
        return EngineConnLogOperator$.MODULE$.OPERATOR_NAME();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    public <T> T getAs(String key, Function0<T> defaultVal, Map<String, Object> parameters) {
        return (T)Operator.getAs$((Operator)this, (String)key, defaultVal, parameters);
    }

    public <T> T getAsThrow(String key, Map<String, Object> parameters) {
        return (T)Operator.getAsThrow$((Operator)this, (String)key, parameters);
    }

    private Logger logger$lzycompute() {
        EngineConnLogOperator engineConnLogOperator = this;
        synchronized (engineConnLogOperator) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String[] getNames() {
        return (String[])((Object[])new String[]{EngineConnLogOperator$.MODULE$.OPERATOR_NAME()});
    }

    public Map<String, Object> apply(Map<String, Object> parameters) {
        File logPath = this.getLogPath(parameters);
        int lastRows = BoxesRunTime.unboxToInt(this.getAs("lastRows", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0, parameters));
        int pageSize = BoxesRunTime.unboxToInt(this.getAs("pageSize", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 100, parameters));
        int fromLine = BoxesRunTime.unboxToInt(this.getAs("fromLine", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1, parameters));
        boolean enableTail = BoxesRunTime.unboxToBoolean(this.getAs("enableTail", (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, parameters));
        if (lastRows > BoxesRunTime.unboxToInt((Object)EngineConnLogOperator$.MODULE$.MAX_LOG_FETCH_SIZE().getValue())) {
            throw new ECMErrorException(EngineconnServerErrorCodeSummary.CANNOT_FETCH_MORE_THAN.getErrorCode(), MessageFormat.format(EngineconnServerErrorCodeSummary.CANNOT_FETCH_MORE_THAN.getErrorDesc(), EngineConnLogOperator$.MODULE$.MAX_LOG_FETCH_SIZE().getValue().toString()));
        }
        if (lastRows > 0) {
            String[] logs = Utils$.MODULE$.exec((String[])((Object[])new String[]{"tail", "-n", new StringBuilder(0).append(lastRows).toString(), logPath.getPath()}), 5000L).split("\n");
            return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logs"), (Object)logs), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rows"), (Object)BoxesRunTime.boxToInteger((int)logs.length))}));
        }
        String ignoreKeywords = (String)this.getAs("ignoreKeywords", (Function0 & Serializable & scala.Serializable)() -> "", parameters);
        String[] ignoreKeywordList = StringUtils.isNotEmpty((CharSequence)ignoreKeywords) ? ignoreKeywords.split(",") : (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        String onlyKeywords = (String)this.getAs("onlyKeywords", (Function0 & Serializable & scala.Serializable)() -> "", parameters);
        String[] onlyKeywordList = StringUtils.isNotEmpty((CharSequence)onlyKeywords) ? onlyKeywords.split(",") : (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        ObjectRef randomReader = ObjectRef.create(null);
        ObjectRef reversedReader = ObjectRef.create(null);
        if (enableTail) {
            this.logger().info("enable log operator from tail to read");
            reversedReader.elem = new ReversedLinesFileReader(logPath, Charset.defaultCharset());
        } else {
            randomReader.elem = new RandomAccessFile(logPath, "r");
        }
        ArrayList logs = new ArrayList(pageSize);
        IntRef readLine = IntRef.create((int)0);
        IntRef skippedLine = IntRef.create((int)0);
        IntRef lineNum = IntRef.create((int)0);
        BooleanRef rowIgnore = BooleanRef.create((boolean)false);
        IntRef ignoreLine = IntRef.create((int)0);
        Regex linePattern = this.getLinePattern();
        int maxMultiline = BoxesRunTime.unboxToInt((Object)EngineConnLogOperator$.MODULE$.MULTILINE_MAX().getValue());
        Utils$.MODULE$.tryFinally((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String line = EngineConnLogOperator.randomAndReversedReadLine$1(randomReader, reversedReader);
            while (readLine$1.elem < pageSize && line != null) {
                ++lineNum$1.elem;
                if (skippedLine$1.elem < fromLine - 1) {
                    ++skippedLine$1.elem;
                } else {
                    if (rowIgnore$1.elem) {
                        Regex regex = linePattern;
                        if (regex != null) {
                            Regex regex2 = regex;
                            if (regex2.findFirstIn((CharSequence)line).isDefined()) {
                                ignoreLine$1.elem = 0;
                                rowIgnore$1.elem = !this.includeLine(line, onlyKeywordList, ignoreKeywordList);
                            } else {
                                ++ignoreLine$1.elem;
                                if (ignoreLine$1.elem >= maxMultiline) {
                                    rowIgnore$1.elem = false;
                                }
                            }
                        } else {
                            rowIgnore$1.elem = !this.includeLine(line, onlyKeywordList, ignoreKeywordList);
                        }
                    } else {
                        boolean bl = rowIgnore$1.elem = !this.includeLine(line, onlyKeywordList, ignoreKeywordList);
                    }
                    if (!rowIgnore$1.elem) {
                        logs.add(line);
                        ++readLine$1.elem;
                    }
                }
                line = EngineConnLogOperator.randomAndReversedReadLine$1(randomReader, reversedReader);
            }
        }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            IOUtils.closeQuietly((Closeable)((RandomAccessFile)randomReader$1.elem));
            IOUtils.closeQuietly((Closeable)((ReversedLinesFileReader)reversedReader$1.elem));
        });
        if (enableTail) {
            Collections.reverse(logs);
        }
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logPath"), (Object)logPath.getPath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logs"), logs), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"endLine"), (Object)BoxesRunTime.boxToInteger((int)lineNum.elem)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rows"), (Object)BoxesRunTime.boxToInteger((int)readLine.elem))}));
    }

    public File getLogPath(Map<String, Object> parameters) {
        Tuple3<String, String, String> tuple3 = this.getEngineConnInfo(parameters);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String ticketId = (String)tuple3._1();
        String engineConnInstance = (String)tuple3._2();
        String engineConnLogDir = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)ticketId, (Object)engineConnInstance, (Object)engineConnLogDir);
        String ticketId2 = (String)tuple32._1();
        String engineConnInstance2 = (String)tuple32._2();
        String engineConnLogDir2 = (String)tuple32._3();
        File logPath = new File(engineConnLogDir2, (String)this.getAs("logType", (Function0 & Serializable & scala.Serializable)() -> (String)EngineConnLogOperator$.MODULE$.LOG_FILE_NAME().getValue(), parameters));
        if (!logPath.exists() || !logPath.isFile()) {
            throw new ECMErrorException(EngineconnServerErrorCodeSummary.LOGFILE_IS_NOT_EXISTS.getErrorCode(), MessageFormat.format(EngineconnServerErrorCodeSummary.LOGFILE_IS_NOT_EXISTS.getErrorDesc(), logPath));
        }
        this.logger().info(new StringBuilder(53).append("Try to fetch EngineConn(id: ").append(ticketId2).append(", instance: ").append(engineConnInstance2).append(") logs from ").append(logPath.getPath()).append(".").toString());
        return logPath;
    }

    public Regex getLinePattern() {
        Option option = Option$.MODULE$.apply(EngineConnLogOperator$.MODULE$.MULTILINE_PATTERN().getValue());
        if (option instanceof Some) {
            Some some = (Some)option;
            String pattern = (String)some.value();
            return new StringOps(Predef$.MODULE$.augmentString(pattern)).r();
        }
        return null;
    }

    public Tuple3<String, String, String> getEngineConnInfo(Map<String, Object> parameters) {
        String logDIrSuffix = (String)this.getAs("logDirSuffix", (Function0 & Serializable & scala.Serializable)() -> "", parameters);
        String ecLogPath = new StringBuilder(0).append(ECMConfiguration$.MODULE$.ENGINECONN_ROOT_DIR()).append(File.separator).append(logDIrSuffix).toString();
        String ticketId = (String)this.getAs("ticketId", (Function0 & Serializable & scala.Serializable)() -> "", parameters);
        return new Tuple3((Object)ticketId, (Object)"", (Object)ecLogPath);
    }

    private boolean includeLine(String line, String[] onlyKeywordList, String[] ignoreKeywordList) {
        boolean accept;
        block0: {
            boolean bl = accept = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ignoreKeywordList)).isEmpty() || !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ignoreKeywordList)).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)line.contains(x$1)));
            if (!accept) break block0;
            accept = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])onlyKeywordList)).isEmpty() || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])onlyKeywordList)).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)line.contains(x$1)));
        }
        return accept;
    }

    private static final String randomAndReversedReadLine$1(ObjectRef randomReader$1, ObjectRef reversedReader$1) {
        if ((RandomAccessFile)randomReader$1.elem != null) {
            String line = ((RandomAccessFile)randomReader$1.elem).readLine();
            if (line != null) {
                return new String(line.getBytes(StandardCharsets.ISO_8859_1), Charset.defaultCharset());
            }
            return null;
        }
        return ((ReversedLinesFileReader)reversedReader$1.elem).readLine();
    }

    public EngineConnLogOperator() {
        Operator.$init$((Operator)this);
        Logging.$init$((Logging)this);
    }
}

