/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.datasourcemanager.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class CryptoUtils {
    private CryptoUtils() {
    }

    public static String object2String(Serializable o) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(o);
            oos.flush();
            oos.close();
            bos.close();
            return new String(new Base64().encode(bos.toByteArray()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object string2Object(String str) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(new Base64().decode(str.getBytes()));
            ObjectInputStream ois = new ObjectInputStream(bis);
            Object o = ois.readObject();
            bis.close();
            ois.close();
            return o;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String md5(String source, String salt, int iterator) {
        StringBuilder token = new StringBuilder();
        try {
            MessageDigest digest = MessageDigest.getInstance("md5");
            if (StringUtils.isNotEmpty((CharSequence)salt)) {
                digest.update(salt.getBytes("UTF-8"));
            }
            byte[] result = digest.digest(source.getBytes());
            for (int i = 0; i < iterator - 1; ++i) {
                digest.reset();
                result = digest.digest(result);
            }
            for (byte aResult : result) {
                int temp = aResult & 0xFF;
                if (temp <= 15) {
                    token.append("0");
                }
                token.append(Integer.toHexString(temp));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return token.toString();
    }
}

