/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.datasourcemanager.common.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"}, ignoreUnknown=true)
public class DataSourceParamKeyDefinition {
    private Long id;
    private String key;
    private String description;
    private String name;
    private String defaultValue;
    private ValueType valueType;
    private Scope scope;
    private boolean require;
    private String valueRegex;
    private Long refId;
    private String refValue;
    private String dataSource;

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    public String getValueRegex() {
        return this.valueRegex;
    }

    public void setValueRegex(String valueRegex) {
        this.valueRegex = valueRegex;
    }

    public boolean isRequire() {
        return this.require;
    }

    public void setRequire(boolean require) {
        this.require = require;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public Long getRefId() {
        return this.refId;
    }

    public void setRefId(Long refId) {
        this.refId = refId;
    }

    public String getRefValue() {
        return this.refValue;
    }

    public void setRefValue(String refValue) {
        this.refValue = refValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSourceParamKeyDefinition that = (DataSourceParamKeyDefinition)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public static enum Scope {
        ENV;

    }

    public static enum ValueType {
        EMAIL(String.class),
        TEXT(String.class),
        TEXTAREA(String.class),
        NUMBER(Long.class),
        SELECT(String.class),
        LIST(List.class),
        MAP(Map.class),
        RADIO(String.class),
        PASSWORD(String.class),
        DATE(Date.class),
        FILE(InputStream.class);

        Class<?> type;

        private ValueType(Class<?> type) {
            this.type = type;
        }

        public Class<?> getJavaType() {
            return this.type;
        }
    }
}

