/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.server.restful;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import org.apache.linkis.cs.common.entity.history.ContextHistory;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.entity.source.ContextKey;
import org.apache.linkis.cs.common.entity.source.ContextKeyValue;
import org.apache.linkis.cs.common.entity.source.ContextValue;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.server.enumeration.ServiceType;
import org.apache.linkis.cs.server.protocol.HttpResponseProtocol;
import org.apache.linkis.cs.server.protocol.RestResponseProtocol;
import org.apache.linkis.cs.server.scheduler.HttpAnswerJob;
import org.apache.linkis.cs.server.util.CsUtils;
import org.apache.linkis.server.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CsRestfulParent {
    public static final Logger logger = LoggerFactory.getLogger(CsRestfulParent.class);

    default public Message generateResponse(HttpAnswerJob job, String responseKey) throws CSErrorException {
        HttpResponseProtocol responseProtocol = job.getResponseProtocol();
        if (responseProtocol instanceof RestResponseProtocol) {
            Message message = ((RestResponseProtocol)responseProtocol).get();
            if (message == null) {
                return Message.error((String)"job execute timeout");
            }
            int status = ((RestResponseProtocol)responseProtocol).get().getStatus();
            if (status == 1) {
                return ((RestResponseProtocol)responseProtocol).get();
            }
            if (status == 0) {
                Object data = job.getResponseProtocol().getResponseData();
                if (data == null) {
                    return Message.ok().data(responseKey, null);
                }
                if (data instanceof List && ((List)data).isEmpty()) {
                    return Message.ok().data(responseKey, (Object)new String[0]);
                }
                if (data instanceof List) {
                    ArrayList<String> strings = new ArrayList<String>();
                    for (Object d : (List)data) {
                        strings.add(CsUtils.serialize(d));
                    }
                    return Message.ok().data(responseKey, strings);
                }
                String dataStr = CsUtils.serialize(data);
                return Message.ok().data(responseKey, (Object)dataStr);
            }
        }
        return Message.ok();
    }

    default public Message generateMessage(Object data, String responseKey) throws CSErrorException {
        if (null != data) {
            if (data instanceof List && ((List)data).isEmpty()) {
                return Message.ok().data(responseKey, (Object)new String[0]);
            }
            if (data instanceof List) {
                ArrayList<String> strings = new ArrayList<String>();
                for (Object d : (List)data) {
                    strings.add(CsUtils.serialize(d));
                }
                return Message.ok().data(responseKey, strings);
            }
            String dataStr = CsUtils.serialize(data);
            return Message.ok().data(responseKey, (Object)dataStr);
        }
        return Message.ok().data(responseKey, null);
    }

    public ServiceType getServiceType();

    default public ContextID getContextIDFromJsonNode(JsonNode jsonNode) throws CSErrorException {
        return (ContextID)this.deserialize(jsonNode, "contextID");
    }

    default public <T> T deserialize(JsonNode jsonNode, String key) throws CSErrorException {
        String str = jsonNode.get(key).textValue();
        logger.info("the contextID: {}", (Object)str);
        return (T)CsUtils.SERIALIZE.deserialize(str);
    }

    default public ContextKey getContextKeyFromJsonNode(JsonNode jsonNode) throws CSErrorException {
        return (ContextKey)this.deserialize(jsonNode, "contextKey");
    }

    default public ContextValue getContextValueFromJsonNode(JsonNode jsonNode) throws CSErrorException {
        return (ContextValue)this.deserialize(jsonNode, "contextValue");
    }

    default public ContextKeyValue getContextKeyValueFromJsonNode(JsonNode jsonNode) throws CSErrorException {
        return (ContextKeyValue)this.deserialize(jsonNode, "contextKeyValue");
    }

    default public ContextHistory getContextHistoryFromJsonNode(JsonNode jsonNode) throws CSErrorException {
        return (ContextHistory)this.deserialize(jsonNode, "contextHistory");
    }
}

